/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.editparts.GridLayer;
import org.eclipse.sapphire.ui.Color;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramModel;

public class SapphireDiagramGridLayer
extends GridLayer {
    private static final Color DEFAULT_MAJOR_LINE_COLOR = new Color(206, 224, 242);
    private static final Color DEFAULT_MINOR_LINE_COLOR = new Color(227, 238, 249);
    private DiagramModel diagramModel;
    private SapphireDiagramEditorPagePart diagramPart;

    public SapphireDiagramGridLayer(DiagramModel diagramModel) {
        this.diagramModel = diagramModel;
        this.diagramPart = diagramModel.getModelPart();
    }

    protected void paintGrid(Graphics g) {
        int i;
        Rectangle clip = g.getClip(Rectangle.SINGLETON);
        org.eclipse.swt.graphics.Color majorLineColor = this.diagramModel.getResourceCache().getColor(DEFAULT_MAJOR_LINE_COLOR);
        org.eclipse.swt.graphics.Color minorLineColor = this.diagramModel.getResourceCache().getColor(DEFAULT_MINOR_LINE_COLOR);
        this.gridX = this.diagramPart.getGridUnit();
        this.gridY = this.diagramPart.getVerticalGridUnit();
        if (this.gridX > 0) {
            i = clip.x;
            while (i % this.gridX != 0) {
                ++i;
            }
            while (i < clip.x + clip.width) {
                this.prepareG(g, majorLineColor, minorLineColor, i, this.gridX);
                g.drawLine(i, clip.y, i, clip.y + clip.height);
                i += this.gridX;
            }
        }
        if (this.gridY > 0) {
            i = clip.y;
            while (i % this.gridY != 0) {
                ++i;
            }
            while (i < clip.y + clip.height) {
                this.prepareG(g, majorLineColor, minorLineColor, i, this.gridY);
                g.drawLine(clip.x, i, clip.x + clip.width, i);
                i += this.gridY;
            }
        }
    }

    private void prepareG(Graphics g, org.eclipse.swt.graphics.Color gridColor, org.eclipse.swt.graphics.Color gridColorLight, int gridPosition, int gridSize) {
        int p = 5 * gridSize;
        if (gridPosition % p == 0) {
            g.setForegroundColor(gridColor);
        } else {
            g.setForegroundColor(gridColorLight);
        }
    }
}

