/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.commands;

import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.commands.Command;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.diagram.actions.DiagramNodeAddActionHandler;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeTemplate;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;
import org.eclipse.sapphire.ui.swt.gef.DiagramConfigurationManager;
import org.eclipse.sapphire.ui.swt.gef.DiagramRenderingContext;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramModel;
import org.eclipse.sapphire.ui.swt.gef.parts.IConfigurationManagerHolder;

public class CreateNodeCommand
extends Command {
    private DiagramNodeTemplate nodeTemplate;
    private Point location;
    IConfigurationManagerHolder configHolder;

    public CreateNodeCommand(DiagramModel diagramModel, IConfigurationManagerHolder configHolder, DiagramNodeTemplate nodeTemplate, Point location) {
        this.configHolder = configHolder;
        this.nodeTemplate = nodeTemplate;
        this.location = location;
    }

    public void execute() {
        SapphireDiagramEditorPagePart editorPart = this.nodeTemplate.getDiagramEditorPart();
        SapphireAction addAction = editorPart.getAction("Sapphire.Add");
        if (addAction != null) {
            List addHandlers = addAction.getActiveHandlers();
            for (SapphireActionHandler handler : addHandlers) {
                DiagramNodeAddActionHandler nodeAddHandler = (DiagramNodeAddActionHandler)handler;
                if (!nodeAddHandler.getNodeTemplate().equals(this.nodeTemplate)) continue;
                DiagramConfigurationManager configManager = this.configHolder.getConfigurationManager();
                DiagramRenderingContext ctx = configManager.getDiagramRenderingContextCache().get((ISapphirePart)editorPart);
                editorPart.setMouseLocation(this.location.x, this.location.y);
                nodeAddHandler.execute((SapphireRenderingContext)ctx);
                break;
            }
        }
    }
}

