/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.internal;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.ImageData;
import org.eclipse.sapphire.modeling.localization.LabelTransformer;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphireActionSystemPart;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;
import org.eclipse.sapphire.ui.renderers.swt.SwtRendererUtil;
import org.eclipse.sapphire.ui.swt.ActionBridge;
import org.eclipse.sapphire.ui.swt.ActionHandlerBridge;
import org.eclipse.sapphire.ui.swt.ActionSystemPartBridge;
import org.eclipse.sapphire.ui.swt.gef.DiagramRenderingContext;
import org.eclipse.sapphire.ui.swt.gef.SapphireDiagramEditor;

public final class DiagramEditorContextMenuProvider
extends ContextMenuProvider {
    private static final String DIAGRAM_NODE_DEFAULT_ACTION = "Sapphire.Diagram.Node.Default";
    private static final String DIAGRAM_DEFAULT_GROUP = "Diagram.Default";
    private SapphireDiagramEditor editor;
    private Map<SapphireActionSystemPart, ActionSystemPartBridge> cache = Collections.emptyMap();

    public DiagramEditorContextMenuProvider(SapphireDiagramEditor editor) {
        super((EditPartViewer)editor.getGraphicalViewer());
        this.editor = editor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void buildContextMenu(IMenuManager menuManager) {
        String context;
        ISapphirePart part;
        List<ISapphirePart> selection = this.editor.getSelectedParts();
        if (selection.size() == 1) {
            part = selection.get(0);
            if (part instanceof SapphireDiagramEditorPagePart) {
                context = "Sapphire.Diagram.Editor";
            } else if (part instanceof DiagramNodePart) {
                context = "Sapphire.Diagram.Node";
            } else {
                if (!(part instanceof DiagramConnectionPart)) throw new IllegalStateException();
                context = "Sapphire.Diagram.Connection";
            }
        } else {
            if (selection.size() <= 1) throw new IllegalStateException();
            part = this.editor.getPart();
            context = "Sapphire.Diagram.MultipleParts";
        }
        DiagramRenderingContext diagramRenderingContext = this.editor.getConfigurationManager().getDiagramRenderingContextCache().get(part);
        IdentityHashMap<SapphireActionSystemPart, ActionSystemPartBridge> updatedCache = new IdentityHashMap<SapphireActionSystemPart, ActionSystemPartBridge>();
        String currentGroupId = null;
        for (SapphireAction sapphireAction : part.getActions(context).getActions()) {
            List handlers;
            int count;
            if (sapphireAction.getId().equals(DIAGRAM_NODE_DEFAULT_ACTION)) continue;
            String groupId = sapphireAction.getGroup();
            if (currentGroupId != null && groupId == null || currentGroupId == null && groupId != null || currentGroupId != null && groupId != null && !currentGroupId.equals(groupId)) {
                currentGroupId = groupId;
                menuManager.add((IContributionItem)new Separator(currentGroupId == null ? DIAGRAM_DEFAULT_GROUP : currentGroupId));
            }
            if ((count = (handlers = sapphireAction.getActiveHandlers()).size()) == 1) {
                ActionSystemPartBridge bridge = this.cache.get(sapphireAction);
                if (bridge == null) {
                    bridge = new ActionBridge((SapphireRenderingContext)diagramRenderingContext, sapphireAction);
                }
                updatedCache.put((SapphireActionSystemPart)sapphireAction, bridge);
                menuManager.add((IAction)bridge);
                continue;
            }
            if (count <= 1) continue;
            String childMenuText = LabelTransformer.transform((String)sapphireAction.getLabel(), (CapitalizationType)CapitalizationType.TITLE_STYLE, (boolean)true);
            ImageDescriptor childMenuImage = SwtRendererUtil.toImageDescriptor((ImageData)sapphireAction.getImage(16));
            MenuManager childMenuManager = new MenuManager(childMenuText, childMenuImage, sapphireAction.getId());
            childMenuManager.setParent((IContributionManager)menuManager);
            menuManager.add((IContributionItem)childMenuManager);
            for (SapphireActionHandler handler : sapphireAction.getActiveHandlers()) {
                ActionSystemPartBridge bridge = this.cache.get(handler);
                if (bridge == null) {
                    bridge = new ActionHandlerBridge((SapphireRenderingContext)diagramRenderingContext, handler);
                }
                updatedCache.put((SapphireActionSystemPart)handler, bridge);
                childMenuManager.add((IAction)bridge);
            }
        }
        for (Map.Entry entry : this.cache.entrySet()) {
            if (updatedCache.containsKey(entry.getKey())) continue;
            ((ActionSystemPartBridge)entry.getValue()).dispose();
        }
        this.cache = updatedCache;
    }

    public void dispose() {
        super.dispose();
        for (ActionSystemPartBridge bridge : this.cache.values()) {
            bridge.dispose();
        }
    }
}

