/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.ui.Bounds;
import org.eclipse.sapphire.ui.Point;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionTemplate;
import org.eclipse.sapphire.ui.diagram.editor.DiagramEmbeddedConnectionTemplate;
import org.eclipse.sapphire.ui.diagram.editor.DiagramImplicitConnectionPart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramImplicitConnectionTemplate;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeBounds;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeTemplate;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;
import org.eclipse.sapphire.ui.swt.gef.DiagramConfigurationManager;
import org.eclipse.sapphire.ui.swt.gef.SapphireDiagramEditor;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramConnectionModel;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramModelBase;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramNodeModel;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramResourceCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramModel
extends DiagramModelBase {
    public static final String NODE_ADDED = "NODE_ADDED";
    public static final String NODE_REMOVED = "NODE_REMOVED";
    private SapphireDiagramEditorPagePart part;
    private DiagramConfigurationManager configManager;
    private List<DiagramNodeModel> nodes = new ArrayList<DiagramNodeModel>();
    private List<DiagramConnectionModel> connections = new ArrayList<DiagramConnectionModel>();
    private DiagramResourceCache resourceCache;

    public DiagramModel(SapphireDiagramEditorPagePart part, DiagramConfigurationManager configManager) {
        this.part = part;
        this.configManager = configManager;
        this.resourceCache = new DiagramResourceCache();
        this.contructNodes();
        this.constructConnections();
    }

    @Override
    public SapphirePart getSapphirePart() {
        return this.getModelPart();
    }

    public SapphireDiagramEditorPagePart getModelPart() {
        return this.part;
    }

    public DiagramResourceCache getResourceCache() {
        return this.resourceCache;
    }

    public List<DiagramNodeModel> getNodes() {
        return this.nodes;
    }

    public List<DiagramConnectionModel> getConnections() {
        return this.connections;
    }

    public DiagramNodeModel getDiagramNodeModel(DiagramNodePart nodePart) {
        for (DiagramNodeModel nodeModel : this.nodes) {
            if (nodeModel.getModelPart() != nodePart) continue;
            return nodeModel;
        }
        return null;
    }

    public DiagramConnectionModel getDiagramConnectionModel(DiagramConnectionPart connectionPart) {
        for (DiagramConnectionModel connectionModel : this.connections) {
            if (connectionModel.getModelPart() != connectionPart) continue;
            return connectionModel;
        }
        return null;
    }

    public void handleAddNode(DiagramNodePart nodePart) {
        DiagramNodeModel nodeModel = new DiagramNodeModel(this, nodePart);
        DiagramNodeBounds bounds = nodePart.getNodeBounds();
        if (bounds.getX() < 0 && bounds.getY() < 0) {
            Point position = this.getDefaultPosition();
            nodePart.setNodeBounds(position.getX(), position.getY(), false, true);
        }
        this.nodes.add(nodeModel);
        this.firePropertyChange(NODE_ADDED, null, nodeModel);
    }

    public void handleDirectEditing(DiagramNodePart nodePart) {
        DiagramNodeModel nodeModel = this.getDiagramNodeModel(nodePart);
        if (nodeModel != null) {
            nodeModel.handleStartEditing();
        }
    }

    public void handleDirectEditing(DiagramConnectionPart connectionPart) {
        DiagramConnectionModel connectionModel = this.getDiagramConnectionModel(connectionPart);
        if (connectionModel != null) {
            connectionModel.handleStartEditing();
        }
    }

    public void handleRemoveNode(DiagramNodePart nodePart) {
        DiagramNodeModel nodeModel = this.getDiagramNodeModel(nodePart);
        if (nodeModel != null) {
            ArrayList<DiagramConnectionModel> tobeRemoved = new ArrayList<DiagramConnectionModel>();
            for (DiagramConnectionModel connectionModel : this.connections) {
                if (!connectionModel.getSourceNode().equals(nodeModel) && !connectionModel.getTargetNode().equals(nodeModel)) continue;
                tobeRemoved.add(connectionModel);
            }
            for (DiagramConnectionModel connectionModel : tobeRemoved) {
                this.removeConnection(connectionModel);
            }
            this.nodes.remove(nodeModel);
            this.firePropertyChange(NODE_REMOVED, null, nodePart);
        }
    }

    private void contructNodes() {
        for (DiagramNodeTemplate nodeTemplate : this.getModelPart().getNodeTemplates()) {
            if (!nodeTemplate.visible()) continue;
            for (DiagramNodePart nodePart : nodeTemplate.getDiagramNodes()) {
                this.nodes.add(new DiagramNodeModel(this, nodePart));
            }
        }
    }

    private void constructConnections() {
        for (DiagramConnectionTemplate connTemplate : this.part.getConnectionTemplates()) {
            for (DiagramConnectionPart connPart : connTemplate.getDiagramConnections(null)) {
                this.addConnection(connPart);
            }
        }
        for (DiagramNodeTemplate nodeTemplate : this.part.getNodeTemplates()) {
            DiagramEmbeddedConnectionTemplate embeddedConnTemplate;
            if (!nodeTemplate.visible() || (embeddedConnTemplate = nodeTemplate.getEmbeddedConnectionTemplate()) == null) continue;
            for (DiagramConnectionPart connPart : embeddedConnTemplate.getDiagramConnections(null)) {
                this.addConnection(connPart);
            }
        }
        for (DiagramImplicitConnectionTemplate implicitConnTemplate : this.part.getImplicitConnectionTemplates()) {
            for (DiagramImplicitConnectionPart implicitConn : implicitConnTemplate.getImplicitConnections()) {
                this.addConnection((DiagramConnectionPart)implicitConn);
            }
        }
    }

    public void addConnection(DiagramConnectionPart connPart) {
        if (this.getDiagramConnectionModel(connPart) != null) {
            return;
        }
        IModelElement endpoint1 = connPart.getEndpoint1();
        IModelElement endpoint2 = connPart.getEndpoint2();
        DiagramNodePart nodePart1 = this.part.getDiagramNodePart(endpoint1);
        DiagramNodePart nodePart2 = this.part.getDiagramNodePart(endpoint2);
        if (nodePart1 != null && nodePart2 != null) {
            DiagramConnectionModel connectionModel = new DiagramConnectionModel(this, connPart);
            this.connections.add(connectionModel);
            DiagramNodeModel sourceNode = this.getDiagramNodeModel(nodePart1);
            DiagramNodeModel targetNode = this.getDiagramNodeModel(nodePart2);
            if (sourceNode != null && targetNode != null) {
                sourceNode.addSourceConnection(connectionModel);
                targetNode.addTargetConnection(connectionModel);
                connectionModel.setSourceNode(sourceNode);
                connectionModel.setTargetNode(targetNode);
                org.eclipse.draw2d.geometry.Point bendPoint = this.configManager.getConnectionRouter().route(connectionModel);
                if (bendPoint != null && connPart.getConnectionBendpoints().isEmpty()) {
                    ArrayList<Point> bendPoints = new ArrayList<Point>(1);
                    bendPoints.add(new Point(bendPoint.x, bendPoint.y));
                    connectionModel.getModelPart().resetBendpoints(bendPoints, false, true);
                }
            }
        }
    }

    public void removeConnection(DiagramConnectionPart connPart) {
        DiagramConnectionModel connectionModel = this.getDiagramConnectionModel(connPart);
        if (connectionModel != null) {
            this.removeConnection(connectionModel);
        }
    }

    private void removeConnection(DiagramConnectionModel connectionModel) {
        this.configManager.getConnectionRouter().removeConnectionFromCache(connectionModel);
        DiagramNodeModel sourceNode = connectionModel.getSourceNode();
        DiagramNodeModel targetNode = connectionModel.getTargetNode();
        if (sourceNode != null && targetNode != null) {
            sourceNode.removeSourceConnection(connectionModel);
            targetNode.removeTargetConnection(connectionModel);
            connectionModel.setSourceNode(null);
            connectionModel.setTargetNode(null);
        }
        this.connections.remove(connectionModel);
    }

    private Point getDefaultPosition() {
        int x = 10;
        int y = -1;
        for (DiagramNodeModel nodeModel : this.nodes) {
            Bounds bounds = nodeModel.getNodeBounds();
            int height = Math.max(bounds.getHeight(), 30);
            y = Math.max(y, height += bounds.getY() + 10);
        }
        return new Point(x, y);
    }

    public SapphireDiagramEditor getSapphireDiagramEditor() {
        return this.configManager.getDiagramEditor();
    }

    public void dispose() {
        this.resourceCache.dispose();
    }
}

