/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.parts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.sapphire.modeling.ImageData;
import org.eclipse.sapphire.ui.Bounds;
import org.eclipse.sapphire.ui.swt.gef.DiagramConfigurationManager;
import org.eclipse.sapphire.ui.swt.gef.commands.DoubleClickNodeCommand;
import org.eclipse.sapphire.ui.swt.gef.contextbuttons.ContextButtonManager;
import org.eclipse.sapphire.ui.swt.gef.figures.NodeFigure;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramConnectionModel;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramNodeModel;
import org.eclipse.sapphire.ui.swt.gef.parts.IConfigurationManagerHolder;
import org.eclipse.sapphire.ui.swt.gef.parts.NodeCellEditorLocator;
import org.eclipse.sapphire.ui.swt.gef.parts.NodeDecorator;
import org.eclipse.sapphire.ui.swt.gef.parts.NodeDirectEditManager;
import org.eclipse.sapphire.ui.swt.gef.policies.DiagramNodeEditPolicy;
import org.eclipse.sapphire.ui.swt.gef.policies.NodeEditPolicy;
import org.eclipse.sapphire.ui.swt.gef.policies.NodeLabelDirectEditPolicy;
import org.eclipse.sapphire.ui.swt.gef.policies.NodeLayoutEditPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramNodeEditPart
extends AbstractGraphicalEditPart
implements NodeEditPart,
PropertyChangeListener,
IConfigurationManagerHolder {
    private DiagramConfigurationManager configManager;
    private NodeDirectEditManager manager;
    private ConnectionAnchor sourceAnchor;
    private ConnectionAnchor targetAnchor;
    private List<IFigure> decorators = new ArrayList<IFigure>();

    public DiagramNodeEditPart(DiagramConfigurationManager configManager) {
        this.configManager = configManager;
    }

    @Override
    public DiagramConfigurationManager getConfigurationManager() {
        return this.configManager;
    }

    protected IFigure createFigure() {
        ImageData imageData = this.getCastedModel().getModelPart().getImage();
        return new NodeFigure(imageData != null, this.getCastedModel().getDiagramModel().getResourceCache());
    }

    protected void createEditPolicies() {
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new DiagramNodeEditPolicy());
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new NodeLabelDirectEditPolicy());
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new NodeEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new NodeLayoutEditPolicy());
    }

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            this.getCastedModel().addPropertyChangeListener(this);
            ContextButtonManager contextButtonManager = this.getConfigurationManager().getDiagramEditor().getContextButtonManager();
            contextButtonManager.register((GraphicalEditPart)this);
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            ContextButtonManager contextButtonManager = this.getConfigurationManager().getDiagramEditor().getContextButtonManager();
            contextButtonManager.deRegister((GraphicalEditPart)this);
            this.getCastedModel().removePropertyChangeListener(this);
            super.deactivate();
        }
    }

    private void performDirectEdit() {
        if (this.manager == null) {
            Label label = this.getNodeFigure().getLabelFigure();
            this.manager = new NodeDirectEditManager((GraphicalEditPart)this, new NodeCellEditorLocator(this.getConfigurationManager(), label), label);
        }
        this.manager.show();
    }

    public void performRequest(Request request) {
        if (request.getType() == "direct edit") {
            if (!(request instanceof DirectEditRequest)) {
                this.performDirectEdit();
            }
        } else if (request.getType().equals("open")) {
            SelectionRequest selRequest = (SelectionRequest)request;
            Point pt = selRequest.getLocation();
            if (this.mouseInLabelRegion(pt)) {
                this.performDirectEdit();
            } else {
                DoubleClickNodeCommand cmd = new DoubleClickNodeCommand(this, this.getCastedModel().getModelPart());
                if (cmd.canExecute()) {
                    cmd.execute();
                }
            }
        } else {
            super.performRequest(request);
        }
    }

    private boolean mouseInLabelRegion(Point pt) {
        Point realLocation = this.configManager.getDiagramEditor().calculateRealMouseLocation(pt);
        NodeFigure nodeFig = this.getNodeFigure();
        Rectangle bounds = nodeFig.getLabelFigure().getTextBounds();
        return bounds.contains(realLocation);
    }

    protected List<DiagramConnectionModel> getModelSourceConnections() {
        return this.getCastedModel().getSourceConnections();
    }

    protected List<DiagramConnectionModel> getModelTargetConnections() {
        return this.getCastedModel().getTargetConnections();
    }

    public DiagramNodeModel getCastedModel() {
        return (DiagramNodeModel)this.getModel();
    }

    protected NodeFigure getNodeFigure() {
        return (NodeFigure)this.getFigure();
    }

    private void addDecorators(Bounds labelBounds, Bounds imageBounds) {
        NodeFigure nodeFigure = this.getNodeFigure();
        for (IFigure decorator : this.decorators) {
            nodeFigure.remove(decorator);
        }
        this.decorators.clear();
        NodeDecorator util = new NodeDecorator(this.getCastedModel(), labelBounds, imageBounds);
        this.decorators.addAll(util.decorate(this.getNodeFigure()));
    }

    protected void refreshVisuals() {
        this.getNodeFigure().setText(this.getCastedModel().getLabel());
        this.getNodeFigure().setImage(this.getCastedModel().getImage());
        Bounds nb = this.getCastedModel().getNodeBounds();
        Bounds labelBounds = this.getCastedModel().getLabelBounds(nb);
        Bounds imageBounds = this.getCastedModel().getImageBounds(nb);
        this.getNodeFigure().refreshConstraints(labelBounds, imageBounds);
        this.addDecorators(labelBounds, imageBounds);
        Rectangle bounds = new Rectangle(nb.getX(), nb.getY(), nb.getWidth(), nb.getHeight());
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)bounds);
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        if (this.sourceAnchor == null) {
            this.sourceAnchor = new ChopboxAnchor(this.getFigure());
        }
        return this.sourceAnchor;
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        if (this.targetAnchor == null) {
            this.targetAnchor = new ChopboxAnchor(this.getFigure());
        }
        return this.targetAnchor;
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        if (this.sourceAnchor == null) {
            this.sourceAnchor = new ChopboxAnchor(this.getFigure());
        }
        return this.sourceAnchor;
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if ("SOURCE_CONNECTIONS".equals(prop)) {
            this.refreshSourceConnections();
        } else if ("TARGET_CONNECTIONS".equals(prop)) {
            this.refreshTargetConnections();
        } else if ("NODE_BOUNDS".equals(prop)) {
            this.refreshVisuals();
        } else if ("NODE_UPDATES".equals(prop)) {
            this.refreshVisuals();
        } else if ("NODE_START_EDITING".equals(prop)) {
            this.performDirectEdit();
        }
    }
}

