/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.def;

import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.sapphire.Context;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.UrlResourceStore;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.ui.def.DialogDef;
import org.eclipse.sapphire.ui.def.EditorPageDef;
import org.eclipse.sapphire.ui.def.FormComponentDef;
import org.eclipse.sapphire.ui.def.ISapphireUiDef;
import org.eclipse.sapphire.ui.def.InvalidDefinitionException;
import org.eclipse.sapphire.ui.def.PartDef;
import org.eclipse.sapphire.ui.def.WizardDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefinitionLoader {
    private static Map<URL, SoftReference<DefinitionLoader>> loaders = new HashMap<URL, SoftReference<DefinitionLoader>>();
    private final Context context;
    private ISapphireUiDef sdef;

    private DefinitionLoader(Context context) {
        this.context = context;
    }

    public static DefinitionLoader context(Context context) {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        return new DefinitionLoader(context);
    }

    public static DefinitionLoader context(ClassLoader loader) {
        if (loader == null) {
            throw new IllegalArgumentException();
        }
        return DefinitionLoader.context(Context.adapt((ClassLoader)loader));
    }

    public static DefinitionLoader context(Class<?> cl) {
        if (cl == null) {
            throw new IllegalArgumentException();
        }
        return DefinitionLoader.context(Context.adapt(cl));
    }

    public static DefinitionLoader sdef(Class<?> cl) {
        if (cl == null) {
            throw new IllegalArgumentException();
        }
        return DefinitionLoader.context(cl).sdef(cl.getSimpleName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefinitionLoader sdef(String name) {
        RootXmlResource resource;
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (name.endsWith(".sdef") || name.contains("/")) {
            throw new IllegalArgumentException();
        }
        if (this.sdef != null) {
            throw new IllegalStateException();
        }
        URL url = this.context.findResource(String.valueOf(name.replace('.', '/')) + ".sdef");
        if (url == null) {
            throw new IllegalArgumentException();
        }
        Map<URL, SoftReference<DefinitionLoader>> map = loaders;
        synchronized (map) {
            DefinitionLoader loader;
            Iterator<Map.Entry<URL, SoftReference<DefinitionLoader>>> itr = loaders.entrySet().iterator();
            while (itr.hasNext()) {
                if (itr.next().getValue().get() != null) continue;
                itr.remove();
            }
            SoftReference<DefinitionLoader> ref = loaders.get(url);
            if (ref != null && (loader = ref.get()) != null) {
                return loader;
            }
        }
        try {
            UrlResourceStore urlResourceStore = new UrlResourceStore(url){

                public <A> A adapt(Class<A> adapterType) {
                    if (adapterType == Context.class) {
                        return adapterType.cast(DefinitionLoader.this.context);
                    }
                    return (A)super.adapt(adapterType);
                }
            };
            resource = new RootXmlResource(new XmlResourceStore((ByteArrayResourceStore)urlResourceStore));
        }
        catch (ResourceStoreException e) {
            throw new IllegalArgumentException(e);
        }
        this.sdef = (ISapphireUiDef)ISapphireUiDef.TYPE.instantiate((Resource)resource);
        if (!Sapphire.isDevMode()) {
            Map<URL, SoftReference<DefinitionLoader>> map2 = loaders;
            synchronized (map2) {
                loaders.put(url, new SoftReference<DefinitionLoader>(this));
            }
        }
        return this;
    }

    public Reference<ISapphireUiDef> root() {
        return new Reference<ISapphireUiDef>(this, this.sdef, null);
    }

    public Reference<EditorPageDef> page() {
        return this.page(null);
    }

    public Reference<EditorPageDef> page(String id) {
        EditorPageDef def = null;
        if (id == null) {
            for (PartDef d : this.sdef.getPartDefs()) {
                if (!(d instanceof EditorPageDef)) continue;
                def = (EditorPageDef)d;
                break;
            }
        } else {
            def = (EditorPageDef)this.sdef.getPartDef(id, true, EditorPageDef.class);
        }
        if (def == null) {
            throw new IllegalArgumentException();
        }
        return new Reference<EditorPageDef>(this, def, null);
    }

    public Reference<WizardDef> wizard() {
        return this.wizard(null);
    }

    public Reference<WizardDef> wizard(String id) {
        WizardDef def = null;
        if (id == null) {
            for (PartDef d : this.sdef.getPartDefs()) {
                if (!(d instanceof WizardDef)) continue;
                def = (WizardDef)d;
                break;
            }
        } else {
            def = (WizardDef)this.sdef.getPartDef(id, true, WizardDef.class);
        }
        if (def == null) {
            throw new IllegalArgumentException();
        }
        return new Reference<WizardDef>(this, def, null);
    }

    public Reference<DialogDef> dialog() {
        return this.dialog(null);
    }

    public Reference<DialogDef> dialog(String id) {
        DialogDef def = null;
        if (id == null) {
            for (PartDef d : this.sdef.getPartDefs()) {
                if (!(d instanceof DialogDef)) continue;
                def = (DialogDef)d;
                break;
            }
        } else {
            def = (DialogDef)this.sdef.getPartDef(id, true, DialogDef.class);
        }
        if (def == null) {
            throw new IllegalArgumentException();
        }
        return new Reference<DialogDef>(this, def, null);
    }

    public Reference<FormComponentDef> form() {
        return this.form(null);
    }

    public Reference<FormComponentDef> form(String id) {
        FormComponentDef def = null;
        if (id == null) {
            for (PartDef d : this.sdef.getPartDefs()) {
                if (!(d instanceof FormComponentDef)) continue;
                def = (FormComponentDef)d;
                break;
            }
        } else {
            def = (FormComponentDef)this.sdef.getPartDef(id, true, FormComponentDef.class);
        }
        if (def == null) {
            throw new IllegalArgumentException();
        }
        return new Reference<FormComponentDef>(this, def, null);
    }

    protected void finalize() {
        this.sdef.dispose();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Reference<T extends IModelElement> {
        private DefinitionLoader loader;
        private T def;

        private Reference(DefinitionLoader loader, T def) {
            if (loader == null) {
                throw new IllegalArgumentException();
            }
            if (def == null) {
                throw new IllegalArgumentException();
            }
            this.loader = loader;
            this.def = def;
        }

        public T resolve() {
            if (this.def == null) {
                throw new IllegalStateException();
            }
            Status validation = this.def.validation();
            if (validation.severity() == Status.Severity.ERROR) {
                throw new InvalidDefinitionException(validation);
            }
            return this.def;
        }

        public T resolveIgnoringValidation() {
            if (this.def == null) {
                throw new IllegalStateException();
            }
            return this.def;
        }

        public void dispose() {
            this.loader = null;
            this.def = null;
        }

        /* synthetic */ Reference(DefinitionLoader definitionLoader, IModelElement iModelElement, Reference reference) {
            this(definitionLoader, iModelElement);
        }
    }
}

