/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.diagram.editor;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ImageData;
import org.eclipse.sapphire.modeling.ImpliedElementProperty;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.ui.IPropertiesViewContributorPart;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.PartVisibilityEvent;
import org.eclipse.sapphire.ui.Point;
import org.eclipse.sapphire.ui.PropertiesViewContributionManager;
import org.eclipse.sapphire.ui.PropertiesViewContributionPart;
import org.eclipse.sapphire.ui.SapphireEditor;
import org.eclipse.sapphire.ui.SapphireEditorPagePart;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphirePartListener;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.diagram.def.IDiagramConnectionDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramEditorPageDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramExplicitConnectionBindingDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramImplicitConnectionBindingDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramNodeDef;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionEvent;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionTemplate;
import org.eclipse.sapphire.ui.diagram.editor.DiagramEmbeddedConnectionTemplate;
import org.eclipse.sapphire.ui.diagram.editor.DiagramImplicitConnectionTemplate;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeEvent;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeTemplate;
import org.eclipse.sapphire.ui.diagram.editor.DiagramPageEvent;
import org.eclipse.sapphire.ui.diagram.editor.DiagramPartEvent;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramPartListener;
import org.eclipse.sapphire.ui.diagram.state.DiagramEditorPageState;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.sapphire.util.ListFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SapphireDiagramEditorPagePart
extends SapphireEditorPagePart {
    private IModelElement modelElement;
    private IDiagramEditorPageDef diagramPageDef = null;
    private List<IDiagramNodeDef> nodeDefs;
    private List<IDiagramConnectionDef> connectionDefs;
    private List<DiagramNodeTemplate> nodeTemplates;
    private List<DiagramConnectionTemplate> connectionTemplates;
    private List<DiagramImplicitConnectionTemplate> implicitConnectionTemplates;
    private NodeTemplateListener nodeTemplateListener;
    private ConnectionTemplateListener connTemplateListener;
    private PropertiesViewContributionManager propertiesViewContributionManager;
    private List<ISapphirePart> selections;
    private ImplicitConnectionTemplateListener implicitConnTemplateListener;
    private boolean showGrid;
    private boolean showGuides;
    private int gridUnit;
    private int verticalGridUnit;
    private List<FunctionResult> connectionImageDataFunctionResults;
    private Point mouseLocation;
    private DiagramEditorPageState state;

    @Override
    protected void init() {
        super.init();
        try {
            File stateFile = this.adapt(SapphireEditor.class).getDefaultStateStorageFile(this);
            this.state = (DiagramEditorPageState)DiagramEditorPageState.TYPE.instantiate((Resource)new RootXmlResource(new XmlResourceStore(stateFile)));
        }
        catch (ResourceStoreException resourceStoreException) {
            this.state = (DiagramEditorPageState)DiagramEditorPageState.TYPE.instantiate();
        }
        this.diagramPageDef = (IDiagramEditorPageDef)this.definition;
        ImpliedElementProperty modelElementProperty = (ImpliedElementProperty)this.resolve((String)this.diagramPageDef.getProperty().getContent());
        this.modelElement = modelElementProperty != null ? this.getModelElement().read((ElementProperty)modelElementProperty).element() : this.getModelElement();
        this.showGrid = (Boolean)this.diagramPageDef.getGridDefinition().isVisible().getContent();
        this.showGuides = (Boolean)this.diagramPageDef.getGuidesDefinition().isVisible().getContent();
        this.gridUnit = (Integer)this.diagramPageDef.getGridDefinition().getGridUnit().getContent();
        this.verticalGridUnit = (Integer)this.diagramPageDef.getGridDefinition().getVerticalGridUnit().getContent();
        this.mouseLocation = new Point(0, 0);
        this.nodeTemplateListener = new NodeTemplateListener();
        this.connTemplateListener = new ConnectionTemplateListener();
        this.implicitConnTemplateListener = new ImplicitConnectionTemplateListener();
        this.nodeTemplates = new ArrayList<DiagramNodeTemplate>();
        this.nodeDefs = this.diagramPageDef.getDiagramNodeDefs();
        this.connectionDefs = this.diagramPageDef.getDiagramConnectionDefs();
        for (IDiagramNodeDef nodeDef : this.nodeDefs) {
            DiagramNodeTemplate nodeTemplate = new DiagramNodeTemplate();
            nodeTemplate.init(this, this.modelElement, nodeDef, Collections.<String, String>emptyMap());
            this.nodeTemplates.add(nodeTemplate);
            nodeTemplate.addTemplateListener(this.nodeTemplateListener);
            nodeTemplate.attach((Listener)new FilteredListener<PartVisibilityEvent>(){

                protected void handleTypedEvent(PartVisibilityEvent event) {
                    SapphireDiagramEditorPagePart.this.refreshDiagramPalette((DiagramNodeTemplate)event.part());
                }
            });
        }
        for (DiagramNodeTemplate nodeTemplate : this.nodeTemplates) {
            nodeTemplate.initEmbeddedConnections();
            if (nodeTemplate.getEmbeddedConnectionTemplate() == null) continue;
            nodeTemplate.getEmbeddedConnectionTemplate().addTemplateListener(this.connTemplateListener);
        }
        this.connectionTemplates = new ArrayList<DiagramConnectionTemplate>();
        ModelElementList<IDiagramExplicitConnectionBindingDef> connectionBindings = this.diagramPageDef.getDiagramConnectionBindingDefs();
        for (IDiagramExplicitConnectionBindingDef connBinding : connectionBindings) {
            IDiagramConnectionDef connDef = this.getDiagramConnectionDef((String)connBinding.getConnectionId().getContent());
            DiagramConnectionTemplate connectionTemplate = new DiagramConnectionTemplate(connBinding);
            connectionTemplate.init(this, this.modelElement, connDef, Collections.<String, String>emptyMap());
            this.connectionTemplates.add(connectionTemplate);
            connectionTemplate.addTemplateListener(this.connTemplateListener);
        }
        this.implicitConnectionTemplates = new ArrayList<DiagramImplicitConnectionTemplate>();
        ModelElementList<IDiagramImplicitConnectionBindingDef> implicitConnBindings = this.diagramPageDef.getImplicitConnectionBindingDefs();
        for (IDiagramImplicitConnectionBindingDef implicitConnBinding : implicitConnBindings) {
            IDiagramConnectionDef connDef = this.getDiagramConnectionDef((String)implicitConnBinding.getConnectionId().getContent());
            DiagramImplicitConnectionTemplate connectionTemplate = new DiagramImplicitConnectionTemplate(implicitConnBinding);
            connectionTemplate.init(this, this.modelElement, connDef, Collections.<String, String>emptyMap());
            this.implicitConnectionTemplates.add(connectionTemplate);
            connectionTemplate.addTemplateListener(this.implicitConnTemplateListener);
        }
        this.connectionImageDataFunctionResults = new ArrayList<FunctionResult>();
        for (IDiagramConnectionDef connectionDef : this.connectionDefs) {
            FunctionResult imageResult = this.initExpression(this.modelElement, (Function)connectionDef.getToolPaletteImage().getContent(), ImageData.class, null, new Runnable(){

                public void run() {
                    SapphireDiagramEditorPagePart.this.broadcast(new SapphirePart.ImageChangedEvent(SapphireDiagramEditorPagePart.this));
                }
            });
            this.connectionImageDataFunctionResults.add(imageResult);
        }
        this.selections = new ArrayList<ISapphirePart>();
        this.selections.add(this);
        this.propertiesViewContributionManager = new PropertiesViewContributionManager(this, this.modelElement);
        this.attach(new Listener(){

            public void handle(Event event) {
                if (event instanceof SapphireEditorPagePart.SelectionChangedEvent) {
                    SapphireDiagramEditorPagePart.this.refreshPropertiesViewContribution();
                }
            }
        });
        this.refreshPropertiesViewContribution();
    }

    @Override
    public IModelElement getLocalModelElement() {
        return this.modelElement;
    }

    public boolean isGridVisible() {
        return this.showGrid;
    }

    public void setGridVisible(boolean visible) {
        if (visible != this.showGrid) {
            this.showGrid = visible;
            this.notifyGridStateChange();
        }
    }

    public boolean isShowGuides() {
        return this.showGuides;
    }

    public void setShowGuides(boolean showGuides) {
        if (this.showGuides != showGuides) {
            this.showGuides = showGuides;
            this.notifyGuideStateChange();
        }
    }

    public int getMinZoomLevel() {
        return 50;
    }

    public int getMaxZoomLevel() {
        return 400;
    }

    public int getZoomLevel() {
        return (Integer)this.getState().getZoomLevel().getContent();
    }

    public void setZoomLevel(int level) {
        int currentZoomLevel = (Integer)this.getState().getZoomLevel().getContent();
        if (currentZoomLevel != level) {
            int newZoomLevel = level;
            int min = this.getMinZoomLevel();
            if (level < min) {
                newZoomLevel = min;
            } else {
                int max = this.getMaxZoomLevel();
                if (level > max) {
                    newZoomLevel = max;
                }
            }
            if (currentZoomLevel != newZoomLevel) {
                this.getState().setZoomLevel(newZoomLevel);
                try {
                    this.getState().resource().save();
                }
                catch (ResourceStoreException e) {
                    SapphireUiFrameworkPlugin.log(e);
                }
                this.broadcast(new ZoomLevelEvent(this, currentZoomLevel, newZoomLevel));
            }
        }
    }

    public final DiagramEditorPageState getState() {
        return this.state;
    }

    public int getGridUnit() {
        return this.gridUnit;
    }

    public int getVerticalGridUnit() {
        if (this.verticalGridUnit > 0) {
            return this.verticalGridUnit;
        }
        return this.gridUnit;
    }

    public Point getMouseLocation() {
        return this.mouseLocation;
    }

    public void setMouseLocation(int x, int y) {
        this.mouseLocation.setX(x);
        this.mouseLocation.setY(y);
    }

    public void selectAndDirectEdit(ISapphirePart part) {
        this.notifyDirectEdit(part);
    }

    public void saveDiagram() {
        this.notifyDiagramSave();
    }

    public IDiagramEditorPageDef getPageDef() {
        return this.diagramPageDef;
    }

    public List<DiagramNodeTemplate> getNodeTemplates() {
        return this.nodeTemplates;
    }

    public List<DiagramNodeTemplate> getVisibleNodeTemplates() {
        ArrayList<DiagramNodeTemplate> visibleNodeTemplates = new ArrayList<DiagramNodeTemplate>();
        for (DiagramNodeTemplate nodeTemplate : this.getNodeTemplates()) {
            if (!nodeTemplate.visible()) continue;
            visibleNodeTemplates.add(nodeTemplate);
        }
        return visibleNodeTemplates;
    }

    public List<ConnectionPalette> getConnectionPalettes() {
        ArrayList<ConnectionPalette> list = new ArrayList<ConnectionPalette>();
        int i = 0;
        while (i < this.connectionImageDataFunctionResults.size()) {
            FunctionResult result = this.connectionImageDataFunctionResults.get(i);
            ImageData imageData = null;
            if (result != null) {
                imageData = (ImageData)result.value();
            }
            IDiagramConnectionDef def = this.connectionDefs.get(i);
            ConnectionPalette palette = new ConnectionPalette(imageData, def);
            list.add(palette);
            ++i;
        }
        return list;
    }

    public IDiagramConnectionDef getDiagramConnectionDef(String connId) {
        if (connId == null) {
            throw new IllegalArgumentException();
        }
        IDiagramConnectionDef connDef = null;
        for (IDiagramConnectionDef def : this.connectionDefs) {
            String id = (String)def.getId().getContent();
            if (id == null || !id.equalsIgnoreCase(connId)) continue;
            connDef = def;
            break;
        }
        return connDef;
    }

    public List<DiagramConnectionTemplate> getConnectionTemplates() {
        return this.connectionTemplates;
    }

    public List<DiagramImplicitConnectionTemplate> getImplicitConnectionTemplates() {
        return this.implicitConnectionTemplates;
    }

    @Override
    public void render(SapphireRenderingContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> getActionContexts() {
        HashSet<String> contextSet = new HashSet<String>();
        contextSet.add("Sapphire.Diagram");
        contextSet.add("Sapphire.Diagram.Editor");
        contextSet.add("Sapphire.Diagram.MultipleParts");
        contextSet.add("Sapphire.Diagram.Header");
        return contextSet;
    }

    @Override
    public String getMainActionContext() {
        return "Sapphire.Diagram.Editor";
    }

    public List<ISapphirePart> getSelections() {
        return this.selections;
    }

    public void setSelections(List<ISapphirePart> selections) {
        boolean selectionChanged = false;
        if (this.selections.size() != selections.size()) {
            selectionChanged = true;
        } else if (!this.selections.containsAll(selections) || !selections.containsAll(this.selections)) {
            selectionChanged = true;
        }
        if (selectionChanged) {
            this.selections.clear();
            this.selections.addAll(selections);
            this.broadcast(new SapphireEditorPagePart.SelectionChangedEvent(this));
        }
    }

    public void selectAll() {
        this.notifySelectAll();
    }

    public void selectAllNodes() {
        this.notifySelectAllNodes();
    }

    private void refreshPropertiesViewContribution() {
        List<ISapphirePart> selections = this.getSelections();
        SapphirePart propertiesViewContribution = null;
        if (selections.size() == 1) {
            ISapphirePart selection = selections.get(0);
            if (selection == this) {
                propertiesViewContribution = this.propertiesViewContributionManager.getPropertiesViewContribution();
            } else if (selection instanceof IPropertiesViewContributorPart) {
                propertiesViewContribution = ((IPropertiesViewContributorPart)((Object)selection)).getPropertiesViewContribution();
            }
        }
        if (propertiesViewContribution == null || !propertiesViewContribution.getLocalModelElement().disposed()) {
            this.setPropertiesViewContribution((PropertiesViewContributionPart)propertiesViewContribution);
        }
    }

    private void refreshDiagramPalette(DiagramNodeTemplate nodeTemplate) {
        if (nodeTemplate.visible()) {
            nodeTemplate.showAllNodeParts();
            List<DiagramConnectionTemplate> connTemplates = this.getConnectionTemplates();
            for (DiagramConnectionTemplate connTemplate : connTemplates) {
                connTemplate.showAllConnectionParts(nodeTemplate);
            }
            List<DiagramImplicitConnectionTemplate> implictConnTemplates = this.getImplicitConnectionTemplates();
            for (DiagramImplicitConnectionTemplate implicitConnTemplate : implictConnTemplates) {
                implicitConnTemplate.refreshImplicitConnections();
            }
        } else {
            nodeTemplate.hideAllNodeParts();
        }
        this.notifyDiagramChange();
        this.refreshPropertiesViewContribution();
    }

    public List<DiagramNodePart> getNodes() {
        ListFactory nodes = ListFactory.start();
        for (DiagramNodeTemplate template : this.getNodeTemplates()) {
            nodes.add(template.getDiagramNodes());
        }
        return nodes.result();
    }

    public List<DiagramConnectionPart> getConnections() {
        ListFactory connections = ListFactory.start();
        for (DiagramConnectionTemplate template : this.getConnectionTemplates()) {
            connections.add(template.getDiagramConnections(null));
        }
        for (DiagramNodeTemplate nodeTemplate : this.getNodeTemplates()) {
            DiagramEmbeddedConnectionTemplate embeddedConnectionTemplate = nodeTemplate.getEmbeddedConnectionTemplate();
            if (embeddedConnectionTemplate == null) continue;
            connections.add(((DiagramConnectionTemplate)embeddedConnectionTemplate).getDiagramConnections(null));
        }
        return connections.result();
    }

    public DiagramNodePart getDiagramNodePart(IModelElement nodeElement) {
        if (nodeElement == null) {
            return null;
        }
        List<DiagramNodeTemplate> nodeTemplates = this.getNodeTemplates();
        for (DiagramNodeTemplate nodeTemplate : nodeTemplates) {
            List<DiagramNodePart> nodeParts = nodeTemplate.getDiagramNodes();
            for (DiagramNodePart nodePart : nodeParts) {
                if (!nodePart.getLocalModelElement().equals(nodeElement)) continue;
                return nodePart;
            }
        }
        return null;
    }

    public DiagramConnectionPart getDiagramConnectionPart(IModelElement connElement) {
        if (connElement == null) {
            return null;
        }
        List<DiagramConnectionTemplate> connTemplates = this.getConnectionTemplates();
        for (DiagramConnectionTemplate connTemplate : connTemplates) {
            List<DiagramConnectionPart> connParts = connTemplate.getDiagramConnections(null);
            for (DiagramConnectionPart connPart : connParts) {
                if (!connPart.getLocalModelElement().equals(connElement)) continue;
                return connPart;
            }
        }
        List<DiagramNodeTemplate> nodeTemplates = this.getNodeTemplates();
        for (DiagramNodeTemplate nodeTemplate : nodeTemplates) {
            DiagramEmbeddedConnectionTemplate connTemplate = nodeTemplate.getEmbeddedConnectionTemplate();
            if (connTemplate == null) continue;
            List<DiagramConnectionPart> connParts = connTemplate.getDiagramConnections(null);
            for (DiagramConnectionPart connPart : connParts) {
                if (!connPart.getLocalModelElement().equals(connElement)) continue;
                return connPart;
            }
        }
        return null;
    }

    public List<DiagramConnectionPart> getAttachedConnections(DiagramNodePart nodePart) {
        IModelElement nodeElement = nodePart.getLocalModelElement();
        ArrayList<DiagramConnectionPart> attachedConnections = new ArrayList<DiagramConnectionPart>();
        List<DiagramConnectionTemplate> connTemplates = this.getConnectionTemplates();
        for (DiagramConnectionTemplate connTemplate : connTemplates) {
            List<DiagramConnectionPart> connParts = connTemplate.getDiagramConnections(null);
            for (DiagramConnectionPart connPart : connParts) {
                if ((connPart.getEndpoint1() == null || !connPart.getEndpoint1().equals(nodeElement)) && (connPart.getEndpoint2() == null || !connPart.getEndpoint2().equals(nodeElement))) continue;
                attachedConnections.add(connPart);
            }
        }
        List<DiagramNodeTemplate> nodeTemplates = this.getNodeTemplates();
        for (DiagramNodeTemplate nodeTemplate : nodeTemplates) {
            DiagramEmbeddedConnectionTemplate connTemplate = nodeTemplate.getEmbeddedConnectionTemplate();
            if (connTemplate == null) continue;
            List<DiagramConnectionPart> connParts = connTemplate.getDiagramConnections(null);
            for (DiagramConnectionPart connPart : connParts) {
                if (!connPart.getEndpoint1().equals(nodeElement) && !connPart.getEndpoint2().equals(nodeElement)) continue;
                attachedConnections.add(connPart);
            }
        }
        return attachedConnections;
    }

    @Override
    public void dispose() {
        super.dispose();
        int i = 0;
        while (i < this.connectionImageDataFunctionResults.size()) {
            FunctionResult result = this.connectionImageDataFunctionResults.get(i);
            if (result != null) {
                result.dispose();
            }
            ++i;
        }
        this.disposeParts();
    }

    private void disposeParts() {
        for (DiagramNodeTemplate diagramNodeTemplate : this.nodeTemplates) {
            diagramNodeTemplate.dispose();
        }
        this.nodeTemplates.clear();
        for (DiagramConnectionTemplate diagramConnectionTemplate : this.connectionTemplates) {
            diagramConnectionTemplate.dispose();
        }
        this.connectionTemplates.clear();
        for (DiagramImplicitConnectionTemplate diagramImplicitConnectionTemplate : this.implicitConnectionTemplates) {
            diagramImplicitConnectionTemplate.dispose();
        }
        this.implicitConnectionTemplates.clear();
    }

    public DiagramNodeTemplate getNodeTemplate(ModelProperty modelProperty) {
        for (DiagramNodeTemplate nodeTemplate : this.nodeTemplates) {
            if (nodeTemplate.getModelProperty() != modelProperty) continue;
            return nodeTemplate;
        }
        return null;
    }

    private void notifyNodeUpdate(DiagramNodePart nodePart) {
        Set<SapphirePartListener> listeners = this.getListeners();
        for (SapphirePartListener listener : listeners) {
            if (!(listener instanceof SapphireDiagramPartListener)) continue;
            DiagramNodeEvent nue = new DiagramNodeEvent(nodePart);
            ((SapphireDiagramPartListener)listener).handleNodeUpdateEvent(nue);
        }
    }

    private void notifyNodeAdd(DiagramNodePart nodePart) {
        Set<SapphirePartListener> listeners = this.getListeners();
        for (SapphirePartListener listener : listeners) {
            if (!(listener instanceof SapphireDiagramPartListener)) continue;
            DiagramNodeEvent nue = new DiagramNodeEvent(nodePart);
            ((SapphireDiagramPartListener)listener).handleNodeAddEvent(nue);
        }
    }

    private void notifyNodeDelete(DiagramNodePart nodePart) {
        Set<SapphirePartListener> listeners = this.getListeners();
        for (SapphirePartListener listener : listeners) {
            if (!(listener instanceof SapphireDiagramPartListener)) continue;
            DiagramNodeEvent nue = new DiagramNodeEvent(nodePart);
            ((SapphireDiagramPartListener)listener).handleNodeDeleteEvent(nue);
        }
    }

    private void notifyNodeMove(DiagramNodeEvent event) {
        Set<SapphirePartListener> listeners = this.getListeners();
        for (SapphirePartListener listener : listeners) {
            if (!(listener instanceof SapphireDiagramPartListener)) continue;
            ((SapphireDiagramPartListener)listener).handleNodeMoveEvent(event);
        }
    }

    private void notifyConnectionUpdate(DiagramConnectionEvent event) {
        Set<SapphirePartListener> listeners = this.getListeners();
        for (SapphirePartListener listener : listeners) {
            if (!(listener instanceof SapphireDiagramPartListener)) continue;
            ((SapphireDiagramPartListener)listener).handleConnectionUpdateEvent(event);
        }
    }

    private void notifyConnectionEndpointUpdate(DiagramConnectionEvent event) {
        Set<SapphirePartListener> listeners = this.getListeners();
        for (SapphirePartListener listener : listeners) {
            if (!(listener instanceof SapphireDiagramPartListener)) continue;
            ((SapphireDiagramPartListener)listener).handleConnectionEndpointEvent(event);
        }
    }

    private void notifyConnectionAdd(DiagramConnectionEvent event) {
        Set<SapphirePartListener> listeners = this.getListeners();
        for (SapphirePartListener listener : listeners) {
            if (!(listener instanceof SapphireDiagramPartListener)) continue;
            ((SapphireDiagramPartListener)listener).handleConnectionAddEvent(event);
        }
    }

    private void notifyConnectionDelete(DiagramConnectionEvent event) {
        Set<SapphirePartListener> listeners = this.getListeners();
        for (SapphirePartListener listener : listeners) {
            if (!(listener instanceof SapphireDiagramPartListener)) continue;
            ((SapphireDiagramPartListener)listener).handleConnectionDeleteEvent(event);
        }
    }

    private void notifyConnectionAddBendpoint(DiagramConnectionEvent cue) {
        Set<SapphirePartListener> listeners = this.getListeners();
        for (SapphirePartListener listener : listeners) {
            if (!(listener instanceof SapphireDiagramPartListener)) continue;
            ((SapphireDiagramPartListener)listener).handleConnectionAddBendpointEvent(cue);
        }
    }

    private void notifyConnectionRemoveBendpoint(DiagramConnectionEvent event) {
        Set<SapphirePartListener> listeners = this.getListeners();
        for (SapphirePartListener listener : listeners) {
            if (!(listener instanceof SapphireDiagramPartListener)) continue;
            ((SapphireDiagramPartListener)listener).handleConnectionRemoveBendpointEvent(event);
        }
    }

    private void notifyConnectionMoveBendpoint(DiagramConnectionEvent event) {
        Set<SapphirePartListener> listeners = this.getListeners();
        for (SapphirePartListener listener : listeners) {
            if (!(listener instanceof SapphireDiagramPartListener)) continue;
            ((SapphireDiagramPartListener)listener).handleConnectionMoveBendpointEvent(event);
        }
    }

    private void notifyConnectionResetBendpoints(DiagramConnectionEvent event) {
        Set<SapphirePartListener> listeners = this.getListeners();
        for (SapphirePartListener listener : listeners) {
            if (!(listener instanceof SapphireDiagramPartListener)) continue;
            ((SapphireDiagramPartListener)listener).handleConnectionResetBendpointsEvent(event);
        }
    }

    private void notifyConnectionMoveLabel(DiagramConnectionEvent event) {
        Set<SapphirePartListener> listeners = this.getListeners();
        for (SapphirePartListener listener : listeners) {
            if (!(listener instanceof SapphireDiagramPartListener)) continue;
            ((SapphireDiagramPartListener)listener).handleConnectionMoveLabelEvent(event);
        }
    }

    private void notifyDirectEdit(ISapphirePart part) {
        Set<SapphirePartListener> listeners = this.getListeners();
        for (SapphirePartListener listener : listeners) {
            if (!(listener instanceof SapphireDiagramPartListener)) continue;
            DiagramPartEvent cue = new DiagramPartEvent(part);
            ((SapphireDiagramPartListener)listener).handleDirectEditEvent(cue);
        }
    }

    private void notifyGridStateChange() {
        Set<SapphirePartListener> listeners = this.getListeners();
        for (SapphirePartListener listener : listeners) {
            if (!(listener instanceof SapphireDiagramPartListener)) continue;
            DiagramPageEvent pageEvent = new DiagramPageEvent(this);
            ((SapphireDiagramPartListener)listener).handleGridStateChangeEvent(pageEvent);
        }
    }

    private void notifyGuideStateChange() {
        Set<SapphirePartListener> listeners = this.getListeners();
        for (SapphirePartListener listener : listeners) {
            if (!(listener instanceof SapphireDiagramPartListener)) continue;
            DiagramPageEvent pageEvent = new DiagramPageEvent(this);
            ((SapphireDiagramPartListener)listener).handleGuideStateChangeEvent(pageEvent);
        }
    }

    private void notifyDiagramChange() {
        Set<SapphirePartListener> listeners = this.getListeners();
        for (SapphirePartListener listener : listeners) {
            if (!(listener instanceof SapphireDiagramPartListener)) continue;
            DiagramPageEvent pageEvent = new DiagramPageEvent(this);
            ((SapphireDiagramPartListener)listener).handleDiagramUpdateEvent(pageEvent);
        }
    }

    private void notifyDiagramSave() {
        Set<SapphirePartListener> listeners = this.getListeners();
        for (SapphirePartListener listener : listeners) {
            if (!(listener instanceof SapphireDiagramPartListener)) continue;
            DiagramPageEvent pageEvent = new DiagramPageEvent(this);
            ((SapphireDiagramPartListener)listener).handleDiagramSaveEvent(pageEvent);
        }
    }

    private void notifySelectAll() {
        Set<SapphirePartListener> listeners = this.getListeners();
        for (SapphirePartListener listener : listeners) {
            if (!(listener instanceof SapphireDiagramPartListener)) continue;
            DiagramPageEvent pageEvent = new DiagramPageEvent(this);
            ((SapphireDiagramPartListener)listener).handleSelectAllEvent(pageEvent);
        }
    }

    private void notifySelectAllNodes() {
        Set<SapphirePartListener> listeners = this.getListeners();
        for (SapphirePartListener listener : listeners) {
            if (!(listener instanceof SapphireDiagramPartListener)) continue;
            DiagramPageEvent pageEvent = new DiagramPageEvent(this);
            ((SapphireDiagramPartListener)listener).handleSelectAllNodesEvent(pageEvent);
        }
    }

    public static final class ConnectionPalette {
        ImageData imageData;
        IDiagramConnectionDef connectionDef;

        public ConnectionPalette(ImageData imageData, IDiagramConnectionDef connectionDef) {
            this.imageData = imageData;
            this.connectionDef = connectionDef;
        }

        public ImageData getImageData() {
            return this.imageData;
        }

        public IDiagramConnectionDef getConnectionDef() {
            return this.connectionDef;
        }
    }

    private class ConnectionTemplateListener
    extends DiagramConnectionTemplate.DiagramConnectionTemplateListener {
        private ConnectionTemplateListener() {
        }

        public void handleConnectionUpdate(DiagramConnectionEvent event) {
            SapphireDiagramEditorPagePart.this.notifyConnectionUpdate(event);
        }

        public void handleConnectionEndpointUpdate(DiagramConnectionEvent event) {
            SapphireDiagramEditorPagePart.this.notifyConnectionEndpointUpdate(event);
        }

        public void handleConnectionAdd(DiagramConnectionEvent event) {
            SapphireDiagramEditorPagePart.this.notifyConnectionAdd(event);
        }

        public void handleConnectionDelete(DiagramConnectionEvent event) {
            SapphireDiagramEditorPagePart.this.notifyConnectionDelete(event);
        }

        public void handleAddBendpoint(DiagramConnectionEvent event) {
            SapphireDiagramEditorPagePart.this.notifyConnectionAddBendpoint(event);
        }

        public void handleRemoveBendpoint(DiagramConnectionEvent event) {
            SapphireDiagramEditorPagePart.this.notifyConnectionRemoveBendpoint(event);
        }

        public void handleMoveBendpoint(DiagramConnectionEvent event) {
            SapphireDiagramEditorPagePart.this.notifyConnectionMoveBendpoint(event);
        }

        public void handleResetBendpoints(DiagramConnectionEvent event) {
            SapphireDiagramEditorPagePart.this.notifyConnectionResetBendpoints(event);
        }

        public void handleMoveLabel(DiagramConnectionEvent event) {
            SapphireDiagramEditorPagePart.this.notifyConnectionMoveLabel(event);
        }
    }

    private class ImplicitConnectionTemplateListener
    extends DiagramImplicitConnectionTemplate.DiagramImplicitConnectionTemplateListener {
        private ImplicitConnectionTemplateListener() {
        }

        public void handleConnectionAdd(DiagramConnectionEvent event) {
            SapphireDiagramEditorPagePart.this.notifyConnectionAdd(event);
        }

        public void handleConnectionDelete(DiagramConnectionEvent event) {
            SapphireDiagramEditorPagePart.this.notifyConnectionDelete(event);
        }
    }

    private class NodeTemplateListener
    extends DiagramNodeTemplate.DiagramNodeTemplateListener {
        private NodeTemplateListener() {
        }

        public void handleNodeUpdate(DiagramNodePart nodePart) {
            SapphireDiagramEditorPagePart.this.notifyNodeUpdate(nodePart);
        }

        public void handleNodeAdd(DiagramNodePart nodePart) {
            SapphireDiagramEditorPagePart.this.notifyNodeAdd(nodePart);
        }

        public void handleNodeDelete(DiagramNodePart nodePart) {
            SapphireDiagramEditorPagePart.this.notifyNodeDelete(nodePart);
        }

        public void handleNodeMove(DiagramNodeEvent event) {
            SapphireDiagramEditorPagePart.this.notifyNodeMove(event);
        }
    }

    public static final class ZoomLevelEvent
    extends SapphirePart.PartEvent {
        private final int before;
        private final int after;

        public ZoomLevelEvent(SapphirePart part, int before, int after) {
            super(part);
            this.before = before;
            this.after = after;
        }

        public int before() {
            return this.before;
        }

        public int after() {
            return this.after;
        }
    }
}

