/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.form.editors.masterdetails;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.ui.SectionPart;
import org.eclipse.sapphire.ui.form.editors.masterdetails.MasterDetailsContentNode;
import org.eclipse.sapphire.ui.form.editors.masterdetails.MasterDetailsEditorPagePart;

public final class ProblemsTraversalServiceData {
    static ProblemsTraversalServiceData EMPTY = new ProblemsTraversalServiceData();
    private Entry first;
    private Entry last;
    private final Map<MasterDetailsContentNode, Entry> index;

    private ProblemsTraversalServiceData() {
        this.index = Collections.emptyMap();
    }

    ProblemsTraversalServiceData(MasterDetailsEditorPagePart page, Listener listener) {
        this.index = new IdentityHashMap<MasterDetailsContentNode, Entry>();
        this.traverse(page.outline().getRoot(), listener);
    }

    private void traverse(MasterDetailsContentNode node, Listener listener) {
        Entry entry = new Entry();
        if (this.first == null) {
            this.first = entry;
            this.last = entry;
        } else {
            this.last.next = entry;
            this.last = entry;
        }
        this.index.put(node, entry);
        entry.node = node;
        for (SectionPart section : node.getSections()) {
            if (node.visible() && section.visible()) {
                Status.Severity severity = section.validation().severity();
                if (severity == Status.Severity.ERROR) {
                    entry.error = true;
                } else if (severity == Status.Severity.WARNING) {
                    entry.warning = true;
                }
            }
            section.attach(listener);
        }
        for (MasterDetailsContentNode child : node.nodes()) {
            this.traverse(child, listener);
        }
        node.attach(listener);
    }

    public MasterDetailsContentNode findNextProblem(MasterDetailsContentNode reference, Status.Severity severity) {
        if (reference == null || severity != Status.Severity.ERROR && severity != Status.Severity.WARNING) {
            throw new IllegalArgumentException();
        }
        return severity == Status.Severity.ERROR ? this.findNextError(reference) : this.findNextWarning(reference);
    }

    public MasterDetailsContentNode findNextError(MasterDetailsContentNode reference) {
        if (reference == null) {
            throw new IllegalArgumentException();
        }
        Entry entry = this.index.get(reference);
        if (entry != null) {
            entry = entry.next;
            while (entry != null && !entry.error) {
                entry = entry.next;
            }
        }
        return entry == null ? null : entry.node;
    }

    public MasterDetailsContentNode findNextWarning(MasterDetailsContentNode reference) {
        if (reference == null) {
            throw new IllegalArgumentException();
        }
        Entry entry = this.index.get(reference);
        if (entry != null) {
            entry = entry.next;
            while (entry != null && !entry.warning) {
                entry = entry.next;
            }
        }
        return entry == null ? null : entry.node;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ProblemsTraversalServiceData) {
            Entry x = this.first;
            Entry y = ((ProblemsTraversalServiceData)obj).first;
            while (x != null && y != null) {
                if (x.node != y.node || x.error != y.error || x.warning != y.warning) {
                    return false;
                }
                x = x.next;
                y = y.next;
            }
            if (x == null && y == null) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int result = 1;
        Entry entry = this.first;
        while (entry != null) {
            result = 31 * result + entry.node.hashCode() + Boolean.valueOf(entry.error).hashCode() + Boolean.valueOf(entry.warning).hashCode();
            entry = entry.next;
        }
        return result;
    }

    private static final class Entry {
        public MasterDetailsContentNode node;
        public boolean error;
        public boolean warning;
        public Entry next;

        private Entry() {
        }
    }
}

