/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.ui.PartVisibilityEvent;
import org.eclipse.sapphire.ui.PropertiesViewContributionPagePart;
import org.eclipse.sapphire.ui.PropertiesViewContributionPart;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.swt.internal.TabbedPropertyComposite;
import org.eclipse.sapphire.ui.swt.internal.TabbedPropertyList;
import org.eclipse.sapphire.ui.swt.renderer.GridLayoutUtil;
import org.eclipse.sapphire.util.MutableReference;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public final class SapphirePropertySheetPage
implements IPropertySheetPage {
    private PropertiesViewContributionPart part;
    private Composite composite;
    private Color backgroundColor;
    private Font noPropertiesFont;
    private Color noPropertiesFontColor;

    public PropertiesViewContributionPart getPart() {
        return this.part;
    }

    public void setPart(PropertiesViewContributionPart part) {
        if (this.part != part) {
            this.part = part;
            this.refresh();
        }
    }

    public void createControl(Composite parent) {
        this.backgroundColor = parent.getDisplay().getSystemColor(1);
        this.composite = new Composite(parent, 0);
        this.composite.setBackground(this.backgroundColor);
        this.composite.setLayout((Layout)GridLayoutUtil.glayout(1, 0, 0));
        this.refresh();
    }

    private void refresh() {
        if (this.composite == null) {
            return;
        }
        Control[] controlArray = this.composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        if (this.part == null) {
            Composite labelComposite = new Composite(this.composite, 0);
            labelComposite.setLayoutData((Object)GridLayoutUtil.gdfill());
            labelComposite.setLayout((Layout)GridLayoutUtil.glayout(3));
            labelComposite.setBackground(this.backgroundColor);
            Label spacerLeft = new Label(labelComposite, 0);
            spacerLeft.setLayoutData((Object)GridLayoutUtil.gdvfill());
            spacerLeft.setText("");
            spacerLeft.setBackground(this.backgroundColor);
            Label label = new Label(labelComposite, 0x1000000);
            label.setLayoutData((Object)GridLayoutUtil.gdhalign(GridLayoutUtil.gdhfill(), 0x1000000));
            label.setText(Resources.noProperties);
            label.setBackground(this.backgroundColor);
            Label spacerRight = new Label(labelComposite, 0);
            spacerRight.setLayoutData((Object)GridLayoutUtil.gdvfill());
            spacerRight.setText("");
            spacerRight.setBackground(this.backgroundColor);
            if (this.noPropertiesFont == null) {
                Display display = label.getDisplay();
                FontData fd = new FontData(label.getFont().getFontData()[0].getName(), 30, 1);
                this.noPropertiesFont = new Font((Device)display, fd);
                this.noPropertiesFontColor = new Color((Device)display, 230, 230, 230);
            }
            label.setFont(this.noPropertiesFont);
            label.setForeground(this.noPropertiesFontColor);
        } else {
            final TabbedPropertyComposite tabbedPropertiesComposite = new TabbedPropertyComposite(this.composite);
            tabbedPropertiesComposite.setLayout((Layout)new FormLayout());
            FormData formData = new FormData();
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            formData.top = new FormAttachment(0, 0);
            formData.bottom = new FormAttachment(100, 0);
            tabbedPropertiesComposite.setLayoutData(GridLayoutUtil.gdfill());
            final LocalizationService localizationService = (LocalizationService)this.part.definition().adapt(LocalizationService.class);
            List<PropertiesViewContributionPagePart> pages = this.part.getPages();
            final ArrayList<PropertiesViewContributionPagePart> visiblePages = new ArrayList<PropertiesViewContributionPagePart>();
            final ArrayList<1> elements = new ArrayList<1>(pages.size());
            final TabbedPropertyList list = tabbedPropertiesComposite.getList();
            final HashMap<PropertiesViewContributionPagePart, 1> partToTabbedPropertyListItem = new HashMap<PropertiesViewContributionPagePart, 1>();
            for (final PropertiesViewContributionPagePart page : pages) {
                int index;
                if (page.visible()) {
                    visiblePages.add(page);
                    final MutableReference imageDescriptor = new MutableReference();
                    final MutableReference image = new MutableReference();
                    TabbedPropertyList.Item item = new TabbedPropertyList.Item(){

                        public String getText() {
                            return localizationService.transform(page.getLabel(), CapitalizationType.TITLE_STYLE, false);
                        }

                        public Image getImage() {
                            ImageDescriptor oldImageDescriptor = (ImageDescriptor)imageDescriptor.get();
                            ImageDescriptor newImageDescriptor = page.getImage();
                            if (newImageDescriptor != oldImageDescriptor) {
                                if (oldImageDescriptor != null) {
                                    ((Image)image.get()).dispose();
                                }
                                imageDescriptor.set((Object)newImageDescriptor);
                                image.set((Object)newImageDescriptor.createImage());
                            }
                            return (Image)image.get();
                        }

                        public boolean isIndented() {
                            return false;
                        }
                    };
                    elements.add(item);
                    partToTabbedPropertyListItem.put(page, item);
                    index = elements.size() - 1;
                } else {
                    index = -1;
                }
                final Listener listener = new Listener(){

                    public void handle(Event event) {
                        if (event instanceof SapphirePart.LabelChangedEvent || event instanceof SapphirePart.ImageChangedEvent) {
                            if (index != -1) {
                                list.update(index);
                            }
                        } else if (event instanceof PartVisibilityEvent) {
                            SapphirePropertySheetPage.this.refresh();
                        }
                    }
                };
                page.attach(listener);
                tabbedPropertiesComposite.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent event) {
                        page.detach(listener);
                    }
                });
            }
            list.setElements(elements.toArray(new Object[elements.size()]));
            final Composite[] pageComposites = new Composite[elements.size()];
            list.addListener(13, new org.eclipse.swt.widgets.Listener(){

                public void handleEvent(org.eclipse.swt.widgets.Event event) {
                    int oldSelectionIndex = elements.indexOf(partToTabbedPropertyListItem.get(SapphirePropertySheetPage.this.part.getSelectedPage()));
                    int newSelectionIndex = list.getSelectionIndex();
                    Composite newPageComposite = pageComposites[newSelectionIndex];
                    if (newSelectionIndex != oldSelectionIndex || newPageComposite == null) {
                        Composite oldPageComposite;
                        Composite composite = oldPageComposite = oldSelectionIndex != -1 ? pageComposites[oldSelectionIndex] : null;
                        if (oldPageComposite != null) {
                            oldPageComposite.setVisible(false);
                        }
                        PropertiesViewContributionPagePart pagePart = (PropertiesViewContributionPagePart)visiblePages.get(newSelectionIndex);
                        SapphirePropertySheetPage.this.part.setSelectedPage(pagePart);
                        if (newPageComposite == null) {
                            newPageComposite = new Composite(tabbedPropertiesComposite.getTabComposite(), 524288);
                            newPageComposite.setBackground(SapphirePropertySheetPage.this.backgroundColor);
                            newPageComposite.setVisible(false);
                            FormData data = new FormData();
                            data.top = new FormAttachment(0, 0);
                            data.bottom = new FormAttachment(100, 0);
                            data.left = new FormAttachment(0, 0);
                            data.right = new FormAttachment(100, 0);
                            newPageComposite.setLayoutData((Object)data);
                            newPageComposite.setLayout((Layout)GridLayoutUtil.glayout(2, 5, 5, 10, 10));
                            SapphireRenderingContext context = new SapphireRenderingContext(pagePart, newPageComposite){

                                public void adapt(Control control) {
                                    control.setBackground(SapphirePropertySheetPage.this.backgroundColor);
                                }
                            };
                            pagePart.render(context);
                            pageComposites[newSelectionIndex] = newPageComposite;
                        }
                        newPageComposite.moveAbove(null);
                        newPageComposite.setVisible(true);
                        tabbedPropertiesComposite.resizeScrolledComposite(newPageComposite);
                        newPageComposite.getParent().layout(true, true);
                    }
                }
            });
            TabbedPropertyList.Item initialSelectedItem = (TabbedPropertyList.Item)partToTabbedPropertyListItem.get(this.part.getSelectedPage());
            if (initialSelectedItem == null) {
                initialSelectedItem = (TabbedPropertyList.Item)elements.get(0);
            }
            list.select(initialSelectedItem);
        }
        this.composite.layout(true, true);
    }

    public Control getControl() {
        return this.composite;
    }

    public void setFocus() {
    }

    public void setActionBars(IActionBars actionBars) {
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
    }

    public void dispose() {
        if (this.composite != null) {
            this.composite.dispose();
            this.composite = null;
        }
        if (this.noPropertiesFont != null) {
            this.noPropertiesFont.dispose();
            this.noPropertiesFont = null;
            this.noPropertiesFontColor.dispose();
            this.noPropertiesFontColor = null;
        }
    }

    private static final class Resources
    extends NLS {
        public static String noProperties;

        static {
            Resources.initializeMessages((String)SapphirePropertySheetPage.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

