/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.xml.schema;

import javax.xml.namespace.QName;
import org.eclipse.sapphire.modeling.util.MiscUtil;
import org.eclipse.sapphire.modeling.xml.schema.XmlContentModel;
import org.eclipse.sapphire.modeling.xml.schema.XmlDocumentSchema;
import org.eclipse.sapphire.modeling.xml.schema.XmlDocumentSchemasCache;
import org.w3c.dom.NodeList;

public final class XmlContentModelReference
extends XmlContentModel {
    private QName contentModelName;

    protected XmlContentModelReference(XmlDocumentSchema schema, QName contentModelName, int minOccur, int maxOccur) {
        super(schema, minOccur, maxOccur);
        this.contentModelName = contentModelName;
    }

    public QName getContentModelName() {
        return this.contentModelName;
    }

    public XmlContentModel getContentModel() {
        QName contentModelName = this.getContentModelName();
        if (contentModelName == null) {
            return null;
        }
        String namespace = contentModelName.getNamespaceURI();
        String localName = contentModelName.getLocalPart();
        if (namespace.equals(MiscUtil.normalizeToEmptyString((String)this.schema.getNamespace()))) {
            return this.schema.getContentModel(localName);
        }
        String importedSchemaLocation = this.schema.getSchemaLocation(namespace);
        XmlDocumentSchema importedSchema = XmlDocumentSchemasCache.getSchema(importedSchemaLocation);
        return importedSchema.getContentModel(localName);
    }

    public XmlContentModel findChildElementContentModel(QName childElementName) {
        XmlContentModel contentModel = this.getContentModel();
        if (contentModel != null) {
            return contentModel.findChildElementContentModel(childElementName);
        }
        return null;
    }

    protected XmlContentModel.InsertionPosition findInsertionPosition(NodeList nodeList, int nodeListLength, QName qname, XmlContentModel.Position position) {
        XmlContentModel.InsertionPosition localResult;
        XmlContentModel.InsertionPosition result = new XmlContentModel.InsertionPosition();
        XmlContentModel contentModel = this.getContentModel();
        if (contentModel == null) {
            return result;
        }
        int i = 0;
        while (true) {
            int startingPosition = position.listIndex;
            localResult = contentModel.findInsertionPosition(nodeList, nodeListLength, qname, position);
            if (position.listIndex == startingPosition) break;
            result.merge(localResult);
            ++i;
        }
        localResult.grade = this.maxOccur != -1 && ++i > this.maxOccur ? 1 : (i <= this.minOccur ? 4 : 2);
        result.merge(localResult);
        return result;
    }

    protected void toString(StringBuilder buf, String indent) {
        buf.append(indent);
        buf.append("content-model-ref [");
        buf.append(this.minOccur);
        buf.append(':');
        buf.append(this.maxOccur);
        buf.append("]\n");
        buf.append(indent);
        buf.append("{\n");
        buf.append(indent);
        buf.append("    ref = ");
        buf.append(this.contentModelName);
        buf.append('\n');
        buf.append(indent);
        buf.append('}');
    }

    public static final class Factory
    extends XmlContentModel.Factory {
        private QName contentModelName;

        public QName getContentModelName() {
            return this.contentModelName;
        }

        public void setContentModelName(QName contentModelName) {
            this.contentModelName = contentModelName;
        }

        public void setContentModelName(String contentModelName) {
            this.contentModelName = new QName(contentModelName);
        }

        public XmlContentModel create(XmlDocumentSchema schema) {
            return new XmlContentModelReference(schema, this.contentModelName, this.minOccur, this.maxOccur);
        }
    }
}

