/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.address.internal;

import java.util.SortedSet;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyContentEvent;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.samples.address.Address;
import org.eclipse.sapphire.samples.zipcodes.ZipCodeRepository;
import org.eclipse.sapphire.services.PossibleValuesService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ZipCodePossibleValuesService
extends PossibleValuesService {
    protected void init() {
        FilteredListener<PropertyContentEvent> listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                ZipCodePossibleValuesService.this.broadcast();
            }
        };
        Address address = (Address)this.context(Address.class);
        address.attach((Listener)listener, (ModelProperty)Address.PROP_CITY);
        address.attach((Listener)listener, (ModelProperty)Address.PROP_STATE);
    }

    protected void fillPossibleValues(SortedSet<String> values) {
        Address address = (Address)this.context(Address.class);
        String city = address.getCity().getText();
        String state = address.getState().getText();
        values.addAll(ZipCodeRepository.getZipCodes(state, city));
    }

    public String getInvalidValueMessage(String invalidValue) {
        return NLS.bind((String)"\"{0}\" is not a valid ZIP code for the specified city and state.", (Object[])new Object[]{invalidValue});
    }
}

