/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.contacts.internal;

import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyContentEvent;
import org.eclipse.sapphire.samples.contacts.Contact;
import org.eclipse.sapphire.samples.contacts.ContactAddress;
import org.eclipse.sapphire.samples.contacts.PhoneNumber;
import org.eclipse.sapphire.samples.contacts.SendContactOp;
import org.eclipse.sapphire.services.DerivedValueService;
import org.eclipse.sapphire.services.DerivedValueServiceData;

public final class SendContactOpMessageBodyDerivedValueService
extends DerivedValueService {
    protected void initDerivedValueService() {
        FilteredListener<PropertyContentEvent> listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                SendContactOpMessageBodyDerivedValueService.this.refresh();
            }
        };
        ((SendContactOp)this.context(SendContactOp.class)).attach((Listener)listener, (ModelProperty)SendContactOp.PROP_CONTACT);
    }

    protected DerivedValueServiceData compute() {
        SendContactOp op = (SendContactOp)this.context(SendContactOp.class);
        Contact contact = (Contact)op.getContact().content();
        StringBuilder buf = new StringBuilder();
        buf.append("<html><body>\n");
        if (contact != null) {
            ContactAddress address;
            buf.append("<b>");
            buf.append(contact.getName().getText());
            buf.append("</b>\n");
            buf.append("<br/><hr/>\n");
            if (!contact.getPhoneNumbers().isEmpty()) {
                buf.append("<p><table>\n");
                for (PhoneNumber phone : contact.getPhoneNumbers()) {
                    buf.append("<tr><td><i>");
                    buf.append(phone.getType().getText());
                    buf.append("</i></td><td>");
                    String areaCode = phone.getAreaCode().getText();
                    String localNumber = phone.getLocalNumber().getText();
                    if (areaCode != null) {
                        buf.append('(');
                        buf.append(areaCode);
                        buf.append(") ");
                    }
                    buf.append(localNumber);
                    buf.append("</td></tr>\n");
                }
                buf.append("</table></p>\n");
            }
            if ((address = contact.getAddress()) != null && address.getStreet().getContent() != null) {
                buf.append("<p>");
                buf.append(address.getStreet().getText());
                buf.append("<br/>");
                buf.append(address.getCity().getText());
                buf.append(", ");
                buf.append(address.getState().getText());
                buf.append(' ');
                buf.append(address.getZipCode().getText());
                buf.append("</p>\n");
            }
        }
        buf.append("</body></html>");
        return new DerivedValueServiceData(buf.toString());
    }
}

