/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.sdk.build.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.sapphire.sdk.build.internal.StringResourcesExtractor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SapphireAntTask
extends Task {
    private File src = null;
    private File dest = null;

    public void setSrc(File src) {
        this.src = src;
    }

    public void setDest(File dest) {
        this.dest = dest;
    }

    public void execute() {
        if (this.src == null) {
            throw new BuildException("Attribute src not set!");
        }
        if (this.dest == null) {
            throw new BuildException("Attribute dest not set!");
        }
        HashSet<File> files = new HashSet<File>();
        SapphireAntTask.gatherSourceFiles(this.src, files);
        for (File sourceFile : files) {
            try {
                String resourceFileContent = StringResourcesExtractor.extract(sourceFile);
                if (resourceFileContent == null) continue;
                File resourceFile = new File(this.dest, SapphireAntTask.getRelativePath(sourceFile.getParentFile(), this.src));
                resourceFile = new File(resourceFile, String.valueOf(SapphireAntTask.getNameWithoutExtension(sourceFile)) + ".properties");
                resourceFile.getParentFile().mkdirs();
                FileOutputStream out = new FileOutputStream(resourceFile);
                try {
                    OutputStreamWriter writer = new OutputStreamWriter(out);
                    writer.write(resourceFileContent);
                    ((Writer)writer).flush();
                }
                catch (Throwable throwable) {
                    try {
                        ((OutputStream)out).close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException iOException) {}
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
        }
    }

    private static void gatherSourceFiles(File directory, Set<File> files) {
        File[] fileArray = directory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            if (child.isDirectory()) {
                SapphireAntTask.gatherSourceFiles(child, files);
            } else if (StringResourcesExtractor.check(child)) {
                files.add(child);
            }
            ++n2;
        }
    }

    private static String getRelativePath(File path, File base) {
        String[] splitPath = path.getAbsolutePath().split("[/\\\\]");
        String[] splitBase = base.getAbsolutePath().split("[/\\\\]");
        int i = 0;
        while (i < splitPath.length && i < splitBase.length && splitPath[i].equals(splitBase[i])) {
            ++i;
        }
        if (i != splitBase.length) {
            throw new IllegalArgumentException("path not beneath base");
        }
        StringBuilder buf = new StringBuilder();
        while (i < splitPath.length) {
            if (buf.length() > 0) {
                buf.append('/');
            }
            buf.append(splitPath[i]);
            ++i;
        }
        return buf.toString();
    }

    private static String getNameWithoutExtension(File f) {
        String fname = f.getName();
        int lastdot = fname.lastIndexOf(46);
        if (lastdot == -1) {
            return fname;
        }
        return fname.substring(0, lastdot);
    }
}

