/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.sdk.build.internal;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.Literal;
import org.eclipse.sapphire.modeling.el.PropertyAccessFunction;
import org.eclipse.sapphire.modeling.localization.Localizable;
import org.eclipse.sapphire.modeling.util.MiscUtil;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.sdk.extensibility.SapphireExtensionDef;
import org.eclipse.sapphire.ui.def.ISapphireUiDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringResourcesExtractor {
    public static boolean check(File file) {
        String fileName = file.getName();
        if (fileName.endsWith(".sdef")) {
            return true;
        }
        return fileName.equals("sapphire-extension.xml") && file.getParentFile().getName().equals("META-INF");
    }

    public static String extract(File file) throws Exception {
        HashSet<String> strings = new HashSet<String>();
        ModelElementType type = file.getName().endsWith(".sdef") ? ISapphireUiDef.TYPE : SapphireExtensionDef.TYPE;
        IModelElement root = type.instantiate((Resource)new RootXmlResource(new XmlResourceStore(file)));
        try {
            StringResourcesExtractor.gather(root, strings);
        }
        finally {
            root.dispose();
        }
        if (strings.isEmpty()) {
            return null;
        }
        Properties resources = new Properties();
        for (String string : strings) {
            resources.put(MiscUtil.createStringDigest((String)string), string);
        }
        ByteArrayOutputStream resourcesFileContentBytes = new ByteArrayOutputStream();
        resources.store(resourcesFileContentBytes, null);
        String resourcesFileContent = new String(resourcesFileContentBytes.toByteArray());
        return resourcesFileContent;
    }

    private static void gather(IModelElement element, Set<String> strings) {
        for (ModelProperty property : element.properties()) {
            IModelElement child2;
            if (property instanceof ValueProperty) {
                String defaultValue;
                DefaultValue defaultValueAnnotation;
                if (!property.hasAnnotation(Localizable.class)) continue;
                if (property.getTypeClass() == Function.class) {
                    Function function = (Function)element.read((ValueProperty)property).getContent(false);
                    if (function == null) continue;
                    StringResourcesExtractor.gather(function, strings);
                    continue;
                }
                String value = element.read((ValueProperty)property).getText(false);
                if (value != null) {
                    strings.add(value);
                }
                if ((defaultValueAnnotation = (DefaultValue)property.getAnnotation(DefaultValue.class)) == null || (defaultValue = defaultValueAnnotation.text()).length() <= 0) continue;
                strings.add(defaultValue);
                continue;
            }
            if (property instanceof ListProperty) {
                for (IModelElement child2 : element.read((ListProperty)property)) {
                    StringResourcesExtractor.gather(child2, strings);
                }
                continue;
            }
            if (!(property instanceof ElementProperty) || (child2 = element.read((ElementProperty)property).element()) == null) continue;
            StringResourcesExtractor.gather(child2, strings);
        }
    }

    private static void gather(Function function, Set<String> strings) {
        if (function instanceof Literal) {
            Object value = ((Literal)function).value();
            if (value instanceof String) {
                strings.add((String)value);
            }
        } else {
            if (function instanceof PropertyAccessFunction) {
                return;
            }
            for (Function operand : function.operands()) {
                StringResourcesExtractor.gather(operand, strings);
            }
        }
    }
}

