/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.sdk.internal;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.java.jdt.JdtUtil;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyContentEvent;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.sdk.CreateExtensionManifestOp;
import org.eclipse.sapphire.services.InitialValueService;
import org.eclipse.sapphire.services.InitialValueServiceData;
import org.eclipse.sapphire.services.ValidationService;

public final class CreateExtensionManifestOpServices {
    private CreateExtensionManifestOpServices() {
    }

    public static final class FolderInitialValueService
    extends InitialValueService {
        private Listener listener;

        protected void initInitialValueService() {
            this.listener = new FilteredListener<PropertyContentEvent>(){

                protected void handleTypedEvent(PropertyContentEvent event) {
                    FolderInitialValueService.this.refresh();
                }
            };
            ((CreateExtensionManifestOp)this.context(CreateExtensionManifestOp.class)).attach(this.listener, (ModelProperty)CreateExtensionManifestOp.PROP_CONTEXT);
        }

        protected InitialValueServiceData compute() {
            IContainer sourceFolder;
            CreateExtensionManifestOp op = (CreateExtensionManifestOp)this.context(CreateExtensionManifestOp.class);
            IResource folder = (IResource)op.getContext().content();
            if (folder != null && (sourceFolder = JdtUtil.findSourceFolder((IResource)folder)) != null) {
                folder = sourceFolder.getFolder((IPath)new Path("META-INF"));
            }
            return new InitialValueServiceData(folder == null ? null : folder.getFullPath().makeRelative().toPortableString());
        }

        public void dispose() {
            super.dispose();
            if (this.listener != null) {
                ((CreateExtensionManifestOp)this.context(CreateExtensionManifestOp.class)).detach(this.listener, (ModelProperty)CreateExtensionManifestOp.PROP_CONTEXT);
            }
        }
    }

    public static final class FolderValidationService
    extends ValidationService {
        public Status validate() {
            IResource resource;
            Value target = ((IModelElement)this.context(IModelElement.class)).read((ValueProperty)this.context(ValueProperty.class));
            org.eclipse.sapphire.modeling.Path path = (org.eclipse.sapphire.modeling.Path)target.getContent();
            if (path != null && (resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path.toPortableString())) != null) {
                IPath pathRelativeToWorkspace = resource.getFullPath();
                boolean locatedInSourceFolder = false;
                for (IContainer sourceFolder : JdtUtil.findSourceFolders((IResource)resource)) {
                    IPath sourceFolderFullPath = sourceFolder.getFullPath();
                    if (!sourceFolderFullPath.isPrefixOf(pathRelativeToWorkspace)) continue;
                    locatedInSourceFolder = true;
                    IPath pathRelativeToSourceFolder = pathRelativeToWorkspace.makeRelativeTo(sourceFolderFullPath);
                    if (pathRelativeToSourceFolder.equals((Object)new Path("META-INF"))) continue;
                    String msg = NLS.bind((String)Resources.invalidFolder, (Object[])new Object[]{path.toPortableString()});
                    return Status.createWarningStatus((String)msg);
                }
                if (!locatedInSourceFolder) {
                    String msg = NLS.bind((String)Resources.invalidFolder, (Object[])new Object[]{path.toPortableString()});
                    return Status.createWarningStatus((String)msg);
                }
            }
            return Status.createOkStatus();
        }
    }

    private static final class Resources
    extends NLS {
        public static String invalidFolder;

        static {
            Resources.initializeMessages((String)CreateExtensionManifestOpServices.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

