/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.java.jdt;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaJdtTestHelper {
    private final Class<?> testClass;
    private final String testCaseName;
    private IJavaProject project;

    public JavaJdtTestHelper(Class<?> testClass, String testCaseName) {
        this.testClass = testClass;
        this.testCaseName = testCaseName;
    }

    public IJavaProject getJavaProject() throws Exception {
        if (this.project == null) {
            String name = String.valueOf(this.testClass.getName()) + "." + this.testCaseName;
            IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
            p.create(null);
            p.open(null);
            IProjectDescription desc = p.getDescription();
            desc.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature"});
            p.setDescription(desc, null);
            this.project = JavaCore.create((IProject)p);
            IFolder srcFolder = p.getFolder("src");
            this.create(srcFolder);
            IFolder binFolder = p.getFolder("bin");
            this.create(binFolder);
            IClasspathEntry[] cp = new IClasspathEntry[]{JavaRuntime.getDefaultJREContainerEntry(), JavaCore.newSourceEntry((IPath)srcFolder.getFullPath())};
            this.project.setRawClasspath(cp, binFolder.getFullPath(), null);
        }
        return this.project;
    }

    public void writeJavaSourceFile(String packageName, String className, String content) throws Exception {
        IProject project = this.getJavaProject().getProject();
        IFolder folder = project.getFolder("src");
        StringBuilder buf = new StringBuilder();
        if (packageName != null) {
            if (!(folder = folder.getFolder(packageName.replace('.', '/'))).exists()) {
                this.create(folder);
            }
            buf.append("import " + packageName + ";\n\n");
        }
        buf.append(content);
        byte[] bytes = buf.toString().getBytes("UTF-8");
        IFile file = folder.getFile(String.valueOf(className) + ".java");
        file.create((InputStream)new ByteArrayInputStream(bytes), true, null);
    }

    public void create(IFolder folder) throws Exception {
        if (!folder.exists()) {
            IContainer parent = folder.getParent();
            if (parent instanceof IFolder) {
                this.create((IFolder)parent);
            }
            folder.create(true, true, null);
        }
    }

    public void dispose() throws Exception {
        if (this.project != null) {
            this.project.getProject().delete(true, null);
        }
    }
}

