/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.misc.t0002;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.sapphire.Version;
import org.eclipse.sapphire.tests.SapphireTestCase;

public final class TestMisc0002
extends SapphireTestCase {
    private TestMisc0002(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("TestMisc0002");
        suite.addTest((Test)new TestMisc0002("testVersionFromString_Basic"));
        suite.addTest((Test)new TestMisc0002("testVersionFromString_LongSegment"));
        suite.addTest((Test)new TestMisc0002("testVersionFromString_InvalidFormat"));
        suite.addTest((Test)new TestMisc0002("testVersionFromLong"));
        suite.addTest((Test)new TestMisc0002("testVersionCanonicalization"));
        suite.addTest((Test)new TestMisc0002("testVersionComparison"));
        suite.addTest((Test)new TestMisc0002("testVersionEquals"));
        suite.addTest((Test)new TestMisc0002("testVersionToString"));
        return suite;
    }

    public void testVersionFromString_Basic() {
        Version version = new Version("1");
        TestMisc0002.assertEquals((int)1, (int)version.length());
        TestMisc0002.assertEquals((long)1L, (long)version.segment(0));
        TestMisc0002.assertEquals(TestMisc0002.list(1L), (Object)version.segments());
        version = new Version("1.2");
        TestMisc0002.assertEquals((int)2, (int)version.length());
        TestMisc0002.assertEquals((long)1L, (long)version.segment(0));
        TestMisc0002.assertEquals((long)2L, (long)version.segment(1));
        TestMisc0002.assertEquals(TestMisc0002.list(1L, 2L), (Object)version.segments());
        version = new Version("1.2.3");
        TestMisc0002.assertEquals((int)3, (int)version.length());
        TestMisc0002.assertEquals((long)1L, (long)version.segment(0));
        TestMisc0002.assertEquals((long)2L, (long)version.segment(1));
        TestMisc0002.assertEquals((long)3L, (long)version.segment(2));
        TestMisc0002.assertEquals(TestMisc0002.list(1L, 2L, 3L), (Object)version.segments());
    }

    public void testVersionFromString_LongSegment() {
        Version version = new Version("1.2.3.201206260957");
        TestMisc0002.assertEquals((int)4, (int)version.length());
        TestMisc0002.assertEquals((long)1L, (long)version.segment(0));
        TestMisc0002.assertEquals((long)2L, (long)version.segment(1));
        TestMisc0002.assertEquals((long)3L, (long)version.segment(2));
        TestMisc0002.assertEquals((long)201206260957L, (long)version.segment(3));
        TestMisc0002.assertEquals(TestMisc0002.list(1L, 2L, 3L, 201206260957L), (Object)version.segments());
    }

    public void testVersionFromString_InvalidFormat() {
        try {
            new Version(null);
            TestMisc0002.fail((String)"IllegalArgumentException not thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            new Version("");
            TestMisc0002.fail((String)"IllegalArgumentException not thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            new Version(".1.2.3");
            TestMisc0002.fail((String)"IllegalArgumentException not thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            new Version("1.2.3.");
            TestMisc0002.fail((String)"IllegalArgumentException not thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            new Version("1..2.3");
            TestMisc0002.fail((String)"IllegalArgumentException not thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            new Version("abc");
            TestMisc0002.fail((String)"IllegalArgumentException not thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            new Version("1.2.abc");
            TestMisc0002.fail((String)"IllegalArgumentException not thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            new Version("1.2.v345");
            TestMisc0002.fail((String)"IllegalArgumentException not thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            new Version("1.2.345abc");
            TestMisc0002.fail((String)"IllegalArgumentException not thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testVersionFromLong() {
        Version version = new Version(1L);
        TestMisc0002.assertEquals((int)1, (int)version.length());
        TestMisc0002.assertEquals((long)1L, (long)version.segment(0));
        TestMisc0002.assertEquals(TestMisc0002.list(1L), (Object)version.segments());
        version = new Version(201206260957L);
        TestMisc0002.assertEquals((int)1, (int)version.length());
        TestMisc0002.assertEquals((long)201206260957L, (long)version.segment(0));
        TestMisc0002.assertEquals(TestMisc0002.list(201206260957L), (Object)version.segments());
    }

    public void testVersionCanonicalization() {
        Version version = new Version("1.2.3.0");
        TestMisc0002.assertEquals((int)3, (int)version.length());
        TestMisc0002.assertEquals((long)1L, (long)version.segment(0));
        TestMisc0002.assertEquals((long)2L, (long)version.segment(1));
        TestMisc0002.assertEquals((long)3L, (long)version.segment(2));
        TestMisc0002.assertEquals((long)0L, (long)version.segment(3));
        TestMisc0002.assertEquals((long)0L, (long)version.segment(1000));
        TestMisc0002.assertEquals(TestMisc0002.list(1L, 2L, 3L), (Object)version.segments());
        version = new Version("1.2.3.0.0.0.0");
        TestMisc0002.assertEquals((int)3, (int)version.length());
        TestMisc0002.assertEquals((long)1L, (long)version.segment(0));
        TestMisc0002.assertEquals((long)2L, (long)version.segment(1));
        TestMisc0002.assertEquals((long)3L, (long)version.segment(2));
        TestMisc0002.assertEquals((long)0L, (long)version.segment(3));
        TestMisc0002.assertEquals((long)0L, (long)version.segment(4));
        TestMisc0002.assertEquals((long)0L, (long)version.segment(5));
        TestMisc0002.assertEquals((long)0L, (long)version.segment(6));
        TestMisc0002.assertEquals((long)0L, (long)version.segment(1000));
        TestMisc0002.assertEquals(TestMisc0002.list(1L, 2L, 3L), (Object)version.segments());
    }

    public void testVersionComparison() {
        this.testVersionComparisonSame(new Version(1L), new Version("1"));
        this.testVersionComparisonSame(new Version("1.2.3"), new Version("1.2.3"));
        this.testVersionComparisonSame(new Version("1.2.3"), new Version("1.2.3.0.0"));
        this.testVersionComparisonDifferent(new Version("1.2.4"), new Version("1.2.3"));
        this.testVersionComparisonDifferent(new Version("1.3.3"), new Version("1.2.3"));
        this.testVersionComparisonDifferent(new Version("2.2.3"), new Version("1.2.3"));
        this.testVersionComparisonDifferent(new Version("1.2.3"), new Version("1.2"));
        this.testVersionComparisonDifferent(new Version("1.2.3"), new Version("1"));
        this.testVersionComparisonDifferent(new Version("1.2.3"), new Version(1L));
    }

    private void testVersionComparisonSame(Version x, Version y) {
        TestMisc0002.assertTrue((x.compareTo(y) == 0 ? 1 : 0) != 0);
        TestMisc0002.assertTrue((y.compareTo(x) == 0 ? 1 : 0) != 0);
    }

    private void testVersionComparisonDifferent(Version x, Version y) {
        TestMisc0002.assertTrue((x.compareTo(y) > 0 ? 1 : 0) != 0);
        TestMisc0002.assertTrue((y.compareTo(x) < 0 ? 1 : 0) != 0);
    }

    public void testVersionEquals() {
        this.testVersionEquals(new Version(1L), new Version("1"));
        this.testVersionEquals(new Version("1.2.3"), new Version("1.2.3"));
        this.testVersionEquals(new Version("1.2.3"), new Version("1.2.3.0.0"));
        this.testVersionNotEquals(new Version("1.2.3"), new Version("1.2"));
        this.testVersionNotEquals(new Version("1.2.3"), new Version("4.5.6"));
    }

    private void testVersionEquals(Version x, Version y) {
        TestMisc0002.assertTrue((boolean)x.equals((Object)y));
        TestMisc0002.assertTrue((boolean)y.equals((Object)x));
        TestMisc0002.assertTrue((x.hashCode() == y.hashCode() ? 1 : 0) != 0);
    }

    private void testVersionNotEquals(Version x, Version y) {
        TestMisc0002.assertFalse((boolean)x.equals((Object)y));
        TestMisc0002.assertFalse((boolean)y.equals((Object)x));
    }

    public void testVersionToString() {
        TestMisc0002.assertEquals((String)"1", (String)new Version(1L).toString());
        TestMisc0002.assertEquals((String)"1", (String)new Version("1").toString());
        TestMisc0002.assertEquals((String)"1.2.3", (String)new Version("1.2.3").toString());
        TestMisc0002.assertEquals((String)"1.2.3.201206260957", (String)new Version("1.2.3.201206260957").toString());
        TestMisc0002.assertEquals((String)"1.2.3", (String)new Version("1.2.3.0").toString());
        TestMisc0002.assertEquals((String)"1.2.3", (String)new Version("1.2.3.0.0.0.0").toString());
    }
}

