/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.el;

import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.ModelElementFunctionContext;
import org.eclipse.sapphire.modeling.el.parser.ExpressionLanguageParser;
import org.eclipse.sapphire.tests.SapphireTestCase;

public abstract class TestExpr
extends SapphireTestCase {
    protected TestExpr(String name) {
        super(name);
    }

    protected static void testForExpectedValue(FunctionContext context, String expr, Object expected) {
        TestExpr.testForExpectedValue(context, ExpressionLanguageParser.parse((String)expr), expected);
    }

    protected static void testForExpectedValue(FunctionContext context, Function expr, Object expected) {
        FunctionResult result = expr.evaluate(context);
        try {
            TestExpr.assertEquals((Object)expected, (Object)result.value());
        }
        finally {
            result.dispose();
        }
    }

    protected static void testForExpectedValue(IModelElement element, String expr, Object expected) {
        TestExpr.testForExpectedValue((FunctionContext)new ModelElementFunctionContext(element), expr, expected);
    }

    protected static void testForExpectedError(FunctionContext context, String expr, String expected) {
        FunctionResult result = ExpressionLanguageParser.parse((String)expr).evaluate(context);
        try {
            Status status = result.status();
            TestExpr.assertEquals((Object)Status.Severity.ERROR, (Object)status.severity());
            TestExpr.assertEquals((String)expected, (String)status.message());
        }
        finally {
            result.dispose();
        }
    }
}

