/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.el.t0011;

import java.math.BigDecimal;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.Literal;
import org.eclipse.sapphire.modeling.el.ModelElementFunctionContext;
import org.eclipse.sapphire.modeling.el.parser.ExpressionLanguageParser;
import org.eclipse.sapphire.tests.modeling.el.TestExpr;
import org.eclipse.sapphire.tests.modeling.el.t0011.TestModelElementA;
import org.eclipse.sapphire.tests.modeling.el.t0011.TestModelRoot;

public final class TestExpr0011
extends TestExpr {
    private TestExpr0011(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("TestExpr0011");
        suite.addTest((Test)new TestExpr0011("testWithArray"));
        suite.addTest((Test)new TestExpr0011("testWithList"));
        suite.addTest((Test)new TestExpr0011("testWithSet"));
        suite.addTest((Test)new TestExpr0011("testWithModelElementList"));
        return suite;
    }

    public void testWithArray() {
        TestFunctionContext context = new TestFunctionContext(new Object[0]);
        TestExpr0011.testForExpectedValue((FunctionContext)context, "${ Avg( Collection ) }", (Object)new BigDecimal("0"));
        context = new TestFunctionContext(new Object[]{"1"});
        TestExpr0011.testForExpectedValue((FunctionContext)context, "${ Avg( Collection ) }", (Object)new BigDecimal("1"));
        context = new TestFunctionContext(new Object[]{"1", "2", "3.5"});
        TestExpr0011.testForExpectedValue((FunctionContext)context, "${ Avg( Collection ) }", (Object)new BigDecimal("2.2"));
        context = new TestFunctionContext(new Object[]{"1", 2, new BigDecimal("3.5")});
        TestExpr0011.testForExpectedValue((FunctionContext)context, "${ Avg( Collection ) }", (Object)new BigDecimal("2.2"));
    }

    public void testWithList() {
        TestFunctionContext context = new TestFunctionContext(TestExpr0011.list(new Object[0]));
        TestExpr0011.testForExpectedValue((FunctionContext)context, "${ Avg( Collection ) }", (Object)new BigDecimal("0"));
        context = new TestFunctionContext(TestExpr0011.list("1"));
        TestExpr0011.testForExpectedValue((FunctionContext)context, "${ Avg( Collection ) }", (Object)new BigDecimal("1"));
        context = new TestFunctionContext(TestExpr0011.list("1", "2", "3.5"));
        TestExpr0011.testForExpectedValue((FunctionContext)context, "${ Avg( Collection ) }", (Object)new BigDecimal("2.2"));
        context = new TestFunctionContext(TestExpr0011.list("1", 2, new BigDecimal("3.5")));
        TestExpr0011.testForExpectedValue((FunctionContext)context, "${ Avg( Collection ) }", (Object)new BigDecimal("2.2"));
    }

    public void testWithSet() {
        TestFunctionContext context = new TestFunctionContext(TestExpr0011.set(new Object[0]));
        TestExpr0011.testForExpectedValue((FunctionContext)context, "${ Avg( Collection ) }", (Object)new BigDecimal("0"));
        context = new TestFunctionContext(TestExpr0011.set("1"));
        TestExpr0011.testForExpectedValue((FunctionContext)context, "${ Avg( Collection ) }", (Object)new BigDecimal("1"));
        context = new TestFunctionContext(TestExpr0011.set("1", "2", "3.5"));
        TestExpr0011.testForExpectedValue((FunctionContext)context, "${ Avg( Collection ) }", (Object)new BigDecimal("2.2"));
        context = new TestFunctionContext(TestExpr0011.set("1", 2, new BigDecimal("3.5")));
        TestExpr0011.testForExpectedValue((FunctionContext)context, "${ Avg( Collection ) }", (Object)new BigDecimal("2.2"));
    }

    public void testWithModelElementList() {
        TestModelRoot root = (TestModelRoot)TestModelRoot.TYPE.instantiate();
        ModelElementList<TestModelElementA> list = root.getList1();
        ModelElementFunctionContext context = new ModelElementFunctionContext((IModelElement)root);
        TestExpr0011.testForExpectedValue((FunctionContext)context, "${ Avg( List1 ) }", (Object)new BigDecimal("0"));
        TestExpr0011.testForExpectedValue((FunctionContext)context, "${ Avg( List1, 'Value1' ) }", (Object)new BigDecimal("0"));
        TestExpr0011.testForExpectedValue((FunctionContext)context, "${ Avg( List1, 'Value2' ) }", (Object)new BigDecimal("0"));
        TestModelElementA a = (TestModelElementA)list.insert();
        a.setValue1("1");
        a.setValue2(2);
        TestExpr0011.testForExpectedValue((FunctionContext)context, "${ Avg( List1 ) }", (Object)new BigDecimal("1"));
        TestExpr0011.testForExpectedValue((FunctionContext)context, "${ Avg( List1, 'Value1' ) }", (Object)new BigDecimal("1"));
        TestExpr0011.testForExpectedValue((FunctionContext)context, "${ Avg( List1, 'Value2' ) }", (Object)new BigDecimal("2"));
        a = (TestModelElementA)list.insert();
        a.setValue1("2");
        a.setValue2(3);
        a = (TestModelElementA)list.insert();
        a.setValue1("3.5");
        a.setValue2(4);
        TestExpr0011.testForExpectedValue((FunctionContext)context, "${ Avg( List1 ) }", (Object)new BigDecimal("2.2"));
        TestExpr0011.testForExpectedValue((FunctionContext)context, "${ Avg( List1, 'Value1' ) }", (Object)new BigDecimal("2.2"));
        TestExpr0011.testForExpectedValue((FunctionContext)context, "${ Avg( List1, 'Value2' ) }", (Object)new BigDecimal("3"));
        TestExpr0011.testForExpectedError((FunctionContext)context, "${ Avg( List1, 'abc' ) }", "Property TestModelElementA.abc could not be found.");
        TestExpr0011.testForExpectedError((FunctionContext)context, "${ Avg( List1, 'Element1' ) }", "Property TestModelElementA.Element1 is not a value property.");
        TestExpr0011.testForExpectedError((FunctionContext)context, "${ Avg( List2 ) }", "Element type TestModelElementB does not contain a value property.");
        FunctionResult result = ExpressionLanguageParser.parse((String)"${ Avg( List1, 'Value1' ) }").evaluate((FunctionContext)context);
        TestExpr0011.assertEquals((Object)new BigDecimal("2.2"), (Object)result.value());
        ((TestModelElementA)list.get(0)).setValue1("2");
        ((TestModelElementA)list.get(1)).setValue1("3.5");
        TestExpr0011.assertEquals((Object)new BigDecimal("3.0"), (Object)result.value());
        a = (TestModelElementA)list.insert();
        a.setValue1("5.2");
        TestExpr0011.assertEquals((Object)new BigDecimal("3.6"), (Object)result.value());
    }

    private static final class TestFunctionContext
    extends FunctionContext {
        private final Object collection;

        public TestFunctionContext(Object collection) {
            this.collection = collection;
        }

        public FunctionResult property(Object element, String name) {
            if (element == this && name.equalsIgnoreCase("Collection")) {
                return Literal.create((Object)this.collection).evaluate((FunctionContext)this);
            }
            return super.property(element, name);
        }
    }
}

