/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.el.t0015;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.ModelElementFunctionContext;
import org.eclipse.sapphire.tests.modeling.el.TestExpr;
import org.eclipse.sapphire.tests.modeling.el.t0015.ChildElement;
import org.eclipse.sapphire.tests.modeling.el.t0015.RootElement;

public final class TestExpr0015
extends TestExpr {
    private TestExpr0015(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("TestExpr0015");
        suite.addTest((Test)new TestExpr0015("testEnabledFunction"));
        return suite;
    }

    public void testEnabledFunction() {
        RootElement root = (RootElement)RootElement.TYPE.instantiate();
        ModelElementFunctionContext context = new ModelElementFunctionContext((IModelElement)root);
        TestExpr0015.testForExpectedValue((FunctionContext)context, "${ Enabled( 'Value' ) }", (Object)Boolean.FALSE);
        root.setEnableValue(true);
        TestExpr0015.testForExpectedValue((FunctionContext)context, "${ Enabled( 'Value' ) }", (Object)Boolean.TRUE);
        root.setEnableValue(false);
        TestExpr0015.testForExpectedValue((FunctionContext)context, "${ Enabled( 'Value' ) }", (Object)Boolean.FALSE);
        TestExpr0015.testForExpectedValue((FunctionContext)context, "${ Enabled( 'Child' ) }", (Object)Boolean.FALSE);
        root.setEnableChild(true);
        TestExpr0015.testForExpectedValue((FunctionContext)context, "${ Enabled( 'Child' ) }", (Object)Boolean.TRUE);
        ChildElement child = root.getChild();
        TestExpr0015.testForExpectedValue((FunctionContext)context, "${ Enabled( Child, 'Value' ) }", (Object)Boolean.FALSE);
        child.setEnableValue(true);
        TestExpr0015.testForExpectedValue((FunctionContext)context, "${ Enabled( Child, 'Value' ) }", (Object)Boolean.TRUE);
        child.setEnableValue(false);
        TestExpr0015.testForExpectedValue((FunctionContext)context, "${ Enabled( Child, 'Value' ) }", (Object)Boolean.FALSE);
        TestExpr0015.testForExpectedValue((FunctionContext)context, "${ Enabled( null ) }", null);
        TestExpr0015.testForExpectedValue((FunctionContext)context, "${ Enabled( 'Aklkksjdlfksd' ) }", null);
        TestExpr0015.testForExpectedValue((FunctionContext)context, "${ Enabled( Child, null ) }", null);
        TestExpr0015.testForExpectedValue((FunctionContext)context, "${ Enabled( Child, 'Aslkdjfsldkj' ) }", null);
        TestExpr0015.testForExpectedValue((FunctionContext)context, "${ Enabled( null, 'Value' ) }", null);
        TestExpr0015.testForExpectedValue((FunctionContext)context, "${ Enabled( null, null ) }", null);
        TestExpr0015.testForExpectedError((FunctionContext)context, "${ Enabled() }", "Enabled() function does not support 0 arguments.");
        TestExpr0015.testForExpectedError((FunctionContext)context, "${ Enabled( null, null, null ) }", "Enabled() function does not support 3 arguments.");
        TestExpr0015.testForExpectedError(new FunctionContext(), "${ Enabled( 'Abc') }", "Context element not found.");
    }
}

