/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.events.t0003;

import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.tests.SapphireTestCase;
import org.eclipse.sapphire.tests.modeling.events.t0003.ChildElement;
import org.eclipse.sapphire.tests.modeling.events.t0003.RootElement;

public final class TestModelingEvents0003
extends SapphireTestCase {
    private TestModelingEvents0003(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("TestModelingEvents0003");
        suite.addTest((Test)new TestModelingEvents0003("testElementPropertyEvents"));
        return suite;
    }

    public void testElementPropertyEvents() throws Exception {
        RootElement root = (RootElement)RootElement.TYPE.instantiate();
        final ArrayList events = new ArrayList();
        Listener listener = new Listener(){

            public void handle(Event event) {
                events.add(event);
            }
        };
        root.attach(listener);
        TestModelingEvents0003.assertValidationError(root.getChild().validation(), "Child must be specified.");
        TestModelingEvents0003.assertValidationError(root.validation(), "Child must be specified.");
        TestModelingEvents0003.assertEquals((int)2, (int)events.size());
        TestModelingEvents0003.assertPropertyInitializationEvent((Event)events.get(0), root, (ModelProperty)RootElement.PROP_ENABLEMENT);
        TestModelingEvents0003.assertPropertyInitializationEvent((Event)events.get(1), root, (ModelProperty)RootElement.PROP_CHILD);
        events.clear();
        ChildElement child1 = (ChildElement)root.getChild().element(true);
        child1.attach(listener);
        TestModelingEvents0003.assertEquals((int)3, (int)events.size());
        TestModelingEvents0003.assertPropertyContentEvent((Event)events.get(0), root, (ModelProperty)RootElement.PROP_CHILD);
        TestModelingEvents0003.assertPropertyValidationEvent((Event)events.get(1), root, (ModelProperty)RootElement.PROP_CHILD, Status.createErrorStatus((String)"Child must be specified."), Status.createOkStatus());
        TestModelingEvents0003.assertElementValidationEvent((Event)events.get(2), root, Status.createErrorStatus((String)"Child must be specified."), Status.createOkStatus());
        events.clear();
        child1.setIntegerValue("abc");
        TestModelingEvents0003.assertEquals((int)5, (int)events.size());
        TestModelingEvents0003.assertPropertyContentEvent((Event)events.get(0), child1, (ModelProperty)ChildElement.PROP_INTEGER_VALUE);
        TestModelingEvents0003.assertPropertyValidationEvent((Event)events.get(1), child1, (ModelProperty)ChildElement.PROP_INTEGER_VALUE, Status.createOkStatus(), Status.createErrorStatus((String)"\"abc\" is not a valid integer."));
        TestModelingEvents0003.assertElementValidationEvent((Event)events.get(2), child1, Status.createOkStatus(), Status.createErrorStatus((String)"\"abc\" is not a valid integer."));
        TestModelingEvents0003.assertPropertyValidationEvent((Event)events.get(3), root, (ModelProperty)RootElement.PROP_CHILD, Status.createOkStatus(), Status.createErrorStatus((String)"\"abc\" is not a valid integer."));
        TestModelingEvents0003.assertElementValidationEvent((Event)events.get(4), root, Status.createOkStatus(), Status.createErrorStatus((String)"\"abc\" is not a valid integer."));
        events.clear();
        root.getChild().remove();
        TestModelingEvents0003.assertEquals((int)4, (int)events.size());
        TestModelingEvents0003.assertElementDisposeEvent((Event)events.get(0), child1);
        TestModelingEvents0003.assertPropertyContentEvent((Event)events.get(1), root, (ModelProperty)RootElement.PROP_CHILD);
        TestModelingEvents0003.assertPropertyValidationEvent((Event)events.get(2), root, (ModelProperty)RootElement.PROP_CHILD, Status.createErrorStatus((String)"\"abc\" is not a valid integer."), Status.createErrorStatus((String)"Child must be specified."));
        TestModelingEvents0003.assertElementValidationEvent((Event)events.get(3), root, Status.createErrorStatus((String)"\"abc\" is not a valid integer."), Status.createErrorStatus((String)"Child must be specified."));
        events.clear();
        ChildElement child2 = (ChildElement)root.getChild().element(true);
        child2.attach(listener);
        root.setEnablement(false);
        root.setEnablement(true);
        TestModelingEvents0003.assertEquals((int)9, (int)events.size());
        TestModelingEvents0003.assertPropertyContentEvent((Event)events.get(0), root, (ModelProperty)RootElement.PROP_CHILD);
        TestModelingEvents0003.assertPropertyValidationEvent((Event)events.get(1), root, (ModelProperty)RootElement.PROP_CHILD, Status.createErrorStatus((String)"Child must be specified."), Status.createOkStatus());
        TestModelingEvents0003.assertElementValidationEvent((Event)events.get(2), root, Status.createErrorStatus((String)"Child must be specified."), Status.createOkStatus());
        TestModelingEvents0003.assertPropertyContentEvent((Event)events.get(3), root, (ModelProperty)RootElement.PROP_ENABLEMENT);
        TestModelingEvents0003.assertPropertyEnablementEvent((Event)events.get(4), root, (ModelProperty)RootElement.PROP_CHILD, true, false);
        TestModelingEvents0003.assertPropertyEnablementEvent((Event)events.get(5), child2, (ModelProperty)ChildElement.PROP_INTEGER_VALUE, true, false);
        TestModelingEvents0003.assertPropertyContentEvent((Event)events.get(6), root, (ModelProperty)RootElement.PROP_ENABLEMENT);
        TestModelingEvents0003.assertPropertyEnablementEvent((Event)events.get(7), root, (ModelProperty)RootElement.PROP_CHILD, false, true);
        TestModelingEvents0003.assertPropertyEnablementEvent((Event)events.get(8), child2, (ModelProperty)ChildElement.PROP_INTEGER_VALUE, false, true);
        events.clear();
        root.dispose();
        TestModelingEvents0003.assertEquals((int)2, (int)events.size());
        TestModelingEvents0003.assertElementDisposeEvent((Event)events.get(0), root);
        TestModelingEvents0003.assertElementDisposeEvent((Event)events.get(1), child2);
    }
}

