/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.xml.dtd.t0005;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.modeling.xml.schema.XmlDocumentSchema;
import org.eclipse.sapphire.modeling.xml.schema.XmlDocumentSchemasCache;
import org.eclipse.sapphire.tests.SapphireTestCase;

public final class TestCatalogResolution
extends SapphireTestCase {
    private TestCatalogResolution(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("TestCatalogResolution");
        suite.addTest((Test)new TestCatalogResolution("testSystemContribution"));
        suite.addTest((Test)new TestCatalogResolution("testPublicContribution1"));
        suite.addTest((Test)new TestCatalogResolution("testPublicContribution2"));
        return suite;
    }

    public void testSystemContribution() throws Exception {
        XmlDocumentSchema schema = XmlDocumentSchemasCache.getSchema(null, null, (String)"http://www.eclipse.org/sapphire/tests/xml/dtd/0005s.dtd");
        TestCatalogResolution.assertNotNull((Object)schema);
        TestCatalogResolution.assertNotNull((Object)schema.getElement("system"));
        XmlResourceStore store = new XmlResourceStore(this.loadResource("System.xml"));
        XmlElement element = new XmlElement(store, store.getDomDocument().getDocumentElement());
        TestCatalogResolution.assertNotNull((Object)element.getContentModel());
    }

    public void testPublicContribution1() throws Exception {
        XmlDocumentSchema schema = XmlDocumentSchemasCache.getSchema(null, (String)"-//Sapphire//TestCatalogResolution1//EN", (String)"http://www.eclipse.org/sapphire/tests/xml/dtd/0005p.dtd");
        TestCatalogResolution.assertNotNull((Object)schema);
        TestCatalogResolution.assertNotNull((Object)schema.getElement("public"));
        XmlResourceStore store = new XmlResourceStore(this.loadResource("Public1.xml"));
        XmlElement element = new XmlElement(store, store.getDomDocument().getDocumentElement());
        TestCatalogResolution.assertNotNull((Object)element.getContentModel());
    }

    public void testPublicContribution2() throws Exception {
        XmlDocumentSchema schema = XmlDocumentSchemasCache.getSchema(null, (String)"-//Sapphire//TestCatalogResolution2//EN", (String)"http://www.eclipse.org/sapphire/tests/xml/dtd/0005p.dtd");
        TestCatalogResolution.assertNotNull((Object)schema);
        TestCatalogResolution.assertNotNull((Object)schema.getElement("public"));
        XmlResourceStore store = new XmlResourceStore(this.loadResource("Public2.xml"));
        XmlElement element = new XmlElement(store, store.getDomDocument().getDocumentElement());
        TestCatalogResolution.assertNotNull((Object)element.getContentModel());
    }
}

