/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.services.t0010;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.sapphire.MasterVersionCompatibilityService;
import org.eclipse.sapphire.Version;
import org.eclipse.sapphire.VersionCompatibilityService;
import org.eclipse.sapphire.VersionCompatibilityTargetService;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.tests.SapphireTestCase;
import org.eclipse.sapphire.tests.services.t0010.ChildElement;
import org.eclipse.sapphire.tests.services.t0010.RootElement;
import org.eclipse.sapphire.tests.services.t0010.TestVersionCompatibilityService;

public final class TestServices0010
extends SapphireTestCase {
    private TestServices0010(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("TestServices0010");
        suite.addTest((Test)new TestServices0010("testVersionCompatibility"));
        suite.addTest((Test)new TestServices0010("testDynamicVersionCompatibility"));
        suite.addTest((Test)new TestServices0010("testCustomVersionCompatibilityService"));
        suite.addTest((Test)new TestServices0010("testCascadingVersionCompatibility"));
        suite.addTest((Test)new TestServices0010("testVersionCompatibilityValidationServiceForValue"));
        suite.addTest((Test)new TestServices0010("testVersionCompatibilityValidationServiceForElement"));
        suite.addTest((Test)new TestServices0010("testVersionCompatibilityValidationServiceForList"));
        suite.addTest((Test)new TestServices0010("testVersionCompatibilityEnablementServiceForValue"));
        suite.addTest((Test)new TestServices0010("testVersionCompatibilityEnablementServiceForElement"));
        suite.addTest((Test)new TestServices0010("testVersionCompatibilityEnablementServiceForElementImplied"));
        suite.addTest((Test)new TestServices0010("testVersionCompatibilityEnablementServiceForList"));
        suite.addTest((Test)new TestServices0010("testVersionCompatibilityFactsService"));
        return suite;
    }

    public void testVersionCompatibility() throws Exception {
        RootElement root = (RootElement)RootElement.TYPE.instantiate();
        VersionCompatibilityTargetService rootContextVersionService = (VersionCompatibilityTargetService)root.service(VersionCompatibilityTargetService.class);
        TestServices0010.assertNotNull((Object)rootContextVersionService);
        TestServices0010.assertNull((Object)rootContextVersionService.version());
        TestServices0010.assertVersionCompatibility(root, (ModelProperty)RootElement.PROP_VALUE_SINCE, false);
        TestServices0010.assertVersionCompatibility(root, (ModelProperty)RootElement.PROP_VALUE_SINCE_DYNAMIC, false);
        TestServices0010.assertVersionCompatibility(root, (ModelProperty)RootElement.PROP_VALUE_VERSION_COMPATIBILITY, false);
        TestServices0010.assertVersionCompatibility(root, (ModelProperty)RootElement.PROP_VALUE_VERSION_COMPATIBILITY_DYNAMIC, false);
        root.setVersion("1.0");
        TestServices0010.assertEquals((Object)new Version("1.0"), (Object)rootContextVersionService.version());
        TestServices0010.assertVersionCompatibility(root, (ModelProperty)RootElement.PROP_VALUE_SINCE, false);
        TestServices0010.assertVersionCompatibility(root, (ModelProperty)RootElement.PROP_VALUE_SINCE_DYNAMIC, false);
        TestServices0010.assertVersionCompatibility(root, (ModelProperty)RootElement.PROP_VALUE_VERSION_COMPATIBILITY, false);
        TestServices0010.assertVersionCompatibility(root, (ModelProperty)RootElement.PROP_VALUE_VERSION_COMPATIBILITY_DYNAMIC, false);
        root.setVersion("1.2");
        TestServices0010.assertEquals((Object)new Version("1.2"), (Object)rootContextVersionService.version());
        TestServices0010.assertVersionCompatibility(root, (ModelProperty)RootElement.PROP_VALUE_SINCE, true);
        TestServices0010.assertVersionCompatibility(root, (ModelProperty)RootElement.PROP_VALUE_SINCE_DYNAMIC, true);
        TestServices0010.assertVersionCompatibility(root, (ModelProperty)RootElement.PROP_VALUE_VERSION_COMPATIBILITY, false);
        TestServices0010.assertVersionCompatibility(root, (ModelProperty)RootElement.PROP_VALUE_VERSION_COMPATIBILITY_DYNAMIC, false);
        root.setVersion("1.2.3");
        TestServices0010.assertEquals((Object)new Version("1.2.3"), (Object)rootContextVersionService.version());
        TestServices0010.assertVersionCompatibility(root, (ModelProperty)RootElement.PROP_VALUE_SINCE, true);
        TestServices0010.assertVersionCompatibility(root, (ModelProperty)RootElement.PROP_VALUE_SINCE_DYNAMIC, true);
        TestServices0010.assertVersionCompatibility(root, (ModelProperty)RootElement.PROP_VALUE_VERSION_COMPATIBILITY, true);
        TestServices0010.assertVersionCompatibility(root, (ModelProperty)RootElement.PROP_VALUE_VERSION_COMPATIBILITY_DYNAMIC, true);
    }

    public void testDynamicVersionCompatibility() throws Exception {
        RootElement root = (RootElement)RootElement.TYPE.instantiate();
        VersionCompatibilityTargetService rootContextVersionService = (VersionCompatibilityTargetService)root.service(VersionCompatibilityTargetService.class);
        TestServices0010.assertNotNull((Object)rootContextVersionService);
        TestServices0010.assertNull((Object)rootContextVersionService.version());
        root.setVersion("1.2.5");
        TestServices0010.assertEquals((Object)new Version("1.2.5"), (Object)rootContextVersionService.version());
        TestServices0010.assertVersionCompatibility(root, (ModelProperty)RootElement.PROP_VALUE_SINCE_DYNAMIC, true);
        TestServices0010.assertVersionCompatibility(root, (ModelProperty)RootElement.PROP_VALUE_VERSION_COMPATIBILITY_DYNAMIC, true);
        root.setSwitch(true);
        TestServices0010.assertVersionCompatibility(root, (ModelProperty)RootElement.PROP_VALUE_SINCE_DYNAMIC, false);
        TestServices0010.assertVersionCompatibility(root, (ModelProperty)RootElement.PROP_VALUE_VERSION_COMPATIBILITY_DYNAMIC, false);
    }

    public void testCustomVersionCompatibilityService() throws Exception {
        RootElement root = (RootElement)RootElement.TYPE.instantiate();
        VersionCompatibilityTargetService rootContextVersionService = (VersionCompatibilityTargetService)root.service(VersionCompatibilityTargetService.class);
        TestServices0010.assertNotNull((Object)rootContextVersionService);
        TestServices0010.assertNull((Object)rootContextVersionService.version());
        TestVersionCompatibilityService service = (TestVersionCompatibilityService)root.service((ModelProperty)RootElement.PROP_VALUE_VERSION_COMPATIBILITY_SERVICE, VersionCompatibilityService.class);
        TestServices0010.assertNotNull((Object)((Object)service));
        root.setVersion("2.0");
        TestServices0010.assertEquals((Object)new Version("2.0"), (Object)rootContextVersionService.version());
        TestServices0010.assertVersionCompatibility(root, (ModelProperty)RootElement.PROP_VALUE_VERSION_COMPATIBILITY_SERVICE, true);
        service.update("3.0");
        TestServices0010.assertVersionCompatibility(root, (ModelProperty)RootElement.PROP_VALUE_VERSION_COMPATIBILITY_SERVICE, false);
        service.update("1.0");
        TestServices0010.assertVersionCompatibility(root, (ModelProperty)RootElement.PROP_VALUE_VERSION_COMPATIBILITY_SERVICE, true);
    }

    public void testCascadingVersionCompatibility() throws Exception {
        RootElement root = (RootElement)RootElement.TYPE.instantiate();
        ChildElement elementPropertyChild = (ChildElement)root.getChild().element(true);
        ChildElement impliedElementPropertyChild = root.getChildImplied();
        ChildElement listElementChild1 = (ChildElement)root.getChildren().insert();
        ChildElement listElementChild2 = (ChildElement)root.getChildren().insert();
        root.setVersion("1.0");
        TestServices0010.assertVersionCompatibility(root, (ModelProperty)RootElement.PROP_CHILD, false);
        TestServices0010.assertVersionCompatibility(elementPropertyChild, (ModelProperty)ChildElement.PROP_VALUE_UNCONSTRAINED, false);
        TestServices0010.assertVersionCompatibility(elementPropertyChild, (ModelProperty)ChildElement.PROP_VALUE_SINCE, false);
        TestServices0010.assertVersionCompatibility(root, (ModelProperty)RootElement.PROP_CHILD_IMPLIED, false);
        TestServices0010.assertVersionCompatibility(impliedElementPropertyChild, (ModelProperty)ChildElement.PROP_VALUE_UNCONSTRAINED, false);
        TestServices0010.assertVersionCompatibility(impliedElementPropertyChild, (ModelProperty)ChildElement.PROP_VALUE_SINCE, false);
        TestServices0010.assertVersionCompatibility(root, (ModelProperty)RootElement.PROP_CHILDREN, false);
        TestServices0010.assertVersionCompatibility(listElementChild1, (ModelProperty)ChildElement.PROP_VALUE_UNCONSTRAINED, false);
        TestServices0010.assertVersionCompatibility(listElementChild1, (ModelProperty)ChildElement.PROP_VALUE_SINCE, false);
        TestServices0010.assertVersionCompatibility(listElementChild2, (ModelProperty)ChildElement.PROP_VALUE_UNCONSTRAINED, false);
        TestServices0010.assertVersionCompatibility(listElementChild2, (ModelProperty)ChildElement.PROP_VALUE_SINCE, false);
        root.setVersion("2.0");
        TestServices0010.assertVersionCompatibility(root, (ModelProperty)RootElement.PROP_CHILD, true);
        TestServices0010.assertVersionCompatibility(elementPropertyChild, (ModelProperty)ChildElement.PROP_VALUE_UNCONSTRAINED, true);
        TestServices0010.assertVersionCompatibility(elementPropertyChild, (ModelProperty)ChildElement.PROP_VALUE_SINCE, false);
        TestServices0010.assertVersionCompatibility(root, (ModelProperty)RootElement.PROP_CHILD_IMPLIED, true);
        TestServices0010.assertVersionCompatibility(impliedElementPropertyChild, (ModelProperty)ChildElement.PROP_VALUE_UNCONSTRAINED, true);
        TestServices0010.assertVersionCompatibility(impliedElementPropertyChild, (ModelProperty)ChildElement.PROP_VALUE_SINCE, false);
        TestServices0010.assertVersionCompatibility(root, (ModelProperty)RootElement.PROP_CHILDREN, true);
        TestServices0010.assertVersionCompatibility(listElementChild1, (ModelProperty)ChildElement.PROP_VALUE_UNCONSTRAINED, true);
        TestServices0010.assertVersionCompatibility(listElementChild1, (ModelProperty)ChildElement.PROP_VALUE_SINCE, false);
        TestServices0010.assertVersionCompatibility(listElementChild2, (ModelProperty)ChildElement.PROP_VALUE_UNCONSTRAINED, true);
        TestServices0010.assertVersionCompatibility(listElementChild2, (ModelProperty)ChildElement.PROP_VALUE_SINCE, false);
        ChildElement listElementChild3 = (ChildElement)root.getChildren().insert();
        TestServices0010.assertVersionCompatibility(listElementChild3, (ModelProperty)ChildElement.PROP_VALUE_UNCONSTRAINED, true);
        TestServices0010.assertVersionCompatibility(listElementChild3, (ModelProperty)ChildElement.PROP_VALUE_SINCE, false);
        root.setVersion("3.0");
        TestServices0010.assertVersionCompatibility(root, (ModelProperty)RootElement.PROP_CHILD, true);
        TestServices0010.assertVersionCompatibility(elementPropertyChild, (ModelProperty)ChildElement.PROP_VALUE_UNCONSTRAINED, true);
        TestServices0010.assertVersionCompatibility(elementPropertyChild, (ModelProperty)ChildElement.PROP_VALUE_SINCE, true);
        TestServices0010.assertVersionCompatibility(root, (ModelProperty)RootElement.PROP_CHILD_IMPLIED, true);
        TestServices0010.assertVersionCompatibility(impliedElementPropertyChild, (ModelProperty)ChildElement.PROP_VALUE_UNCONSTRAINED, true);
        TestServices0010.assertVersionCompatibility(impliedElementPropertyChild, (ModelProperty)ChildElement.PROP_VALUE_SINCE, true);
        TestServices0010.assertVersionCompatibility(root, (ModelProperty)RootElement.PROP_CHILDREN, true);
        TestServices0010.assertVersionCompatibility(listElementChild1, (ModelProperty)ChildElement.PROP_VALUE_UNCONSTRAINED, true);
        TestServices0010.assertVersionCompatibility(listElementChild1, (ModelProperty)ChildElement.PROP_VALUE_SINCE, true);
        TestServices0010.assertVersionCompatibility(listElementChild2, (ModelProperty)ChildElement.PROP_VALUE_UNCONSTRAINED, true);
        TestServices0010.assertVersionCompatibility(listElementChild2, (ModelProperty)ChildElement.PROP_VALUE_SINCE, true);
        TestServices0010.assertVersionCompatibility(listElementChild3, (ModelProperty)ChildElement.PROP_VALUE_UNCONSTRAINED, true);
        TestServices0010.assertVersionCompatibility(listElementChild3, (ModelProperty)ChildElement.PROP_VALUE_SINCE, true);
        ChildElement listElementChild4 = (ChildElement)root.getChildren().insert();
        TestServices0010.assertVersionCompatibility(listElementChild4, (ModelProperty)ChildElement.PROP_VALUE_UNCONSTRAINED, true);
        TestServices0010.assertVersionCompatibility(listElementChild4, (ModelProperty)ChildElement.PROP_VALUE_SINCE, true);
    }

    public void testVersionCompatibilityValidationServiceForValue() throws Exception {
        RootElement root = (RootElement)RootElement.TYPE.instantiate();
        TestServices0010.assertValidationOk(root.getValueSince());
        root.setValueSince("abc");
        TestServices0010.assertValidationError(root.getValueSince(), "Version constraint exists, but no version constraint target was found.");
        root.setValueSince(null);
        root.setVersion("1.0");
        TestServices0010.assertValidationOk(root.getValueSince());
        root.setValueSince("abc");
        TestServices0010.assertValidationError(root.getValueSince(), "Not compatible with version 1 of Test Versioned System.");
        root.setValueSince(null);
        TestServices0010.assertValidationOk(root.getValueSince());
    }

    public void testVersionCompatibilityValidationServiceForElement() throws Exception {
        RootElement root = (RootElement)RootElement.TYPE.instantiate();
        TestServices0010.assertValidationOk(root.getChild());
        root.getChild().element(true);
        TestServices0010.assertValidationError(root.getChild(), "Version constraint exists, but no version constraint target was found.");
        root.getChild().remove();
        root.setVersion("1.0");
        TestServices0010.assertValidationOk(root.getChild());
        root.getChild().element(true);
        TestServices0010.assertValidationError(root.getChild(), "Not compatible with version 1 of Test Versioned System.");
        root.getChild().remove();
        TestServices0010.assertValidationOk(root.getChild());
    }

    public void testVersionCompatibilityValidationServiceForList() throws Exception {
        RootElement root = (RootElement)RootElement.TYPE.instantiate();
        TestServices0010.assertValidationOk(root.getChildren());
        root.getChildren().insert();
        TestServices0010.assertValidationError(root.getChildren(), "Version constraint exists, but no version constraint target was found.");
        root.getChildren().remove(0);
        root.setVersion("1.0");
        TestServices0010.assertValidationOk(root.getChildren());
        root.getChildren().insert();
        TestServices0010.assertValidationError(root.getChildren(), "Not compatible with version 1 of Test Versioned System.");
        root.getChildren().remove(0);
        TestServices0010.assertValidationOk(root.getChildren());
    }

    public void testVersionCompatibilityEnablementServiceForValue() throws Exception {
        RootElement root = (RootElement)RootElement.TYPE.instantiate();
        TestServices0010.assertFalse((boolean)root.enabled((ModelProperty)RootElement.PROP_VALUE_SINCE));
        root.setVersion("1.0");
        TestServices0010.assertFalse((boolean)root.enabled((ModelProperty)RootElement.PROP_VALUE_SINCE));
        root.setVersion("3.0");
        TestServices0010.assertTrue((boolean)root.enabled((ModelProperty)RootElement.PROP_VALUE_SINCE));
        root.setVersion("1.0");
        TestServices0010.assertFalse((boolean)root.enabled((ModelProperty)RootElement.PROP_VALUE_SINCE));
    }

    public void testVersionCompatibilityEnablementServiceForElement() throws Exception {
        RootElement root = (RootElement)RootElement.TYPE.instantiate();
        TestServices0010.assertFalse((boolean)root.enabled((ModelProperty)RootElement.PROP_CHILD));
        root.setVersion("1.0");
        TestServices0010.assertFalse((boolean)root.enabled((ModelProperty)RootElement.PROP_CHILD));
        root.setVersion("3.0");
        TestServices0010.assertTrue((boolean)root.enabled((ModelProperty)RootElement.PROP_CHILD));
        root.setVersion("1.0");
        TestServices0010.assertFalse((boolean)root.enabled((ModelProperty)RootElement.PROP_CHILD));
    }

    public void testVersionCompatibilityEnablementServiceForElementImplied() throws Exception {
        RootElement root = (RootElement)RootElement.TYPE.instantiate();
        TestServices0010.assertFalse((boolean)root.enabled((ModelProperty)RootElement.PROP_CHILD_IMPLIED));
        root.setVersion("1.0");
        TestServices0010.assertFalse((boolean)root.enabled((ModelProperty)RootElement.PROP_CHILD_IMPLIED));
        root.setVersion("3.0");
        TestServices0010.assertTrue((boolean)root.enabled((ModelProperty)RootElement.PROP_CHILD_IMPLIED));
        root.setVersion("1.0");
        TestServices0010.assertFalse((boolean)root.enabled((ModelProperty)RootElement.PROP_CHILD_IMPLIED));
    }

    public void testVersionCompatibilityEnablementServiceForList() throws Exception {
        RootElement root = (RootElement)RootElement.TYPE.instantiate();
        TestServices0010.assertFalse((boolean)root.enabled((ModelProperty)RootElement.PROP_CHILDREN));
        root.setVersion("1.0");
        TestServices0010.assertFalse((boolean)root.enabled((ModelProperty)RootElement.PROP_CHILDREN));
        root.setVersion("3.0");
        TestServices0010.assertTrue((boolean)root.enabled((ModelProperty)RootElement.PROP_CHILDREN));
        root.setVersion("1.0");
        TestServices0010.assertFalse((boolean)root.enabled((ModelProperty)RootElement.PROP_CHILDREN));
    }

    public void testVersionCompatibilityFactsService() throws Exception {
        RootElement root = (RootElement)RootElement.TYPE.instantiate();
        root.setVersion("1.0");
        TestServices0010.assertFact(root, (ModelProperty)RootElement.PROP_VALUE_SINCE, "Since Test Versioned System 1.2");
        TestServices0010.assertFact(root, (ModelProperty)RootElement.PROP_VALUE_SINCE_DYNAMIC, "Since Test Versioned System 1.2");
        TestServices0010.assertFact(root, (ModelProperty)RootElement.PROP_VALUE_VERSION_COMPATIBILITY, "For Test Versioned System [1.2.3-1.3)");
        TestServices0010.assertFact(root, (ModelProperty)RootElement.PROP_VALUE_VERSION_COMPATIBILITY_DYNAMIC, "For Test Versioned System [1.2.3-1.3)");
        root.setSwitch(true);
        TestServices0010.assertFact(root, (ModelProperty)RootElement.PROP_VALUE_SINCE, "Since Test Versioned System 1.2");
        TestServices0010.assertFact(root, (ModelProperty)RootElement.PROP_VALUE_SINCE_DYNAMIC, "Since Test Versioned System 2");
        TestServices0010.assertFact(root, (ModelProperty)RootElement.PROP_VALUE_VERSION_COMPATIBILITY, "For Test Versioned System [1.2.3-1.3)");
        TestServices0010.assertFact(root, (ModelProperty)RootElement.PROP_VALUE_VERSION_COMPATIBILITY_DYNAMIC, "Since Test Versioned System 2");
        ChildElement child = root.getChildImplied();
        TestServices0010.assertFact(child, (ModelProperty)ChildElement.PROP_VALUE_UNCONSTRAINED, "Since Test Versioned System 2");
        TestServices0010.assertFact(child, (ModelProperty)ChildElement.PROP_VALUE_SINCE, "Since Test Versioned System 3");
    }

    private static void assertVersionCompatibility(IModelElement element, ModelProperty property, boolean expectedVersionCompatibility) {
        MasterVersionCompatibilityService service = (MasterVersionCompatibilityService)element.service(property, MasterVersionCompatibilityService.class);
        TestServices0010.assertNotNull((Object)service);
        TestServices0010.assertEquals((boolean)expectedVersionCompatibility, (boolean)service.compatible());
    }
}

