/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.workspace;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.sapphire.tests.SapphireTestCase;

public abstract class TestWorkspace
extends SapphireTestCase {
    protected TestWorkspace(String name) {
        super(name);
    }

    protected final IProject createProject(String name) throws Exception {
        String n = String.valueOf(((Object)((Object)this)).getClass().getName()) + "." + this.getName();
        if (name != null) {
            n = String.valueOf(n) + "." + name;
        }
        IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(n);
        p.create(null);
        p.open(null);
        return p;
    }

    protected final IFolder createFolder(IProject project, String path) throws Exception {
        IFolder folder = project.getFolder(path);
        this.createFolder(folder);
        return folder;
    }

    protected final void createFolder(IFolder folder) throws Exception {
        if (!folder.exists()) {
            IContainer parent = folder.getParent();
            if (parent instanceof IFolder) {
                this.createFolder((IFolder)parent);
            }
            folder.create(true, true, null);
        }
    }

    protected final IFile createFile(IProject project, String path, InputStream content) throws Exception {
        IFile file = project.getFile(path);
        IContainer parent = file.getParent();
        if (parent instanceof IFolder) {
            this.createFolder((IFolder)parent);
        }
        file.create(content, true, null);
        return file;
    }

    protected final IFile createFile(IProject project, String path, byte[] content) throws Exception {
        return this.createFile(project, path, new ByteArrayInputStream(content));
    }

    protected final IFile createFile(IProject project, String path) throws Exception {
        return this.createFile(project, path, new byte[0]);
    }

    protected final void deleteProject(String name) throws Exception {
        IProject p;
        String n = String.valueOf(((Object)((Object)this)).getClass().getName()) + "." + this.getName();
        if (name != null) {
            n = String.valueOf(n) + "." + name;
        }
        if ((p = ResourcesPlugin.getWorkspace().getRoot().getProject(n)).exists()) {
            p.delete(true, null);
        }
    }
}

