/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.util.Collections;
import java.util.Set;
import org.eclipse.help.IContext;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.ui.CompositePart;
import org.eclipse.sapphire.ui.SapphireActionGroup;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.ISapphireDocumentation;
import org.eclipse.sapphire.ui.def.ISapphireDocumentationDef;
import org.eclipse.sapphire.ui.def.ISapphireDocumentationRef;
import org.eclipse.sapphire.ui.def.SectionDef;
import org.eclipse.sapphire.ui.swt.renderer.GridLayoutUtil;
import org.eclipse.sapphire.ui.swt.renderer.SapphireActionPresentationManager;
import org.eclipse.sapphire.ui.swt.renderer.SapphireKeyboardActionPresentation;
import org.eclipse.sapphire.ui.swt.renderer.SapphireToolBarActionPresentation;
import org.eclipse.sapphire.ui.swt.renderer.SwtUtil;
import org.eclipse.sapphire.ui.swt.renderer.internal.formtext.SapphireFormText;
import org.eclipse.sapphire.ui.util.SapphireHelpSystem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SectionPart
extends CompositePart {
    private FunctionResult titleFunctionResult;
    private FunctionResult descriptionFunctionResult;
    private SapphireRenderingContext context;
    private Section section;
    private SapphireFormText descriptionFormText;
    private Composite descriptionSpacer;
    private Composite sectionContentOuterComposite;
    private Composite sectionContentInnerComposite;
    private boolean expanded;

    @Override
    protected void init() {
        super.init();
        SectionDef def = this.definition();
        this.expanded = (Boolean)def.getCollapsedInitially().getContent() == false;
    }

    @Override
    public SectionDef definition() {
        return (SectionDef)super.definition();
    }

    @Override
    protected Composite createOuterComposite(SapphireRenderingContext context) {
        this.context = context;
        this.section = null;
        this.descriptionFormText = null;
        this.descriptionSpacer = null;
        this.sectionContentOuterComposite = null;
        this.sectionContentInnerComposite = null;
        FormToolkit toolkit = new FormToolkit(context.getDisplay());
        SectionDef def = this.definition();
        Composite outerComposite = new Composite(context.getComposite(), 0);
        outerComposite.setLayoutData(this.createSectionLayoutData());
        outerComposite.setLayout((Layout)GridLayoutUtil.glayout(1, 10, 10, 10, 20));
        context.adapt((Control)outerComposite);
        boolean collapsible = (Boolean)def.getCollapsible().getContent();
        int style = 0x100 | (collapsible ? 2 : 0);
        this.section = toolkit.createSection(outerComposite, style);
        this.section.setLayoutData((Object)GridLayoutUtil.gdfill());
        if (collapsible) {
            this.section.setExpanded(this.expanded);
            this.section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanged(ExpansionEvent event) {
                    SectionPart.this.expanded = event.getState();
                }
            });
        }
        this.titleFunctionResult = this.initExpression(this.getModelElement(), (Function)def.getLabel().getContent(), String.class, null, new Runnable(){

            public void run() {
                SectionPart.this.refreshTitle();
            }
        });
        this.refreshTitle();
        this.sectionContentOuterComposite = new Composite((Composite)this.section, 0);
        this.sectionContentOuterComposite.setLayout((Layout)GridLayoutUtil.glayout(1, 0, 0));
        context.adapt((Control)this.sectionContentOuterComposite);
        this.descriptionFunctionResult = this.initExpression(this.getModelElement(), (Function)def.getDescription().getContent(), String.class, null, new Runnable(){

            public void run() {
                SectionPart.this.refreshDescription();
            }
        });
        this.refreshDescription();
        this.sectionContentInnerComposite = new Composite(this.sectionContentOuterComposite, 0);
        this.sectionContentInnerComposite.setLayoutData((Object)GridLayoutUtil.gdfill());
        this.sectionContentInnerComposite.setLayout((Layout)GridLayoutUtil.glayout(2, 0, 0));
        context.adapt((Control)this.sectionContentInnerComposite);
        SapphireActionGroup actions = this.getActions();
        SapphireActionPresentationManager actionPresentationManager = new SapphireActionPresentationManager(context, actions);
        SapphireToolBarActionPresentation toolBarActionsPresentation = new SapphireToolBarActionPresentation(actionPresentationManager);
        ToolBar toolbar = new ToolBar((Composite)this.section, 8519936);
        toolBarActionsPresentation.setToolBar(toolbar);
        toolBarActionsPresentation.render();
        this.section.setTextClient((Control)toolbar);
        SapphireKeyboardActionPresentation keyboardActionsPresentation = new SapphireKeyboardActionPresentation(actionPresentationManager);
        keyboardActionsPresentation.attach((Control)toolbar);
        keyboardActionsPresentation.render();
        toolkit.paintBordersFor((Composite)this.section);
        this.section.setClient((Control)this.sectionContentOuterComposite);
        return this.sectionContentInnerComposite;
    }

    protected Object createSectionLayoutData() {
        return GridLayoutUtil.gdhspan(this.getScaleVertically() ? GridLayoutUtil.gdfill() : GridLayoutUtil.gdhfill(), 2);
    }

    private void refreshTitle() {
        String title = (String)this.titleFunctionResult.value();
        if (title == null) {
            title = "#null#";
        } else {
            title = title.trim();
            title = ((LocalizationService)this.definition.adapt(LocalizationService.class)).transform(title, CapitalizationType.TITLE_STYLE, false);
        }
        this.section.setText(title.trim());
    }

    private void refreshDescription() {
        String description = (String)this.descriptionFunctionResult.value();
        if (description != null && (description = description.trim()).length() == 0) {
            description = null;
        }
        if (description == null) {
            if (this.descriptionFormText != null) {
                this.descriptionFormText.dispose();
                this.descriptionFormText = null;
                this.descriptionSpacer.dispose();
                this.descriptionSpacer = null;
            }
        } else {
            if (this.descriptionFormText == null) {
                this.descriptionFormText = new SapphireFormText(this.sectionContentOuterComposite, 0);
                this.descriptionFormText.setLayoutData(GridLayoutUtil.gdhindent(GridLayoutUtil.gdwhint(GridLayoutUtil.gdhfill(), 100), 9));
                SwtUtil.reflowOnResize((Control)this.descriptionFormText);
                this.descriptionSpacer = new Composite(this.sectionContentOuterComposite, 0);
                this.descriptionSpacer.setLayoutData((Object)GridLayoutUtil.gdhhint(GridLayoutUtil.gdhfill(), 5));
                this.descriptionSpacer.setLayout((Layout)GridLayoutUtil.glayout(1, 0, 0, 0, 0));
                this.context.adapt((Control)this.descriptionSpacer);
                if (this.sectionContentInnerComposite != null) {
                    this.descriptionFormText.moveAbove((Control)this.sectionContentInnerComposite);
                    this.descriptionSpacer.moveAbove((Control)this.sectionContentInnerComposite);
                }
            }
            description = description.replace("<", "&lt;");
            StringBuilder buf = new StringBuilder();
            buf.append("<form><p vspace=\"false\">");
            buf.append(description);
            buf.append("</p></form>");
            this.descriptionFormText.setText(buf.toString(), true, false);
        }
        this.sectionContentOuterComposite.layout();
    }

    @Override
    public Set<String> getActionContexts() {
        return Collections.singleton("Sapphire.Section");
    }

    @Override
    public IContext getDocumentationContext() {
        ISapphireDocumentation doc = (ISapphireDocumentation)this.definition.getDocumentation().element();
        if (doc != null) {
            ISapphireDocumentationDef docdef = null;
            docdef = doc instanceof ISapphireDocumentationDef ? (ISapphireDocumentationDef)doc : ((ISapphireDocumentationRef)doc).resolve();
            if (docdef != null) {
                return SapphireHelpSystem.getContext(docdef);
            }
        }
        return null;
    }
}

