/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.form.editors.masterdetails.internal;

import java.util.Collections;
import java.util.List;
import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelElementHandle;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.form.editors.masterdetails.MasterDetailsContentNode;
import org.eclipse.sapphire.ui.form.editors.masterdetails.MasterDetailsEditorPagePart;
import org.eclipse.sapphire.ui.util.MiscUtil;

public final class OutlineNodeDeleteActionHandler
extends SapphireActionHandler {
    public static final String ID = "Sapphire.Outline.Delete";

    public OutlineNodeDeleteActionHandler() {
        this.setId(ID);
    }

    protected Object run(SapphireRenderingContext context) {
        List<MasterDetailsContentNode> nodesToDelete;
        ISapphirePart part = this.getPart();
        if (part instanceof MasterDetailsContentNode) {
            nodesToDelete = Collections.singletonList((MasterDetailsContentNode)part);
        } else if (part instanceof MasterDetailsEditorPagePart) {
            nodesToDelete = ((MasterDetailsEditorPagePart)part).outline().getSelectedNodes();
        } else {
            throw new IllegalStateException();
        }
        MasterDetailsContentNode parent = nodesToDelete.get(0).getParentNode();
        List<MasterDetailsContentNode> allSiblingNodes = parent.nodes().visible();
        MasterDetailsContentNode selectionPostDelete = MiscUtil.findSelectionPostDelete(allSiblingNodes, nodesToDelete);
        if (selectionPostDelete == null) {
            selectionPostDelete = parent;
        }
        for (MasterDetailsContentNode node : nodesToDelete) {
            IModelElement element = node.getModelElement();
            IModelParticle elementParent = element.parent();
            if (elementParent instanceof ModelElementList) {
                ((ModelElementList)elementParent).remove((Object)element);
                continue;
            }
            ElementProperty property = (ElementProperty)element.getParentProperty();
            ModelElementHandle handle = ((IModelElement)elementParent).read(property);
            if (handle.element() != element) continue;
            handle.remove();
        }
        if (selectionPostDelete != null) {
            selectionPostDelete.getContentTree().setSelectedNode(selectionPostDelete);
        }
        return null;
    }
}

