/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.form.editors.masterdetails.internal;

import java.util.List;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.SapphireCondition;
import org.eclipse.sapphire.ui.form.editors.masterdetails.MasterDetailsContentNode;
import org.eclipse.sapphire.ui.form.editors.masterdetails.MasterDetailsEditorPagePart;

public class OutlineNodeListMemberActionHandlerCondition
extends SapphireCondition {
    protected boolean evaluate() {
        MasterDetailsEditorPagePart page;
        List<MasterDetailsContentNode> nodes;
        ISapphirePart part = this.getPart();
        if (part instanceof MasterDetailsContentNode) {
            return this.check((MasterDetailsContentNode)part);
        }
        if (part instanceof MasterDetailsEditorPagePart && !(nodes = (page = (MasterDetailsEditorPagePart)part).outline().getSelectedNodes()).isEmpty()) {
            MasterDetailsContentNode parent = null;
            for (MasterDetailsContentNode node : page.outline().getSelectedNodes()) {
                if (parent == null) {
                    parent = node.getParentNode();
                    continue;
                }
                if (parent == node.getParentNode()) continue;
                return false;
            }
            for (MasterDetailsContentNode node : page.outline().getSelectedNodes()) {
                if (this.check(node)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean check(MasterDetailsContentNode node) {
        IModelElement element = node.getModelElement();
        if (element.parent() instanceof ModelElementList && !element.getParentProperty().isReadOnly()) {
            ISapphirePart parentPart = node.getParentPart();
            if (parentPart != null && parentPart instanceof MasterDetailsContentNode) {
                MasterDetailsContentNode parentNode = (MasterDetailsContentNode)parentPart;
                return element != parentNode.getLocalModelElement();
            }
            return true;
        }
        return false;
    }
}

