/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.form.editors.masterdetails.internal;

import java.util.List;
import org.eclipse.sapphire.DisposeEvent;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.ui.FormPart;
import org.eclipse.sapphire.ui.PageBookPart;
import org.eclipse.sapphire.ui.PropertyEditorPart;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.SectionPart;
import org.eclipse.sapphire.ui.def.ActionHandlerDef;
import org.eclipse.sapphire.ui.form.editors.masterdetails.MasterDetailsContentNode;
import org.eclipse.sapphire.ui.form.editors.masterdetails.MasterDetailsEditorPagePart;
import org.eclipse.sapphire.ui.form.editors.masterdetails.ProblemsTraversalService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OutlineNodeShowNextProblemActionHandler
extends SapphireActionHandler {
    private final Status.Severity severity;
    private ProblemsTraversalService service;

    protected OutlineNodeShowNextProblemActionHandler(Status.Severity severity) {
        if (severity != Status.Severity.ERROR && severity != Status.Severity.WARNING) {
            throw new IllegalArgumentException();
        }
        this.severity = severity;
    }

    @Override
    public void init(SapphireAction action, ActionHandlerDef def) {
        super.init(action, def);
        MasterDetailsContentNode node = (MasterDetailsContentNode)this.getPart();
        MasterDetailsEditorPagePart page = node.nearest(MasterDetailsEditorPagePart.class);
        this.service = page.service(ProblemsTraversalService.class);
        final Listener listener = new Listener(){

            public void handle(Event event) {
                OutlineNodeShowNextProblemActionHandler.this.refreshVisibility();
            }
        };
        this.service.attach(listener);
        this.attach((Listener)new FilteredListener<DisposeEvent>(){

            protected void handleTypedEvent(DisposeEvent event) {
                OutlineNodeShowNextProblemActionHandler.this.service.detach(listener);
            }
        });
        this.refreshVisibility();
    }

    private void refreshVisibility() {
        MasterDetailsContentNode node = (MasterDetailsContentNode)this.getPart();
        MasterDetailsContentNode nextProblemNode = this.service.findNextProblem(node, this.severity);
        this.setVisible(nextProblemNode != null);
    }

    private PropertyEditorPart findFirstProblem(List<SectionPart> sections) {
        for (SectionPart section : sections) {
            PropertyEditorPart res = this.findFirstProblem(section);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    private PropertyEditorPart findFirstProblem(SapphirePart part) {
        if (part != null) {
            if (part instanceof PropertyEditorPart) {
                if (part.validation().severity() == this.severity) {
                    return (PropertyEditorPart)part;
                }
            } else if (part instanceof FormPart) {
                for (SapphirePart sapphirePart : ((FormPart)part).getChildParts()) {
                    PropertyEditorPart result = this.findFirstProblem(sapphirePart);
                    if (result == null) continue;
                    return result;
                }
            } else if (part instanceof PageBookPart) {
                return this.findFirstProblem(((PageBookPart)part).getCurrentPage());
            }
        }
        return null;
    }

    @Override
    protected Object run(SapphireRenderingContext context) {
        MasterDetailsContentNode node = (MasterDetailsContentNode)this.getPart();
        MasterDetailsContentNode nextProblemNode = this.service.findNextProblem(node, this.severity);
        if (nextProblemNode != null) {
            nextProblemNode.select();
            PropertyEditorPart firstProblemPropertyEditor = this.findFirstProblem(nextProblemNode.getSections());
            if (firstProblemPropertyEditor != null) {
                firstProblemPropertyEditor.setFocus();
            }
        }
        return null;
    }
}

