/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.workspace;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.ValidateEditException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceFileResourceStore
extends ByteArrayResourceStore {
    private final IFile file;
    private long modStamp;

    public WorkspaceFileResourceStore(IFile file) throws ResourceStoreException {
        this.file = file;
        this.modStamp = -1L;
        if (this.file.exists()) {
            InputStream in = null;
            try {
                try {
                    this.modStamp = this.file.getModificationStamp();
                    in = this.file.getContents();
                    this.setContents(in);
                }
                catch (CoreException e) {
                    throw new ResourceStoreException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public IFile getWorkspaceFile() {
        return this.file;
    }

    public File getFile() {
        return this.file.getLocation().toFile();
    }

    public void save() throws ResourceStoreException {
        this.validateSave();
        try {
            byte[] content = this.getContents();
            ByteArrayInputStream stream = new ByteArrayInputStream(content);
            if (this.file.exists()) {
                this.file.setContents((InputStream)stream, true, false, null);
            } else if (content.length > 0) {
                WorkspaceFileResourceStore.create(this.file.getParent());
                this.file.create((InputStream)stream, true, null);
            }
            this.modStamp = this.file.getModificationStamp();
        }
        catch (CoreException e) {
            throw new ResourceStoreException((Throwable)e);
        }
    }

    public void validateSave() {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        if (!ws.validateEdit(new IFile[]{this.file}, IWorkspace.VALIDATE_PROMPT).isOK()) {
            throw new ValidateEditException();
        }
    }

    public boolean isOutOfDate() {
        return this.modStamp != this.file.getModificationStamp();
    }

    public boolean equals(Object obj) {
        if (obj instanceof WorkspaceFileResourceStore) {
            return this.file.getLocation().equals((Object)((WorkspaceFileResourceStore)((Object)obj)).getWorkspaceFile().getLocation());
        }
        return false;
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public <A> A adapt(Class<A> adapterType) {
        Object result = null;
        result = adapterType == File.class ? (Object)adapterType.cast(this.file.getLocation().toFile()) : (adapterType == IFile.class ? (Object)adapterType.cast(this.file) : (adapterType == IProject.class ? adapterType.cast(this.file.getProject()) : super.adapt(adapterType)));
        return (A)result;
    }

    public static void create(IContainer container) throws CoreException {
        if (!container.exists()) {
            WorkspaceFileResourceStore.create(container.getParent());
            IFolder iFolder = (IFolder)container;
            iFolder.create(true, true, null);
        }
    }
}

