/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.xml;

import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlNode;
import org.eclipse.sapphire.modeling.xml.XmlValueBindingImpl;

public final class FoldingXmlValueBindingImpl
extends XmlValueBindingImpl {
    private String elementName;
    private XmlNode.Listener listener;

    public void init(IModelElement element, ModelProperty property, String[] params) {
        super.init(element, property, params);
        final XmlElement root = this.xml();
        final String finalElementName = this.elementName = params[0];
        this.listener = new XmlNode.Listener(){

            public void handle(XmlNode.Event event) {
                XmlElement propElement;
                int childElementsCount;
                XmlNode.EventType type = event.getType();
                if (type == XmlNode.EventType.PRE_CHILD_ELEMENT_ADD) {
                    String propName;
                    XmlElement propElement2 = root.getChildElement(finalElementName, false);
                    if (propElement2 == null && (propName = root.getText()).length() > 0) {
                        root.setText(null);
                        propElement2 = root.getChildElement(finalElementName, true);
                        propElement2.setText(propName);
                    }
                } else if (type == XmlNode.EventType.POST_CHILD_ELEMENT_REMOVE && (childElementsCount = root.getChildElements().size()) == 1 && (propElement = root.getChildElement(finalElementName, false)) != null) {
                    String propName = propElement.getText();
                    propElement.remove();
                    if (propName.length() > 0) {
                        root.setText(propName);
                    }
                }
            }
        };
        root.addListener(this.listener);
    }

    public String read() {
        String value = null;
        XmlElement el = this.xml(false);
        if (el != null) {
            XmlElement propElement = el.getChildElement(this.elementName, false);
            value = propElement != null ? propElement.getText() : el.getText();
        }
        return value;
    }

    public void write(String value) {
        XmlElement el = this.xml(true);
        boolean foundChildContent = false;
        for (XmlElement child : el.getChildElements()) {
            if (child.getLocalName().equals(this.elementName)) continue;
            foundChildContent = true;
            break;
        }
        if (foundChildContent) {
            el.setChildNodeText(this.elementName, value, true);
        } else {
            el.setText(value);
        }
    }

    public void dispose() {
        super.dispose();
        this.xml().removeListener(this.listener);
    }
}

