/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.xml;

import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.PropertyContentEvent;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlPath;
import org.eclipse.sapphire.modeling.xml.XmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class VirtualChildXmlResource
extends XmlResource {
    private final XmlPath path;
    private Node lastDomNode;

    public VirtualChildXmlResource(XmlResource parent, XmlPath path) {
        super(parent);
        this.path = path;
    }

    public void init(IModelElement element) {
        super.init(element);
        element.attach((Listener)new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                VirtualChildXmlResource.this.removeIfEmpty();
            }
        });
    }

    public XmlElement getXmlElement(boolean createIfNecessary) {
        XmlElement parent = this.parent().getXmlElement(createIfNecessary);
        XmlElement element = null;
        if (parent != null) {
            element = (XmlElement)parent.getChildNode(this.path, createIfNecessary);
        }
        Element node = null;
        if (element != null) {
            node = element.getDomNode();
        }
        if (this.lastDomNode != node) {
            XmlResourceStore store = this.root().store();
            IModelElement modelElement = this.element();
            if (this.lastDomNode != null) {
                store.unregisterModelElement(this.lastDomNode, modelElement);
            }
            if (node != null) {
                store.registerModelElement(node, modelElement);
            }
            this.lastDomNode = node;
        }
        return element;
    }

    private void removeIfEmpty() {
        XmlElement element;
        XmlElement base = this.parent().getXmlElement(false);
        if (base != null && (element = (XmlElement)base.getChildNode(this.path, false)) != null && element != base && element.isEmpty()) {
            base.removeChildNode(this.path);
        }
    }
}

