/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.xml;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.FileResourceStore;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ResourceStore;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlResourceStore
extends ResourceStore {
    private static final String UTF8_ENCODING = "UTF-8";
    private final ByteArrayResourceStore base;
    private Document document;

    public XmlResourceStore(ByteArrayResourceStore baseModelStore) {
        this.base = baseModelStore;
        this.document = null;
        if (this.base != null) {
            block10: {
                try {
                    byte[] contents = this.base.getContents();
                    if (contents.length <= 0) break block10;
                    ByteArrayInputStream in = new ByteArrayInputStream(contents);
                    try {
                        InputStreamReader reader = new InputStreamReader((InputStream)in, UTF8_ENCODING);
                        this.document = XmlResourceStore.doc(reader);
                    }
                    catch (Throwable throwable) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException iOException) {}
                }
                catch (Exception exception) {}
            }
            if (this.document == null) {
                this.document = XmlResourceStore.doc();
            }
            this.document.setStrictErrorChecking(false);
        }
    }

    public XmlResourceStore(byte[] contents) {
        this(new ByteArrayResourceStore(contents));
    }

    public XmlResourceStore(String contents) {
        this(new ByteArrayResourceStore(contents));
    }

    public XmlResourceStore(InputStream contents) throws ResourceStoreException {
        this(new ByteArrayResourceStore(contents));
    }

    public XmlResourceStore(File file) throws ResourceStoreException {
        this((ByteArrayResourceStore)new FileResourceStore(file));
    }

    public XmlResourceStore() {
        this(new byte[0]);
    }

    public Document getDomDocument() {
        return this.document;
    }

    protected void setDomDocument(Document document) {
        this.document = document;
    }

    public boolean isXmlDeclarationNeeded() {
        return false;
    }

    public <A> A adapt(Class<A> adapterType) {
        Object adapter = null;
        if (this.base != null) {
            adapter = this.base.adapt(adapterType);
        }
        return (A)adapter;
    }

    public void save() throws ResourceStoreException {
        this.validateSave();
        try {
            if (this.document.getDocumentElement() != null) {
                StringWriter sw = new StringWriter();
                sw.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                sw.append('\n');
                DOMSource source = new DOMSource(this.document);
                StreamResult result = new StreamResult(sw);
                TransformerFactory factory = TransformerFactory.newInstance();
                Transformer transformer = factory.newTransformer();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                DocumentType doctype = this.document.getDoctype();
                if (doctype != null) {
                    if (doctype.getPublicId() != null) {
                        transformer.setOutputProperty("doctype-public", doctype.getPublicId());
                    }
                    if (doctype.getSystemId() != null) {
                        transformer.setOutputProperty("doctype-system", doctype.getSystemId());
                    }
                }
                transformer.transform(source, result);
                this.base.setContents(sw.toString().getBytes(UTF8_ENCODING));
            } else {
                this.base.setContents(new byte[0]);
            }
            this.base.save();
        }
        catch (Exception e) {
            throw new ResourceStoreException((Throwable)e);
        }
    }

    public void validateEdit() {
        this.base.validateEdit();
    }

    public void validateSave() {
        this.base.validateSave();
    }

    public boolean isOutOfDate() {
        return this.base.isOutOfDate();
    }

    public boolean equals(Object obj) {
        if (obj instanceof XmlResourceStore) {
            return this.base.equals(((XmlResourceStore)((Object)obj)).base);
        }
        return false;
    }

    public int hashCode() {
        return this.base.hashCode();
    }

    protected LocalizationService initLocalizationService(Locale locale) {
        return this.base.getLocalizationService(locale);
    }

    public void registerRootModelElement(IModelElement rootModelElement) {
    }

    public void registerModelElement(Node xmlNode, IModelElement modelElement) {
    }

    public void unregisterModelElement(Node xmlNode, IModelElement modelElement) {
    }

    private static Document doc(Reader r) {
        DocumentBuilder docbuilder = XmlResourceStore.docbuilder();
        try {
            return docbuilder.parse(new InputSource(r));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (SAXParseException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    private static Document doc() {
        return XmlResourceStore.docbuilder().newDocument();
    }

    private static DocumentBuilder docbuilder() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            factory.setIgnoringComments(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String publicID, String systemID) {
                    return new InputSource(new StringReader(""));
                }
            });
            return builder;
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }
}

