/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.catalog;

import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.BindingImpl;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ListBindingImpl;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyContentEvent;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.ValueBindingImpl;
import org.eclipse.sapphire.modeling.xml.ChildXmlResource;
import org.eclipse.sapphire.modeling.xml.StandardXmlListBindingImpl;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlResource;
import org.eclipse.sapphire.modeling.xml.XmlUtil;
import org.eclipse.sapphire.samples.catalog.Catalog;
import org.eclipse.sapphire.samples.catalog.Category;
import org.eclipse.sapphire.samples.catalog.Item;
import org.eclipse.sapphire.util.IdentityHashSet;
import org.eclipse.sapphire.util.ListFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CategoriesBinding
extends ListBindingImpl {
    private List<CategoryResource> cache = ListFactory.empty();
    private Listener listener;

    public void init(final IModelElement element, final ModelProperty property, String[] params) {
        super.init(element, property, params);
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                element.refresh(property);
                for (Category category : ((Catalog)element).getCategories()) {
                    category.refresh((ModelProperty)Category.PROP_ITEMS);
                }
            }
        };
        element.attach(this.listener, "Items/Category");
    }

    public List<? extends Resource> read() {
        List resources;
        TreeSet<String> categories = new TreeSet<String>(CategoryNamesComparator.INSTANCE);
        for (Item item : ((Catalog)this.element()).getItems()) {
            categories.add(item.getCategory().getText());
        }
        ListFactory resourcesListFactory = ListFactory.start();
        IdentityHashSet reused = new IdentityHashSet();
        for (String category : categories) {
            boolean found = false;
            for (CategoryResource resource : this.cache) {
                if (CategoryNamesComparator.INSTANCE.compare(category, resource.getName()) != 0) continue;
                resourcesListFactory.add((Object)resource);
                reused.add(resource);
                found = true;
                break;
            }
            if (found) continue;
            resourcesListFactory.add((Object)new CategoryResource(category));
        }
        for (CategoryResource resource : this.cache) {
            if (reused.contains((Object)resource)) continue;
            resource.dispose();
        }
        this.cache = resources = resourcesListFactory.result();
        this.cache = resources;
        return this.cache;
    }

    public ModelElementType type(Resource resource) {
        return Category.TYPE;
    }

    public void dispose() {
        for (CategoryResource resource : this.cache) {
            resource.dispose();
        }
        this.cache = null;
        this.element().detach(this.listener, "Items/Category");
        this.listener = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CategoryNamesComparator
    implements Comparator<String> {
        public static CategoryNamesComparator INSTANCE = new CategoryNamesComparator();

        private CategoryNamesComparator() {
        }

        @Override
        public int compare(String x, String y) {
            x = x == null ? "" : x.trim();
            String string = y = y == null ? "" : y.trim();
            if (x == y) {
                return 0;
            }
            if (x.length() == 0) {
                return Integer.MAX_VALUE;
            }
            if (y.length() == 0) {
                return Integer.MIN_VALUE;
            }
            return x.compareToIgnoreCase(y);
        }
    }

    private final class CategoryResource
    extends XmlResource {
        private String name;

        public CategoryResource(String name) {
            super((XmlResource)CategoriesBinding.this.element().resource());
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
            for (Item item : ((Category)this.element()).getItems()) {
                item.setCategory(name);
            }
        }

        protected BindingImpl createBinding(ModelProperty property) {
            Object binding = null;
            if (property == Category.PROP_NAME) {
                binding = new ValueBindingImpl(){

                    public String read() {
                        return CategoryResource.this.getName();
                    }

                    public void write(String value) {
                        CategoryResource.this.setName(value);
                    }
                };
            } else if (property == Category.PROP_ITEMS) {
                binding = new StandardXmlListBindingImpl(){

                    protected void initBindingMetadata(IModelElement element, ModelProperty property, String[] params) {
                        this.xmlElementNames = new QName[]{XmlUtil.createQualifiedName((String)"Item", null)};
                        this.modelElementTypes = new ModelElementType[]{Item.TYPE};
                    }

                    protected List<?> readUnderlyingList() {
                        List all = super.readUnderlyingList();
                        ListFactory filtered = ListFactory.start();
                        for (Object obj : all) {
                            XmlElement element = (XmlElement)obj;
                            String category = element.getChildNodeText("Category");
                            if (CategoryNamesComparator.INSTANCE.compare(CategoryResource.this.name, category) != 0) continue;
                            filtered.add((Object)element);
                        }
                        return filtered.result();
                    }

                    protected Object insertUnderlyingObject(ModelElementType type, int position) {
                        XmlElement element = (XmlElement)super.insertUnderlyingObject(type, position);
                        element.setChildNodeText("Category", CategoryResource.this.name, true);
                        return element;
                    }

                    protected Resource resource(Object obj) {
                        return new ChildXmlResource((XmlResource)CategoryResource.this, (XmlElement)obj);
                    }

                    protected XmlElement getXmlElement(boolean createIfNecessary) {
                        return ((XmlResource)((Catalog)this.element().nearest(Catalog.class)).adapt(XmlResource.class)).getXmlElement(createIfNecessary);
                    }
                };
            }
            if (binding != null) {
                binding.init(this.element(), property, null);
            }
            return binding;
        }

        public XmlElement getXmlElement(boolean createIfNecessary) {
            return null;
        }
    }
}

