/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.gallery.internal;

import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.samples.gallery.Circle;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ServiceFactory;
import org.eclipse.sapphire.services.ValueSerializationService;

public final class CircleSerializationService
extends ValueSerializationService {
    protected Object decodeFromString(String value) {
        String[] segments = value.split(",");
        if (segments.length == 3) {
            try {
                int x = Integer.parseInt(segments[0].trim());
                int y = Integer.parseInt(segments[1].trim());
                int radius = Integer.parseInt(segments[2].trim());
                return new Circle(x, y, radius);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return null;
    }

    public String encode(Object value) {
        if (value != null) {
            Circle circle = (Circle)value;
            StringBuilder buf = new StringBuilder();
            buf.append(circle.x());
            buf.append(", ");
            buf.append(circle.y());
            buf.append(", ");
            buf.append(circle.radius());
            return buf.toString();
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ServiceFactory {
        public boolean applicable(ServiceContext context, Class<? extends Service> service) {
            ValueProperty property = (ValueProperty)context.find(ValueProperty.class);
            return property != null && property.isOfType(Circle.class);
        }

        public Service create(ServiceContext context, Class<? extends Service> service) {
            return new CircleSerializationService();
        }
    }
}

