/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.sdk.build.processor.internal;

import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.Declaration;
import java.util.Collection;
import java.util.Set;
import org.eclipse.sapphire.modeling.annotations.GenerateImpl;
import org.eclipse.sapphire.sdk.build.processor.internal.ExternalizeStringResourcesProcessor;
import org.eclipse.sapphire.sdk.build.processor.internal.GenerateImplProcessor;
import org.eclipse.sapphire.sdk.build.processor.internal.SapphireAnnotationsProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Processor
implements AnnotationProcessor {
    private final AnnotationProcessorEnvironment _env;
    private final GenerateImplProcessor generateImplProcessor;
    private final ExternalizeStringResourcesProcessor generateLabelResourcesProcessor;

    public Processor(Set<AnnotationTypeDeclaration> atds, AnnotationProcessorEnvironment env) {
        this._env = env;
        this.generateImplProcessor = new GenerateImplProcessor();
        this.generateLabelResourcesProcessor = new ExternalizeStringResourcesProcessor();
    }

    public void process() {
        this.process(GenerateImpl.class.getName(), this.generateImplProcessor);
        try {
            this.generateLabelResourcesProcessor.process(this._env);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void process(String annotationTypeName, SapphireAnnotationsProcessor processor) {
        try {
            AnnotationTypeDeclaration annotationDeclaration = (AnnotationTypeDeclaration)this._env.getTypeDeclaration(annotationTypeName);
            if (annotationDeclaration == null) {
                return;
            }
            Collection annotatedDeclarations = this._env.getDeclarationsAnnotatedWith(annotationDeclaration);
            if (annotatedDeclarations == null) {
                return;
            }
            for (Declaration decl : annotatedDeclarations) {
                Collection annotations = decl.getAnnotationMirrors();
                for (AnnotationMirror annotation : annotations) {
                    if (!annotation.getAnnotationType().getDeclaration().getQualifiedName().equals(annotationTypeName)) continue;
                    processor.process(this._env, decl, annotation);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

