/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.misc.t0003;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.sapphire.Version;
import org.eclipse.sapphire.VersionConstraint;
import org.eclipse.sapphire.tests.SapphireTestCase;

public final class TestMisc0003
extends SapphireTestCase {
    private TestMisc0003(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("TestMisc0003");
        suite.addTest((Test)new TestMisc0003("testSingleVersionConstraint"));
        suite.addTest((Test)new TestMisc0003("testClosedRangeVersionConstraint1"));
        suite.addTest((Test)new TestMisc0003("testClosedRangeVersionConstraint2"));
        suite.addTest((Test)new TestMisc0003("testClosedRangeVersionConstraint3"));
        suite.addTest((Test)new TestMisc0003("testOpenRangeVersionConstraint1"));
        suite.addTest((Test)new TestMisc0003("testOpenRangeVersionConstraint2"));
        suite.addTest((Test)new TestMisc0003("testOpenRangeVersionConstraint3"));
        suite.addTest((Test)new TestMisc0003("testOpenRangeVersionConstraint4"));
        suite.addTest((Test)new TestMisc0003("testComplexVersionConstraint"));
        suite.addTest((Test)new TestMisc0003("testVersionConstraintSpaceTolerance"));
        suite.addTest((Test)new TestMisc0003("testVersionConstraintErrorHandling01"));
        suite.addTest((Test)new TestMisc0003("testVersionConstraintErrorHandling02"));
        suite.addTest((Test)new TestMisc0003("testVersionConstraintErrorHandling03"));
        suite.addTest((Test)new TestMisc0003("testVersionConstraintErrorHandling04"));
        suite.addTest((Test)new TestMisc0003("testVersionConstraintErrorHandling05"));
        suite.addTest((Test)new TestMisc0003("testVersionConstraintErrorHandling06"));
        suite.addTest((Test)new TestMisc0003("testVersionConstraintErrorHandling07"));
        suite.addTest((Test)new TestMisc0003("testVersionConstraintErrorHandling08"));
        suite.addTest((Test)new TestMisc0003("testVersionConstraintErrorHandling09"));
        suite.addTest((Test)new TestMisc0003("testVersionConstraintErrorHandling10"));
        suite.addTest((Test)new TestMisc0003("testVersionConstraintErrorHandling11"));
        suite.addTest((Test)new TestMisc0003("testVersionConstraintErrorHandling12"));
        suite.addTest((Test)new TestMisc0003("testVersionConstraintErrorHandling13"));
        suite.addTest((Test)new TestMisc0003("testVersionConstraintErrorHandling14"));
        suite.addTest((Test)new TestMisc0003("testVersionConstraintErrorHandling15"));
        suite.addTest((Test)new TestMisc0003("testVersionConstraintErrorHandling16"));
        suite.addTest((Test)new TestMisc0003("testVersionConstraintErrorHandling17"));
        suite.addTest((Test)new TestMisc0003("testVersionConstraintErrorHandling18"));
        suite.addTest((Test)new TestMisc0003("testVersionConstraintErrorHandling19"));
        suite.addTest((Test)new TestMisc0003("testVersionConstraintErrorHandling20"));
        return suite;
    }

    public void testSingleVersionConstraint() {
        VersionConstraint constraint = new VersionConstraint("1.2.3");
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("1.2.3")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("1.2.3.0.0")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("1.2.4")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("1.2.3.4")));
    }

    public void testClosedRangeVersionConstraint1() {
        VersionConstraint constraint = new VersionConstraint("[1.2.3-1.3)");
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("1.2.3")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("1.2.3.0.0")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("1.2.5")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("1.3")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("1.3.0")));
    }

    public void testClosedRangeVersionConstraint2() {
        VersionConstraint constraint = new VersionConstraint("[1.2.3-1.3]");
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("1.2.3")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("1.2.3.0.0")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("1.2.5")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("1.3")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("1.3.0")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("1.3.1")));
    }

    public void testClosedRangeVersionConstraint3() {
        VersionConstraint constraint = new VersionConstraint("(1.2.3-1.3]");
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("1.2.3")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("1.2.3.0.0")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("1.2.5")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("1.3")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("1.3.0")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("1.3.1")));
    }

    public void testOpenRangeVersionConstraint1() {
        VersionConstraint constraint = new VersionConstraint("[1.2.3");
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("0.5.3")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("1.0")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("1.2.2")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("1.2.3")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("1.2.3.0.0")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("1.2.5")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("1.3")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("2.0")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("55.0")));
    }

    public void testOpenRangeVersionConstraint2() {
        VersionConstraint constraint = new VersionConstraint("(1.2.3");
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("0.5.3")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("1.0")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("1.2.2")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("1.2.3")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("1.2.3.0.0")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("1.2.5")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("1.3")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("2.0")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("55.0")));
    }

    public void testOpenRangeVersionConstraint3() {
        VersionConstraint constraint = new VersionConstraint("1.2.3]");
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("0.5.3")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("1.0")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("1.2.2")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("1.2.3")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("1.2.3.0.0")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("1.2.5")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("1.3")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("2.0")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("55.0")));
    }

    public void testOpenRangeVersionConstraint4() {
        VersionConstraint constraint = new VersionConstraint("1.2.3)");
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("0.5.3")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("1.0")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("1.2.2")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("1.2.3")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("1.2.3.0.0")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("1.2.5")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("1.3")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("2.0")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("55.0")));
    }

    public void testComplexVersionConstraint() {
        VersionConstraint constraint = new VersionConstraint("1.2.3,3.4,[5.2-6.0),[8.3");
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("1.2")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("1.2.1")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("1.2.3")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("1.2.4")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("3.3")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("3.4")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("3.4.1")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("3.5")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("5.0")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("5.1")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("5.2")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("5.3")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("5.9.9.9")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("6.0")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("6.1")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("7.3")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("8.0")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("8.2")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("8.3")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("8.3.4.5")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("8.5")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("9.0")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("55.0")));
    }

    public void testVersionConstraintSpaceTolerance() {
        VersionConstraint constraint = new VersionConstraint("   1.2.3, 3.4  ,   [   5.2  -   6.0) ,    [  8.3    ");
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("1.2")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("1.2.1")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("1.2.3")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("1.2.4")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("3.3")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("3.4")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("3.4.1")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("3.5")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("5.0")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("5.1")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("5.2")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("5.3")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("5.9.9.9")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("6.0")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("6.1")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("7.3")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("8.0")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("8.2")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("8.3")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("8.3.4.5")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("8.5")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("9.0")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("55.0")));
    }

    public void testVersionConstraintErrorHandling01() {
        try {
            new VersionConstraint(null);
            TestMisc0003.fail((String)"IllegalArgumentException not thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testVersionConstraintErrorHandling02() {
        try {
            new VersionConstraint("");
            TestMisc0003.fail((String)"IllegalArgumentException not thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testVersionConstraintErrorHandling03() {
        try {
            new VersionConstraint("   ");
            TestMisc0003.fail((String)"IllegalArgumentException not thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testVersionConstraintErrorHandling04() {
        try {
            new VersionConstraint("[");
            TestMisc0003.fail((String)"IllegalArgumentException not thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testVersionConstraintErrorHandling05() {
        try {
            new VersionConstraint(")");
            TestMisc0003.fail((String)"IllegalArgumentException not thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testVersionConstraintErrorHandling06() {
        try {
            new VersionConstraint("[[1.2.3");
            TestMisc0003.fail((String)"IllegalArgumentException not thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testVersionConstraintErrorHandling07() {
        try {
            new VersionConstraint("1.2.3))");
            TestMisc0003.fail((String)"IllegalArgumentException not thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testVersionConstraintErrorHandling08() {
        try {
            new VersionConstraint("[1.2.3-");
            TestMisc0003.fail((String)"IllegalArgumentException not thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testVersionConstraintErrorHandling09() {
        try {
            new VersionConstraint("-1.2.3)");
            TestMisc0003.fail((String)"IllegalArgumentException not thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testVersionConstraintErrorHandling10() {
        try {
            new VersionConstraint("1.2.3-");
            TestMisc0003.fail((String)"IllegalArgumentException not thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testVersionConstraintErrorHandling11() {
        try {
            new VersionConstraint("-1.2.3");
            TestMisc0003.fail((String)"IllegalArgumentException not thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testVersionConstraintErrorHandling12() {
        try {
            new VersionConstraint("1.2.3-4.5.6");
            TestMisc0003.fail((String)"IllegalArgumentException not thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testVersionConstraintErrorHandling13() {
        try {
            new VersionConstraint(",1.2.3");
            TestMisc0003.fail((String)"IllegalArgumentException not thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testVersionConstraintErrorHandling14() {
        try {
            new VersionConstraint("1.2.3,");
            TestMisc0003.fail((String)"IllegalArgumentException not thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testVersionConstraintErrorHandling15() {
        try {
            new VersionConstraint("1.2.3,,4.5.6");
            TestMisc0003.fail((String)"IllegalArgumentException not thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testVersionConstraintErrorHandling16() {
        try {
            new VersionConstraint("1.2.3.");
            TestMisc0003.fail((String)"IllegalArgumentException not thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testVersionConstraintErrorHandling17() {
        try {
            new VersionConstraint(".1.2.3");
            TestMisc0003.fail((String)"IllegalArgumentException not thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testVersionConstraintErrorHandling18() {
        try {
            new VersionConstraint("1..2.3");
            TestMisc0003.fail((String)"IllegalArgumentException not thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testVersionConstraintErrorHandling19() {
        try {
            new VersionConstraint("1 2.3");
            TestMisc0003.fail((String)"IllegalArgumentException not thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testVersionConstraintErrorHandling20() {
        try {
            new VersionConstraint("1.2.3.v20120702");
            TestMisc0003.fail((String)"IllegalArgumentException not thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }
}

