/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.el.t0010;

import java.math.BigDecimal;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.Literal;
import org.eclipse.sapphire.modeling.el.ModelElementFunctionContext;
import org.eclipse.sapphire.modeling.el.parser.ExpressionLanguageParser;
import org.eclipse.sapphire.tests.modeling.el.TestExpr;
import org.eclipse.sapphire.tests.modeling.el.t0010.TestModelElementA;
import org.eclipse.sapphire.tests.modeling.el.t0010.TestModelRoot;

public final class TestExpr0010
extends TestExpr {
    private TestExpr0010(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("TestExpr0010");
        suite.addTest((Test)new TestExpr0010("testWithArray"));
        suite.addTest((Test)new TestExpr0010("testWithList"));
        suite.addTest((Test)new TestExpr0010("testWithSet"));
        suite.addTest((Test)new TestExpr0010("testWithModelElementList"));
        return suite;
    }

    public void testWithArray() {
        TestFunctionContext context = new TestFunctionContext(new Object[0]);
        TestExpr0010.testForExpectedValue((FunctionContext)context, "${ Sum( Collection ) }", (Object)new BigDecimal("0"));
        context = new TestFunctionContext(new Object[]{"1"});
        TestExpr0010.testForExpectedValue((FunctionContext)context, "${ Sum( Collection ) }", (Object)new BigDecimal("1"));
        context = new TestFunctionContext(new Object[]{"1", "2", "3.5"});
        TestExpr0010.testForExpectedValue((FunctionContext)context, "${ Sum( Collection ) }", (Object)new BigDecimal("6.5"));
        context = new TestFunctionContext(new Object[]{"1", 2, new BigDecimal("3.5")});
        TestExpr0010.testForExpectedValue((FunctionContext)context, "${ Sum( Collection ) }", (Object)new BigDecimal("6.5"));
    }

    public void testWithList() {
        TestFunctionContext context = new TestFunctionContext(TestExpr0010.list(new Object[0]));
        TestExpr0010.testForExpectedValue((FunctionContext)context, "${ Sum( Collection ) }", (Object)new BigDecimal("0"));
        context = new TestFunctionContext(TestExpr0010.list("1"));
        TestExpr0010.testForExpectedValue((FunctionContext)context, "${ Sum( Collection ) }", (Object)new BigDecimal("1"));
        context = new TestFunctionContext(TestExpr0010.list("1", "2", "3.5"));
        TestExpr0010.testForExpectedValue((FunctionContext)context, "${ Sum( Collection ) }", (Object)new BigDecimal("6.5"));
        context = new TestFunctionContext(TestExpr0010.list("1", 2, new BigDecimal("3.5")));
        TestExpr0010.testForExpectedValue((FunctionContext)context, "${ Sum( Collection ) }", (Object)new BigDecimal("6.5"));
    }

    public void testWithSet() {
        TestFunctionContext context = new TestFunctionContext(TestExpr0010.set(new Object[0]));
        TestExpr0010.testForExpectedValue((FunctionContext)context, "${ Sum( Collection ) }", (Object)new BigDecimal("0"));
        context = new TestFunctionContext(TestExpr0010.set("1"));
        TestExpr0010.testForExpectedValue((FunctionContext)context, "${ Sum( Collection ) }", (Object)new BigDecimal("1"));
        context = new TestFunctionContext(TestExpr0010.set("1", "2", "3.5"));
        TestExpr0010.testForExpectedValue((FunctionContext)context, "${ Sum( Collection ) }", (Object)new BigDecimal("6.5"));
        context = new TestFunctionContext(TestExpr0010.set("1", 2, new BigDecimal("3.5")));
        TestExpr0010.testForExpectedValue((FunctionContext)context, "${ Sum( Collection ) }", (Object)new BigDecimal("6.5"));
    }

    public void testWithModelElementList() {
        TestModelRoot root = (TestModelRoot)TestModelRoot.TYPE.instantiate();
        ModelElementList<TestModelElementA> list = root.getList1();
        ModelElementFunctionContext context = new ModelElementFunctionContext((IModelElement)root);
        TestExpr0010.testForExpectedValue((FunctionContext)context, "${ Sum( List1 ) }", (Object)new BigDecimal("0"));
        TestExpr0010.testForExpectedValue((FunctionContext)context, "${ Sum( List1, 'Value1' ) }", (Object)new BigDecimal("0"));
        TestExpr0010.testForExpectedValue((FunctionContext)context, "${ Sum( List1, 'Value2' ) }", (Object)new BigDecimal("0"));
        TestModelElementA a = (TestModelElementA)list.insert();
        a.setValue1("1");
        a.setValue2(2);
        TestExpr0010.testForExpectedValue((FunctionContext)context, "${ Sum( List1 ) }", (Object)new BigDecimal("1"));
        TestExpr0010.testForExpectedValue((FunctionContext)context, "${ Sum( List1, 'Value1' ) }", (Object)new BigDecimal("1"));
        TestExpr0010.testForExpectedValue((FunctionContext)context, "${ Sum( List1, 'Value2' ) }", (Object)new BigDecimal("2"));
        a = (TestModelElementA)list.insert();
        a.setValue1("2");
        a.setValue2(3);
        a = (TestModelElementA)list.insert();
        a.setValue1("3.5");
        a.setValue2(4);
        TestExpr0010.testForExpectedValue((FunctionContext)context, "${ Sum( List1 ) }", (Object)new BigDecimal("6.5"));
        TestExpr0010.testForExpectedValue((FunctionContext)context, "${ Sum( List1, 'Value1' ) }", (Object)new BigDecimal("6.5"));
        TestExpr0010.testForExpectedValue((FunctionContext)context, "${ Sum( List1, 'Value2' ) }", (Object)new BigDecimal("9"));
        TestExpr0010.testForExpectedError((FunctionContext)context, "${ Sum( List1, 'abc' ) }", "Property TestModelElementA.abc could not be found.");
        TestExpr0010.testForExpectedError((FunctionContext)context, "${ Sum( List1, 'Element1' ) }", "Property TestModelElementA.Element1 is not a value property.");
        TestExpr0010.testForExpectedError((FunctionContext)context, "${ Sum( List2 ) }", "Element type TestModelElementB does not contain a value property.");
        FunctionResult result = ExpressionLanguageParser.parse((String)"${ Sum( List1, 'Value1' ) }").evaluate((FunctionContext)context);
        TestExpr0010.assertEquals((Object)new BigDecimal("6.5"), (Object)result.value());
        ((TestModelElementA)list.get(0)).setValue1("2");
        ((TestModelElementA)list.get(1)).setValue1("3.5");
        TestExpr0010.assertEquals((Object)new BigDecimal("9.0"), (Object)result.value());
        a = (TestModelElementA)list.insert();
        a.setValue1("5.2");
        TestExpr0010.assertEquals((Object)new BigDecimal("14.2"), (Object)result.value());
    }

    private static final class TestFunctionContext
    extends FunctionContext {
        private final Object collection;

        public TestFunctionContext(Object collection) {
            this.collection = collection;
        }

        public FunctionResult property(Object element, String name) {
            if (element == this && name.equalsIgnoreCase("Collection")) {
                return Literal.create((Object)this.collection).evaluate((FunctionContext)this);
            }
            return super.property(element, name);
        }
    }
}

