/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.el.t0018;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.el.FailSafeFunction;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.Literal;
import org.eclipse.sapphire.modeling.el.ModelElementFunctionContext;
import org.eclipse.sapphire.modeling.el.parser.ExpressionLanguageParser;
import org.eclipse.sapphire.tests.modeling.el.TestExpr;
import org.eclipse.sapphire.tests.modeling.el.t0018.TestElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TestExpr0018
extends TestExpr {
    private TestExpr0018(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("TestExpr0018");
        suite.addTest((Test)new TestExpr0018("testFailSafeWithBoolean"));
        suite.addTest((Test)new TestExpr0018("testFailSafeWithInteger"));
        suite.addTest((Test)new TestExpr0018("testFailSafeWithEnum"));
        return suite;
    }

    public void testFailSafeWithBoolean() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        ModelElementFunctionContext context = new ModelElementFunctionContext((IModelElement)element);
        element.setBooleanValue("abc");
        element.setBooleanValueWithDefault("abc");
        TestExpr0018.assertEquals((String)"abc", (String)element.getBooleanValue().getText());
        TestExpr0018.assertEquals(null, (Object)element.getBooleanValue().getContent());
        TestExpr0018.assertFailSafeValueEquals((FunctionContext)context, "${ BooleanValue }", String.class, Boolean.TRUE, "abc");
        TestExpr0018.assertFailSafeValueEquals((FunctionContext)context, "${ BooleanValue }", Boolean.class, Boolean.TRUE, Boolean.TRUE);
        TestExpr0018.assertFailSafeValueEquals((FunctionContext)context, "${ BooleanValue }", Boolean.class, null, Boolean.FALSE);
        TestExpr0018.assertEquals((String)"abc", (String)element.getBooleanValueWithDefault().getText());
        TestExpr0018.assertEquals((Object)Boolean.TRUE, (Object)element.getBooleanValueWithDefault().getContent());
        TestExpr0018.assertFailSafeValueEquals((FunctionContext)context, "${ BooleanValueWithDefault }", String.class, Boolean.TRUE, "abc");
        TestExpr0018.assertFailSafeValueEquals((FunctionContext)context, "${ BooleanValueWithDefault }", Boolean.class, Boolean.TRUE, Boolean.TRUE);
        TestExpr0018.assertFailSafeValueEquals((FunctionContext)context, "${ BooleanValueWithDefault }", Boolean.class, null, Boolean.TRUE);
    }

    public void testFailSafeWithInteger() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        ModelElementFunctionContext context = new ModelElementFunctionContext((IModelElement)element);
        element.setIntegerValue("abc");
        element.setIntegerValueWithDefault("abc");
        TestExpr0018.assertEquals((String)"abc", (String)element.getIntegerValue().getText());
        TestExpr0018.assertEquals(null, (Object)element.getIntegerValue().getContent());
        TestExpr0018.assertFailSafeValueEquals((FunctionContext)context, "${ IntegerValue }", String.class, 2, "abc");
        TestExpr0018.assertFailSafeValueEquals((FunctionContext)context, "${ IntegerValue }", Integer.class, 2, 2);
        TestExpr0018.assertFailSafeValueEquals((FunctionContext)context, "${ IntegerValue }", Integer.class, null, 0);
        TestExpr0018.assertEquals((String)"abc", (String)element.getIntegerValueWithDefault().getText());
        TestExpr0018.assertEquals((Object)1, (Object)element.getIntegerValueWithDefault().getContent());
        TestExpr0018.assertFailSafeValueEquals((FunctionContext)context, "${ IntegerValueWithDefault }", String.class, 2, "abc");
        TestExpr0018.assertFailSafeValueEquals((FunctionContext)context, "${ IntegerValueWithDefault }", Integer.class, 2, 1);
        TestExpr0018.assertFailSafeValueEquals((FunctionContext)context, "${ IntegerValueWithDefault }", Integer.class, null, 1);
    }

    public void testFailSafeWithEnum() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        ModelElementFunctionContext context = new ModelElementFunctionContext((IModelElement)element);
        element.setEnumValue("abc");
        element.setEnumValueWithDefault("abc");
        TestExpr0018.assertEquals((String)"abc", (String)element.getEnumValue().getText());
        TestExpr0018.assertEquals(null, (Object)element.getEnumValue().getContent());
        TestExpr0018.assertFailSafeValueEquals((FunctionContext)context, "${ EnumValue }", String.class, (Object)TestElement.EnumType.B, "abc");
        TestExpr0018.assertFailSafeValueEquals((FunctionContext)context, "${ EnumValue }", TestElement.EnumType.class, (Object)TestElement.EnumType.B, (Object)TestElement.EnumType.B);
        TestExpr0018.assertFailSafeValueEquals((FunctionContext)context, "${ EnumValue }", TestElement.EnumType.class, null, null);
        TestExpr0018.assertEquals((String)"abc", (String)element.getEnumValueWithDefault().getText());
        TestExpr0018.assertEquals((Object)((Object)TestElement.EnumType.A), (Object)element.getEnumValueWithDefault().getContent());
        TestExpr0018.assertFailSafeValueEquals((FunctionContext)context, "${ EnumValueWithDefault }", String.class, (Object)TestElement.EnumType.B, "abc");
        TestExpr0018.assertFailSafeValueEquals((FunctionContext)context, "${ EnumValueWithDefault }", TestElement.EnumType.class, (Object)TestElement.EnumType.B, (Object)TestElement.EnumType.A);
        TestExpr0018.assertFailSafeValueEquals((FunctionContext)context, "${ EnumValueWithDefault }", TestElement.EnumType.class, null, (Object)TestElement.EnumType.A);
    }

    protected static void assertFailSafeValueEquals(FunctionContext context, String expr, Class<?> type, Object def, Object expected) {
        TestExpr0018.testForExpectedValue(context, FailSafeFunction.create((Function)ExpressionLanguageParser.parse((String)expr), (Function)Literal.create(type), (Function)Literal.create((Object)def)), expected);
    }
}

