/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.services.t0001;

import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementHandle;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.AbsolutePath;
import org.eclipse.sapphire.modeling.annotations.CountConstraint;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Fact;
import org.eclipse.sapphire.modeling.annotations.Facts;
import org.eclipse.sapphire.modeling.annotations.FileExtensions;
import org.eclipse.sapphire.modeling.annotations.FileSystemResourceType;
import org.eclipse.sapphire.modeling.annotations.GenerateImpl;
import org.eclipse.sapphire.modeling.annotations.MustExist;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.ReadOnly;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.annotations.SensitiveData;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.annotations.ValidFileSystemResourceType;
import org.eclipse.sapphire.tests.EmptyModelElement;
import org.eclipse.sapphire.tests.services.t0001.TestNoDuplicatesChildElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GenerateImpl
public interface TestRootElement
extends IModelElement {
    public static final ModelElementType TYPE = new ModelElementType(TestRootElement.class);
    public static final ValueProperty PROP_PLAIN = new ValueProperty(TYPE, "Plain");
    @SensitiveData
    public static final ValueProperty PROP_SENSITIVE = new ValueProperty(TYPE, "Sensitive");
    @DefaultValue(text="123")
    public static final ValueProperty PROP_DEFAULT_VALUE = new ValueProperty(TYPE, "DefaultValue");
    @SensitiveData
    @DefaultValue(text="123")
    public static final ValueProperty PROP_DEFAULT_VALUE_SENSITIVE = new ValueProperty(TYPE, "DefaultValueSensitive");
    @Type(base=Integer.class)
    @NumericRange(min="1")
    public static final ValueProperty PROP_NUMERIC_RANGE_MIN = new ValueProperty(TYPE, "NumericRangeMin");
    @Type(base=Integer.class)
    @NumericRange(max="100")
    public static final ValueProperty PROP_NUMERIC_RANGE_MAX = new ValueProperty(TYPE, "NumericRangeMax");
    @Type(base=Integer.class)
    @NumericRange(min="1", max="100")
    public static final ValueProperty PROP_NUMERIC_RANGE_MIN_MAX = new ValueProperty(TYPE, "NumericRangeMinMax");
    @Required
    public static final ValueProperty PROP_REQUIRED_VALUE = new ValueProperty(TYPE, "RequiredValue");
    @Required
    @DefaultValue(text="123")
    public static final ValueProperty PROP_REQUIRED_VALUE_WITH_DEFAULT = new ValueProperty(TYPE, "RequiredValueWithDefault");
    @Type(base=EmptyModelElement.class)
    @Required
    public static final ElementProperty PROP_REQUIRED_ELEMENT = new ElementProperty(TYPE, "RequiredElement");
    @ReadOnly
    public static final ValueProperty PROP_READ_ONLY = new ValueProperty(TYPE, "ReadOnly");
    @Type(base=EmptyModelElement.class)
    @CountConstraint(min=1)
    public static final ListProperty PROP_COUNT_CONSTRAINT_AT_LEAST_ONE = new ListProperty(TYPE, "CountConstraintAtLeastOne");
    @Type(base=EmptyModelElement.class)
    @CountConstraint(min=2)
    public static final ListProperty PROP_COUNT_CONSTRAINT_MIN = new ListProperty(TYPE, "CountConstraintMin");
    @Type(base=EmptyModelElement.class)
    @CountConstraint(max=200)
    public static final ListProperty PROP_COUNT_CONSTRAINT_MAX = new ListProperty(TYPE, "CountConstraintMax");
    @Type(base=EmptyModelElement.class)
    @CountConstraint(min=2, max=200)
    public static final ListProperty PROP_COUNT_CONSTRAINT_MIN_MAX = new ListProperty(TYPE, "CountConstraintMinMax");
    @Type(base=Path.class)
    @AbsolutePath
    public static final ValueProperty PROP_ABSOLUTE_PATH = new ValueProperty(TYPE, "AbsolutePath");
    @Type(base=Path.class)
    @MustExist
    public static final ValueProperty PROP_MUST_EXIST = new ValueProperty(TYPE, "MustExist");
    @Type(base=Path.class)
    @MustExist
    @AbsolutePath
    public static final ValueProperty PROP_MUST_EXIST_ABSOLUTE_PATH = new ValueProperty(TYPE, "MustExistAbsolutePath");
    @Type(base=TestNoDuplicatesChildElement.class)
    public static final ListProperty PROP_NO_DUPLICATES = new ListProperty(TYPE, "NoDuplicates");
    @Type(base=Path.class)
    @FileExtensions(expr="xml")
    public static final ValueProperty PROP_FILE_EXTENSIONS_ONE = new ValueProperty(TYPE, "FileExtensionsOne");
    @Type(base=Path.class)
    @FileExtensions(expr="xml,java")
    public static final ValueProperty PROP_FILE_EXTENSIONS_TWO = new ValueProperty(TYPE, "FileExtensionsTwo");
    @Type(base=Path.class)
    @FileExtensions(expr="xml,java,jsp")
    public static final ValueProperty PROP_FILE_EXTENSIONS_THREE = new ValueProperty(TYPE, "FileExtensionsThree");
    @Type(base=Path.class)
    @FileExtensions(expr="xml,java,jsp,jspx")
    public static final ValueProperty PROP_FILE_EXTENSIONS_MANY = new ValueProperty(TYPE, "FileExtensionsMany");
    @Type(base=Path.class)
    @ValidFileSystemResourceType(value=FileSystemResourceType.FILE)
    public static final ValueProperty PROP_VALID_FILE_SYSTEM_RESOURCE_TYPE_FILE = new ValueProperty(TYPE, "ValidFileSystemResourceTypeFile");
    @Type(base=Path.class)
    @ValidFileSystemResourceType(value=FileSystemResourceType.FOLDER)
    public static final ValueProperty PROP_VALID_FILE_SYSTEM_RESOURCE_TYPE_FOLDER = new ValueProperty(TYPE, "ValidFileSystemResourceTypeFolder");
    @Deprecated
    public static final ValueProperty PROP_DEPRECATED = new ValueProperty(TYPE, "Deprecated");
    @Fact(statement="First static fact.")
    @Facts(value={@Fact(statement="Second static fact."), @Fact(statement="Third static fact.")})
    public static final ValueProperty PROP_STATIC_FACT = new ValueProperty(TYPE, "StaticFact");

    public Value<String> getPlain();

    public void setPlain(String var1);

    public Value<String> getSensitive();

    public void setSensitive(String var1);

    public Value<String> getDefaultValue();

    public void setDefaultValue(String var1);

    public Value<String> getDefaultValueSensitive();

    public void setDefaultValueSensitive(String var1);

    public Value<Integer> getNumericRangeMin();

    public void setNumericRangeMin(String var1);

    public void setNumericRangeMin(Integer var1);

    public Value<Integer> getNumericRangeMax();

    public void setNumericRangeMax(String var1);

    public void setNumericRangeMax(Integer var1);

    public Value<Integer> getNumericRangeMinMax();

    public void setNumericRangeMinMax(String var1);

    public void setNumericRangeMinMax(Integer var1);

    public Value<String> getRequiredValue();

    public void setRequiredValue(String var1);

    public Value<String> getRequiredValueWithDefault();

    public void setRequiredValueWithDefault(String var1);

    public ModelElementHandle<EmptyModelElement> getRequiredElement();

    public Value<String> getReadOnly();

    public ModelElementList<EmptyModelElement> getCountConstraintAtLeastOne();

    public ModelElementList<EmptyModelElement> getCountConstraintMin();

    public ModelElementList<EmptyModelElement> getCountConstraintMax();

    public ModelElementList<EmptyModelElement> getCountConstraintMinMax();

    public Value<Path> getAbsolutePath();

    public void setAbsolutePath(String var1);

    public void setAbsolutePath(Path var1);

    public Value<Path> getMustExist();

    public void setMustExist(String var1);

    public void setMustExist(Path var1);

    public Value<Path> getMustExistAbsolutePath();

    public void setMustExistAbsolutePath(String var1);

    public void setMustExistAbsolutePath(Path var1);

    public ModelElementList<TestNoDuplicatesChildElement> getNoDuplicates();

    public Value<Path> getFileExtensionsOne();

    public void setFileExtensionsOne(String var1);

    public void setFileExtensionsOne(Path var1);

    public Value<Path> getFileExtensionsTwo();

    public void setFileExtensionsTwo(String var1);

    public void setFileExtensionsTwo(Path var1);

    public Value<Path> getFileExtensionsThree();

    public void setFileExtensionsThree(String var1);

    public void setFileExtensionsThree(Path var1);

    public Value<Path> getFileExtensionsMany();

    public void setFileExtensionsMany(String var1);

    public void setFileExtensionsMany(Path var1);

    public Value<Path> getValidFileSystemResourceTypeFile();

    public void setValidFileSystemResourceTypeFile(String var1);

    public void setValidFileSystemResourceTypeFile(Path var1);

    public Value<Path> getValidFileSystemResourceTypeFolder();

    public void setValidFileSystemResourceTypeFolder(String var1);

    public void setValidFileSystemResourceTypeFolder(Path var1);

    public Value<String> getDeprecated();

    public void setDeprecated(String var1);

    public Value<String> getStaticFact();

    public void setStaticFact(String var1);
}

