/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.ElementDisposeEvent;
import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementHandle;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyEnablementEvent;
import org.eclipse.sapphire.modeling.PropertyEvent;
import org.eclipse.sapphire.modeling.PropertyValidationEvent;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.LongString;
import org.eclipse.sapphire.modeling.annotations.PossibleValues;
import org.eclipse.sapphire.modeling.el.AndFunction;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.Literal;
import org.eclipse.sapphire.modeling.localization.LabelTransformer;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.services.PossibleValuesService;
import org.eclipse.sapphire.ui.FormComponentPart;
import org.eclipse.sapphire.ui.PartValidationEvent;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.ISapphireHint;
import org.eclipse.sapphire.ui.def.ISapphireUiDef;
import org.eclipse.sapphire.ui.def.PartDef;
import org.eclipse.sapphire.ui.def.PropertyEditorDef;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.sapphire.ui.renderers.swt.BooleanPropertyEditorRenderer;
import org.eclipse.sapphire.ui.renderers.swt.CheckBoxListPropertyEditorRenderer;
import org.eclipse.sapphire.ui.renderers.swt.DefaultListPropertyEditorRenderer;
import org.eclipse.sapphire.ui.renderers.swt.DefaultValuePropertyEditorRenderer;
import org.eclipse.sapphire.ui.renderers.swt.EnumPropertyEditorRenderer;
import org.eclipse.sapphire.ui.renderers.swt.NamedValuesPropertyEditorRenderer;
import org.eclipse.sapphire.ui.renderers.swt.PropertyEditorRenderer;
import org.eclipse.sapphire.ui.renderers.swt.PropertyEditorRendererFactory;
import org.eclipse.sapphire.ui.renderers.swt.SlushBucketPropertyEditor;
import org.eclipse.sapphire.ui.swt.internal.PopUpListFieldPropertyEditorPresentation;
import org.eclipse.sapphire.ui.swt.internal.PopUpListFieldStyle;
import org.eclipse.sapphire.util.ListFactory;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyEditorPart
extends FormComponentPart {
    public static final String RELATED_CONTROLS = "related-controls";
    public static final String BROWSE_BUTTON = "browse-button";
    public static final String DATA_BINDING = "binding";
    private static final List<PropertyEditorRendererFactory> FACTORIES = new ArrayList<PropertyEditorRendererFactory>();
    private IModelElement element;
    private ModelProperty property;
    private List<ModelProperty> childProperties;
    private List<ModelProperty> childPropertiesReadOnly;
    private Map<IModelElement, Map<ModelProperty, PropertyEditorPart>> childPropertyEditors;
    private Map<String, Object> hints;
    private List<SapphirePart> relatedContentParts;
    private Listener listener;
    private FunctionResult labelFunctionResult;
    private PropertyEditorRenderer presentation;

    static {
        FACTORIES.add(new BooleanPropertyEditorRenderer.Factory());
        FACTORIES.add(new EnumPropertyEditorRenderer.Factory());
        FACTORIES.add(new NamedValuesPropertyEditorRenderer.Factory());
        FACTORIES.add(new DefaultValuePropertyEditorRenderer.Factory());
        FACTORIES.add(new CheckBoxListPropertyEditorRenderer.EnumFactory());
        FACTORIES.add(new SlushBucketPropertyEditor.Factory());
        FACTORIES.add(new DefaultListPropertyEditorRenderer.Factory());
    }

    @Override
    protected void init() {
        super.init();
        ISapphireUiDef rootdef = (ISapphireUiDef)this.definition.nearest(ISapphireUiDef.class);
        PropertyEditorDef propertyEditorPartDef = (PropertyEditorDef)this.definition;
        String pathString = (String)propertyEditorPartDef.getProperty().getContent();
        ModelPath path = new ModelPath(pathString);
        this.element = this.getModelElement();
        int i = 0;
        int n = path.length();
        while (i < n) {
            ModelPath.Segment segment = path.segment(i);
            if (segment instanceof ModelPath.ModelRootSegment) {
                this.element = (IModelElement)this.element.root();
            } else if (segment instanceof ModelPath.ParentElementSegment) {
                IModelParticle parent = this.element.parent();
                if (!(parent instanceof IModelElement)) {
                    parent = parent.parent();
                }
                this.element = (IModelElement)parent;
            } else if (segment instanceof ModelPath.PropertySegment) {
                this.property = this.resolve(this.element, ((ModelPath.PropertySegment)segment).getPropertyName());
                if (i + 1 != n) {
                    throw new RuntimeException(NLS.bind((String)Resources.invalidPath, (Object[])new Object[]{pathString}));
                }
            } else {
                throw new RuntimeException(NLS.bind((String)Resources.invalidPath, (Object[])new Object[]{pathString}));
            }
            ++i;
        }
        if (this.property == null) {
            throw new RuntimeException(NLS.bind((String)Resources.invalidPath, (Object[])new Object[]{pathString}));
        }
        this.element.read(this.property);
        this.listener = new FilteredListener<PropertyEvent>(){

            protected void handleTypedEvent(final PropertyEvent event) {
                if (event instanceof PropertyValidationEvent || event instanceof PropertyEnablementEvent) {
                    if (Display.getCurrent() == null) {
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                this.handleTypedEvent(event);
                            }
                        });
                        return;
                    }
                    PropertyEditorPart.this.refreshValidation();
                }
            }
        };
        this.element.attach(this.listener, this.property);
        this.childProperties = new ArrayList<ModelProperty>();
        this.childPropertiesReadOnly = Collections.unmodifiableList(this.childProperties);
        this.childPropertyEditors = new HashMap<IModelElement, Map<ModelProperty, PropertyEditorPart>>();
        ModelElementType type = this.property.getType();
        if (type != null) {
            if (propertyEditorPartDef.getChildProperties().isEmpty()) {
                for (ModelProperty childProperty : type.properties()) {
                    this.childProperties.add(childProperty);
                }
            } else {
                for (PropertyEditorDef childPropertyEditor : propertyEditorPartDef.getChildProperties()) {
                    String childPropertyName = (String)childPropertyEditor.getProperty().getContent();
                    ModelProperty childProperty = type.property(childPropertyName);
                    if (childProperty == null) {
                        SapphireUiFrameworkPlugin.logError("Could not resolve property: " + childPropertyName);
                        continue;
                    }
                    this.childProperties.add(childProperty);
                }
            }
        }
        this.hints = new HashMap<String, Object>();
        for (ISapphireHint hint : propertyEditorPartDef.getHints()) {
            String name = hint.getName().getText();
            String valueString = hint.getValue().getText();
            Serializable parsedValue = valueString;
            if (name.equals("show.header") || name.equals("border") || name.equals("browse.only") || name.equals("prefer.combo") || name.equals("prefer.radio.buttons") || name.equals("prefer.vertical.radio.buttons") || name.equals("read.only")) {
                parsedValue = Boolean.parseBoolean(valueString);
            } else if (name.startsWith("factory") || name.startsWith("aux.text.provider")) {
                parsedValue = rootdef.resolveClass(valueString);
            } else if (name.equals("listeners")) {
                ArrayList contributors = new ArrayList();
                String[] stringArray = valueString.split(",");
                int n2 = stringArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    String segment = stringArray[n3];
                    Class<?> cl = rootdef.resolveClass(segment.trim());
                    if (cl != null) {
                        contributors.add(cl);
                    }
                    ++n3;
                }
                parsedValue = contributors;
            }
            this.hints.put(name, parsedValue);
        }
        ListFactory relatedContentPartsListFactory = ListFactory.start();
        FilteredListener<PartValidationEvent> relatedContentPartListener = new FilteredListener<PartValidationEvent>(){

            protected void handleTypedEvent(PartValidationEvent event) {
                PropertyEditorPart.this.refreshValidation();
            }
        };
        for (PartDef relatedContentPartDef : propertyEditorPartDef.getRelatedContent()) {
            SapphirePart relatedContentPart = PropertyEditorPart.create(this, this.element, relatedContentPartDef, this.params);
            relatedContentPart.attach((Listener)relatedContentPartListener);
            relatedContentPartsListFactory.add((Object)relatedContentPart);
        }
        this.relatedContentParts = relatedContentPartsListFactory.result();
        this.labelFunctionResult = this.initExpression(this.getLocalModelElement(), (Function)propertyEditorPartDef.getLabel().getContent(), String.class, (Function)Literal.create((Object)this.property.getLabel(false, CapitalizationType.NO_CAPS, true)), new Runnable(){

            public void run() {
                PropertyEditorPart.this.broadcast(new SapphirePart.LabelChangedEvent(PropertyEditorPart.this));
            }
        });
    }

    @Override
    protected Function initVisibleWhenFunction() {
        return AndFunction.create((Function[])new Function[]{super.initVisibleWhenFunction(), PropertyEditorPart.createVersionCompatibleFunction(this.getLocalModelElement(), this.property)});
    }

    @Override
    public PropertyEditorDef definition() {
        return (PropertyEditorDef)super.definition();
    }

    @Override
    public IModelElement getLocalModelElement() {
        return this.element;
    }

    public ModelProperty getProperty() {
        return this.property;
    }

    public List<ModelProperty> getChildProperties() {
        return this.childPropertiesReadOnly;
    }

    public PropertyEditorPart getChildPropertyEditor(final IModelElement element, ModelProperty property) {
        PropertyEditorPart childPropertyEditorPart;
        Map<ModelProperty, PropertyEditorPart> propertyEditorsForElement = this.childPropertyEditors.get(element);
        if (propertyEditorsForElement == null) {
            propertyEditorsForElement = new HashMap<ModelProperty, PropertyEditorPart>();
            this.childPropertyEditors.put(element, propertyEditorsForElement);
            final Map<ModelProperty, PropertyEditorPart> finalPropertyEditorsForElement = propertyEditorsForElement;
            element.attach((Listener)new FilteredListener<ElementDisposeEvent>(){

                protected void handleTypedEvent(ElementDisposeEvent event) {
                    for (PropertyEditorPart propertyEditor : finalPropertyEditorsForElement.values()) {
                        propertyEditor.dispose();
                    }
                    PropertyEditorPart.this.childPropertyEditors.remove(element);
                }
            });
        }
        if ((childPropertyEditorPart = propertyEditorsForElement.get(property)) == null) {
            String childPropertyName = property.getName();
            PropertyEditorDef childPropertyEditorDef = ((PropertyEditorDef)this.definition).getChildPropertyEditor(property);
            if (childPropertyEditorDef == null) {
                childPropertyEditorDef = (PropertyEditorDef)PropertyEditorDef.TYPE.instantiate();
                childPropertyEditorDef.setProperty(childPropertyName);
            }
            childPropertyEditorPart = new PropertyEditorPart();
            childPropertyEditorPart.init(this, element, childPropertyEditorDef, this.params);
            propertyEditorsForElement.put(property, childPropertyEditorPart);
        }
        return childPropertyEditorPart;
    }

    public String getLabel(CapitalizationType capitalizationType, boolean includeMnemonic) {
        String label = (String)this.labelFunctionResult.value();
        return LabelTransformer.transform((String)label, (CapitalizationType)capitalizationType, (boolean)includeMnemonic);
    }

    public boolean getShowLabel() {
        return (Boolean)this.definition().getShowLabel().getContent();
    }

    public boolean getSpanBothColumns() {
        return (Boolean)this.definition().getSpanBothColumns().getContent();
    }

    public int getWidth(int defaultValue) {
        Integer width = (Integer)this.definition().getWidth().getContent();
        return width == null || width < 1 ? defaultValue : width;
    }

    public int getHeight(int defaultValue) {
        Integer height = (Integer)this.definition().getHeight().getContent();
        return height == null || height < 1 ? defaultValue : height;
    }

    public int getMarginLeft() {
        int marginLeft = (Integer)this.definition().getMarginLeft().getContent();
        if (marginLeft < 0) {
            marginLeft = 0;
        }
        return marginLeft;
    }

    public <T> T getRenderingHint(String name, T defaultValue) {
        Object hintValue = this.hints == null ? null : this.hints.get(name);
        return (T)(hintValue == null ? defaultValue : hintValue);
    }

    public boolean getRenderingHint(String name, boolean defaultValue) {
        Object hintValue = this.hints == null ? null : this.hints.get(name);
        return hintValue == null ? defaultValue : (Boolean)hintValue;
    }

    public List<SapphirePart> getRelatedContent() {
        return this.relatedContentParts;
    }

    public int getRelatedContentWidth() {
        Value<Integer> relatedContentWidth = this.definition().getRelatedContentWidth();
        if (relatedContentWidth.validation().ok()) {
            return (Integer)relatedContentWidth.getContent();
        }
        return (Integer)relatedContentWidth.getDefaultContent();
    }

    @Override
    public void render(SapphireRenderingContext context) {
        if (this.presentation != null) {
            this.presentation.dispose();
            this.presentation = null;
        }
        if (!this.visible()) {
            return;
        }
        String style = this.definition().getStyle().getText();
        if (style == null) {
            PropertyEditorRendererFactory factory = null;
            try {
                Class factoryClass = this.getRenderingHint("factory", null);
                if (factoryClass != null) {
                    factory = (PropertyEditorRendererFactory)factoryClass.newInstance();
                }
            }
            catch (Exception e) {
                SapphireUiFrameworkPlugin.log(e);
            }
            if (factory == null) {
                for (PropertyEditorRendererFactory f : FACTORIES) {
                    if (!f.isApplicableTo(this)) continue;
                    factory = f;
                    break;
                }
            }
            if (factory != null) {
                this.presentation = factory.create(context, this);
            }
        } else if (style.startsWith("Sapphire.PropertyEditor.PopUpListField") && this.property instanceof ValueProperty && this.element.service(this.property, PossibleValuesService.class) != null) {
            PopUpListFieldStyle popUpListFieldPresentationStyle = null;
            if (style.equals("Sapphire.PropertyEditor.PopUpListField")) {
                PossibleValues possibleValuesAnnotation;
                popUpListFieldPresentationStyle = Enum.class.isAssignableFrom(this.property.getTypeClass()) ? PopUpListFieldStyle.STRICT : ((possibleValuesAnnotation = (PossibleValues)this.property.getAnnotation(PossibleValues.class)) != null ? (possibleValuesAnnotation.invalidValueSeverity() == Status.Severity.ERROR ? PopUpListFieldStyle.STRICT : PopUpListFieldStyle.EDITABLE) : PopUpListFieldStyle.EDITABLE);
            } else if (style.equals("Sapphire.PropertyEditor.PopUpListField.Editable")) {
                popUpListFieldPresentationStyle = PopUpListFieldStyle.EDITABLE;
            } else if (style.equals("Sapphire.PropertyEditor.PopUpListField.Strict")) {
                popUpListFieldPresentationStyle = PopUpListFieldStyle.STRICT;
            }
            if (popUpListFieldPresentationStyle != null) {
                this.presentation = new PopUpListFieldPropertyEditorPresentation(context, this, popUpListFieldPresentationStyle);
            }
        }
        if (this.presentation == null) {
            throw new IllegalStateException(this.property.toString());
        }
        this.presentation.create(context.getComposite());
    }

    @Override
    protected Status computeValidation() {
        Status.CompositeStatusFactory factory = Status.factoryForComposite();
        if (this.element.enabled(this.property)) {
            Object particle = this.element.read(this.property);
            if (particle instanceof Value) {
                factory.merge(((Value)particle).validation());
            } else if (particle instanceof ModelElementList) {
                factory.merge(((ModelElementList)particle).validation());
            } else if (particle instanceof ModelElementHandle) {
                factory.merge(((ModelElementHandle)particle).validation());
            }
        }
        for (SapphirePart relatedContentPart : this.relatedContentParts) {
            factory.merge(relatedContentPart.validation());
        }
        return factory.create();
    }

    @Override
    public boolean setFocus() {
        if (this.element.enabled(this.property)) {
            this.broadcast(new SapphirePart.FocusReceivedEvent(this));
            return true;
        }
        return false;
    }

    @Override
    public boolean setFocus(ModelPath path) {
        String propertyName;
        ModelPath.Segment head = path.head();
        if (head instanceof ModelPath.PropertySegment && (propertyName = ((ModelPath.PropertySegment)head).getPropertyName()).equals(this.property.getName())) {
            return this.setFocus();
        }
        return false;
    }

    public String getActionContext() {
        String context;
        if (this.property instanceof ValueProperty) {
            context = "Sapphire.ValuePropertyEditor";
        } else if (this.property instanceof ElementProperty) {
            context = "Sapphire.ElementPropertyEditor";
        } else if (this.property instanceof ListProperty) {
            context = "Sapphire.ListPropertyEditor";
        } else {
            throw new IllegalStateException();
        }
        return context;
    }

    @Override
    public Set<String> getActionContexts() {
        return Collections.singleton(this.getActionContext());
    }

    @Override
    public boolean isSingleLinePart() {
        return this.property instanceof ValueProperty && !this.property.hasAnnotation(LongString.class);
    }

    public boolean isReadOnly() {
        return this.property.isReadOnly() || this.getRenderingHint("read.only", false);
    }

    @Override
    public void dispose() {
        if (this.presentation != null) {
            this.presentation.dispose();
        }
        if (this.listener != null) {
            this.element.detach(this.listener, this.property);
        }
        if (this.labelFunctionResult != null) {
            this.labelFunctionResult.dispose();
        }
        for (Map<ModelProperty, PropertyEditorPart> propertyEditorsForElement : this.childPropertyEditors.values()) {
            for (PropertyEditorPart propertyEditor : propertyEditorsForElement.values()) {
                propertyEditor.dispose();
            }
        }
        super.dispose();
    }

    private static final class Resources
    extends NLS {
        public static String invalidPath;

        static {
            Resources.initializeMessages((String)PropertyEditorPart.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

