/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.sapphire.DisposeEvent;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.LoggingService;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.Literal;
import org.eclipse.sapphire.modeling.el.ModelElementFunctionContext;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.SapphireActionGroup;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphireActionHandlerFactory;
import org.eclipse.sapphire.ui.SapphireActionHandlerFilter;
import org.eclipse.sapphire.ui.SapphireActionLocationHint;
import org.eclipse.sapphire.ui.SapphireActionSystemPart;
import org.eclipse.sapphire.ui.def.ActionDef;
import org.eclipse.sapphire.ui.def.ISapphireHint;
import org.eclipse.sapphire.ui.def.KeyBindingBehavior;
import org.eclipse.sapphire.ui.def.SapphireActionType;
import org.eclipse.sapphire.ui.def.SapphireKeySequence;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.sapphire.ui.util.TopologicalSorter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SapphireAction
extends SapphireActionSystemPart {
    private SapphireActionGroup parent;
    private SapphireActionType type;
    private String group;
    private SapphireKeySequence keyBinding;
    private KeyBindingBehavior keyBindingBehavior;
    private final List<SapphireActionHandler> handlers = new CopyOnWriteArrayList<SapphireActionHandler>();
    private final Map<SapphireActionHandlerFactory, List<SapphireActionHandler>> handlerFactories = new LinkedHashMap<SapphireActionHandlerFactory, List<SapphireActionHandler>>();
    private final List<SapphireActionHandlerFilter> filters = new CopyOnWriteArrayList<SapphireActionHandlerFilter>();
    private Listener handlerListener;
    private Map<String, Object> hints;

    public void init(SapphireActionGroup parent, ActionDef def) {
        this.parent = parent;
        super.init(def);
        this.handlerListener = new Listener(){

            public void handle(Event event) {
                if (event instanceof SapphireActionSystemPart.VisibilityEvent) {
                    SapphireAction.this.refreshVisibilityState();
                } else if (event instanceof SapphireActionSystemPart.EnablementChangedEvent) {
                    SapphireAction.this.refreshEnablementState();
                } else if (event instanceof SapphireActionSystemPart.CheckedStateChangedEvent) {
                    SapphireAction.this.refreshCheckedState();
                }
            }
        };
        this.attach(new Listener(){

            public void handle(Event event) {
                if (event instanceof HandlersChangedEvent || event instanceof FiltersChangedEvent) {
                    SapphireAction.this.refreshVisibilityState();
                    SapphireAction.this.refreshEnablementState();
                    SapphireAction.this.refreshCheckedState();
                } else if (event instanceof DisposeEvent) {
                    for (SapphireActionHandler handler : SapphireAction.this.handlers) {
                        try {
                            handler.dispose();
                        }
                        catch (Exception e) {
                            SapphireUiFrameworkPlugin.log(e);
                        }
                    }
                    for (SapphireActionHandlerFactory factory : SapphireAction.this.handlerFactories.keySet()) {
                        try {
                            factory.dispose();
                        }
                        catch (Exception e) {
                            SapphireUiFrameworkPlugin.log(e);
                        }
                    }
                }
            }
        });
        if (def != null) {
            this.type = (SapphireActionType)((Object)def.getType().getContent());
            this.group = (String)def.getGroup().getContent();
            this.keyBinding = (SapphireKeySequence)def.getKeyBinding().getContent();
            this.keyBindingBehavior = (KeyBindingBehavior)((Object)def.getKeyBindingBehavior().getContent());
        }
        this.setEnabled(false);
        this.hints = new HashMap<String, Object>();
        for (ISapphireHint hint : def.getHints()) {
            String name = hint.getName().getText();
            String parsedValue = null;
            if (name.equals("style")) {
                parsedValue = hint.getValue().getText();
            }
            this.hints.put(name, parsedValue);
        }
    }

    @Override
    protected FunctionContext initFunctionContext() {
        ISapphirePart part = this.getPart();
        return new ModelElementFunctionContext(part.getLocalModelElement(), (LocalizationService)part.definition().adapt(LocalizationService.class)){

            public FunctionResult property(Object element, String name) {
                if (element == this && name.equalsIgnoreCase("handlers")) {
                    Function f = new Function(){

                        public String name() {
                            return "ReadProperty";
                        }

                        public FunctionResult evaluate(FunctionContext context) {
                            return new FunctionResult(this, context){
                                private Listener listener;

                                protected void init() {
                                    super.init();
                                    this.listener = new Listener(){

                                        public void handle(Event event) {
                                            if (event instanceof HandlersChangedEvent) {
                                                this.refresh();
                                            }
                                        }
                                    };
                                    SapphireAction.this.attach(this.listener);
                                }

                                protected Object evaluate() {
                                    return SapphireAction.this.getActiveHandlers();
                                }

                                public void dispose() {
                                    super.dispose();
                                    SapphireAction.this.detach(this.listener);
                                }
                            };
                        }
                    };
                    f.init(new Function[0]);
                    return f.evaluate((FunctionContext)this);
                }
                if (element instanceof SapphireActionHandler && name.equalsIgnoreCase("label")) {
                    return Literal.create((Object)((SapphireActionHandler)element).getLabel()).evaluate((FunctionContext)this);
                }
                return super.property(element, name);
            }
        };
    }

    public SapphireActionGroup getActionSet() {
        return this.parent;
    }

    public final ISapphirePart getPart() {
        return this.parent.getPart();
    }

    public String getContext() {
        return this.parent.getContext();
    }

    public <T> T getRenderingHint(String name, T defaultValue) {
        Object hintValue = this.hints == null ? null : this.hints.get(name);
        return (T)(hintValue == null ? defaultValue : hintValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SapphireActionType getType() {
        SapphireAction sapphireAction = this;
        synchronized (sapphireAction) {
            return this.type;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setType(SapphireActionType type) {
        SapphireAction sapphireAction = this;
        synchronized (sapphireAction) {
            this.type = type;
        }
        this.broadcast(new TypeChangedEvent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getGroup() {
        SapphireAction sapphireAction = this;
        synchronized (sapphireAction) {
            return this.group;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGroup(String group) {
        SapphireAction sapphireAction = this;
        synchronized (sapphireAction) {
            this.group = group;
        }
        this.broadcast(new GroupChangedEvent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SapphireKeySequence getKeyBinding() {
        SapphireAction sapphireAction = this;
        synchronized (sapphireAction) {
            return this.keyBinding;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKeyBinding(SapphireKeySequence keyBinding) {
        SapphireAction sapphireAction = this;
        synchronized (sapphireAction) {
            this.keyBinding = keyBinding;
        }
        this.broadcast(new KeyBindingChangedEvent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyBindingBehavior getKeyBindingBehavior() {
        SapphireAction sapphireAction = this;
        synchronized (sapphireAction) {
            return this.keyBindingBehavior;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKeyBindingBehavior(KeyBindingBehavior keyBindingBehavior) {
        SapphireAction sapphireAction = this;
        synchronized (sapphireAction) {
            this.keyBindingBehavior = keyBindingBehavior;
        }
        this.broadcast(new KeyBindingBehaviorChangedEvent());
    }

    public void addHandler(SapphireActionHandler handler) {
        handler.attach(this.handlerListener);
        this.handlers.add(handler);
        this.broadcast(new HandlersChangedEvent());
    }

    public void removeHandler(SapphireActionHandler handler) {
        handler.detach(this.handlerListener);
        this.handlers.remove(handler);
        this.broadcast(new HandlersChangedEvent());
    }

    public void removeHandlers(Collection<SapphireActionHandler> handlers) {
        for (SapphireActionHandler handler : handlers) {
            handler.detach(this.handlerListener);
            this.handlers.remove(handler);
        }
        this.broadcast(new HandlersChangedEvent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHandlerFactory(final SapphireActionHandlerFactory factory) {
        SapphireAction sapphireAction = this;
        synchronized (sapphireAction) {
            if (this.handlerFactories.containsKey(factory)) {
                throw new IllegalArgumentException();
            }
            ArrayList<SapphireActionHandler> handlers = new ArrayList<SapphireActionHandler>();
            for (SapphireActionHandler handler : factory.create()) {
                handler.init(this, null);
                handler.attach(this.handlerListener);
                handlers.add(handler);
            }
            factory.attach(new Listener(){

                public void handle(Event event) {
                    SapphireAction.this.refreshHandlerFactory(factory);
                }
            });
            this.handlerFactories.put(factory, handlers);
        }
        this.broadcast(new HandlersChangedEvent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHandlerFactory(SapphireActionHandlerFactory factory) {
        boolean changed = false;
        SapphireAction sapphireAction = this;
        synchronized (sapphireAction) {
            List<SapphireActionHandler> handlers = this.handlerFactories.remove(factory);
            if (handlers != null) {
                for (SapphireActionHandler handler : handlers) {
                    try {
                        handler.dispose();
                    }
                    catch (Exception e) {
                        LoggingService.log((Exception)e);
                    }
                }
                changed = true;
            }
        }
        if (changed) {
            this.broadcast(new HandlersChangedEvent());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshHandlerFactory(SapphireActionHandlerFactory factory) {
        SapphireAction sapphireAction = this;
        synchronized (sapphireAction) {
            List<SapphireActionHandler> handlers = this.handlerFactories.get(factory);
            if (handlers == null) {
                throw new IllegalStateException();
            }
            for (SapphireActionHandler handler : handlers) {
                try {
                    handler.dispose();
                }
                catch (Exception e) {
                    LoggingService.log((Exception)e);
                }
            }
            handlers.clear();
            for (SapphireActionHandler handler : factory.create()) {
                handler.init(this, null);
                handler.attach(this.handlerListener);
                handlers.add(handler);
            }
        }
        this.broadcast(new HandlersChangedEvent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SapphireActionHandler> getActiveHandlers() {
        SapphireAction sapphireAction = this;
        synchronized (sapphireAction) {
            ArrayList<SapphireActionHandler> handlers = new ArrayList<SapphireActionHandler>();
            handlers.addAll(this.handlers);
            for (List<SapphireActionHandler> factoryHandlers : this.handlerFactories.values()) {
                handlers.addAll(factoryHandlers);
            }
            TopologicalSorter<SapphireActionHandler> sorter = new TopologicalSorter<SapphireActionHandler>();
            for (SapphireActionHandler handler : handlers) {
                boolean ok = true;
                ArrayList<SapphireActionHandlerFilter> failedFilters = null;
                for (SapphireActionHandlerFilter filter : this.filters) {
                    try {
                        ok = filter.check(handler);
                    }
                    catch (Exception e) {
                        SapphireUiFrameworkPlugin.log(e);
                        if (failedFilters == null) {
                            failedFilters = new ArrayList<SapphireActionHandlerFilter>();
                        }
                        failedFilters.add(filter);
                    }
                    if (!ok) break;
                }
                if (failedFilters != null) {
                    this.filters.removeAll(failedFilters);
                }
                if (!ok) continue;
                TopologicalSorter.Entity handlerEntity = sorter.entity(handler.getId(), handler);
                for (SapphireActionLocationHint locationHint : handler.getLocationHints()) {
                    handlerEntity.constraint(locationHint.toString());
                }
            }
            return Collections.unmodifiableList(sorter.sort());
        }
    }

    public SapphireActionHandler getFirstActiveHandler() {
        List<SapphireActionHandler> handlers = this.getActiveHandlers();
        return handlers.isEmpty() ? null : handlers.get(0);
    }

    public boolean hasActiveHandlers() {
        return this.getFirstActiveHandler() != null;
    }

    public void addFilter(SapphireActionHandlerFilter filter) {
        this.filters.add(filter);
        this.broadcast(new FiltersChangedEvent());
    }

    public void removeFilter(SapphireActionHandlerFilter filter) {
        this.filters.remove(filter);
        this.broadcast(new FiltersChangedEvent());
    }

    private void refreshVisibilityState() {
        boolean visible = false;
        for (SapphireActionHandler handler : this.getActiveHandlers()) {
            if (!handler.isVisible()) continue;
            visible = true;
            break;
        }
        this.setVisible(visible);
    }

    private void refreshEnablementState() {
        boolean enabled = false;
        for (SapphireActionHandler handler : this.getActiveHandlers()) {
            if (!handler.isEnabled()) continue;
            enabled = true;
            break;
        }
        this.setEnabled(enabled);
    }

    private void refreshCheckedState() {
        boolean checked = false;
        SapphireActionHandler handler = this.getFirstActiveHandler();
        if (handler != null) {
            checked = handler.isChecked();
        }
        this.setChecked(checked);
    }

    public static final class FiltersChangedEvent
    extends Event {
    }

    public static final class GroupChangedEvent
    extends Event {
    }

    public static final class HandlersChangedEvent
    extends Event {
    }

    public static final class KeyBindingBehaviorChangedEvent
    extends Event {
    }

    public static final class KeyBindingChangedEvent
    extends Event {
    }

    public static final class TypeChangedEvent
    extends Event {
    }
}

