/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.util.Collections;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ImageData;
import org.eclipse.sapphire.modeling.localization.LabelTransformer;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.SapphireEditor;
import org.eclipse.sapphire.ui.SapphireEditorPagePart;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.def.EditorPageDef;
import org.eclipse.sapphire.ui.renderers.swt.SwtRendererUtil;
import org.eclipse.sapphire.ui.swt.EditorPagePresentation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SapphireEditorFormPage
extends FormPage
implements EditorPagePresentation {
    private final SapphireEditor editor;
    private IModelElement element;
    private DefinitionLoader.Reference<EditorPageDef> definition;
    private SapphireEditorPagePart part;

    public SapphireEditorFormPage(SapphireEditor editor, IModelElement element, DefinitionLoader.Reference<EditorPageDef> definition) {
        super((FormEditor)editor, null, null);
        if (element == null) {
            throw new IllegalArgumentException();
        }
        if (definition == null) {
            throw new IllegalArgumentException();
        }
        this.editor = editor;
        this.element = element;
        this.definition = definition;
        this.part = (SapphireEditorPagePart)SapphirePart.create(editor, this.element, this.definition.resolve(), Collections.<String, String>emptyMap());
        this.part.attach(new Listener(){

            public void handle(Event event) {
                if (event instanceof SapphireEditorPagePart.PageHeaderTextEvent) {
                    SapphireEditorFormPage.this.refreshPageHeaderText();
                } else if (event instanceof SapphireEditorPagePart.PageHeaderImageEvent) {
                    SapphireEditorFormPage.this.refreshPageHeaderImage();
                }
            }
        });
    }

    public final SapphireEditor getEditor() {
        return this.editor;
    }

    @Override
    public SapphireEditorPagePart getPart() {
        return this.part;
    }

    public final IModelElement getModelElement() {
        return this.part.getModelElement();
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.refreshPageHeaderText();
        this.refreshPageHeaderImage();
    }

    private final void refreshPageHeaderText() {
        if (this.getManagedForm() != null) {
            ScrolledForm form = this.getManagedForm().getForm();
            form.setText(LabelTransformer.transform((String)this.part.getPageHeaderText(), (CapitalizationType)CapitalizationType.TITLE_STYLE, (boolean)false));
        }
    }

    private final void refreshPageHeaderImage() {
        if (this.getManagedForm() != null) {
            ImageData newImageData;
            ScrolledForm form = this.getManagedForm().getForm();
            Image oldImage = form.getImage();
            if (oldImage != null) {
                oldImage.dispose();
            }
            if ((newImageData = this.part.getPageHeaderImage()) == null) {
                form.setImage(null);
            } else {
                form.setImage(SwtRendererUtil.toImageDescriptor(newImageData).createImage());
            }
        }
    }

    public void dispose() {
        Image image;
        super.dispose();
        if (this.getManagedForm() != null && (image = this.getManagedForm().getForm().getImage()) != null) {
            image.dispose();
        }
        this.element = null;
        this.part.dispose();
        this.part = null;
        this.definition.dispose();
        this.definition = null;
    }

    public abstract String getId();

    protected static final class FormEditorRenderingContext
    extends SapphireRenderingContext {
        private final FormToolkit toolkit;

        public FormEditorRenderingContext(ISapphirePart part, IManagedForm managedForm) {
            this(part, managedForm.getForm().getBody(), managedForm.getToolkit());
        }

        public FormEditorRenderingContext(ISapphirePart part, Composite composite, FormToolkit toolkit) {
            super(part, composite);
            this.toolkit = toolkit;
        }

        public void adapt(Control control) {
            super.adapt(control);
            if (control instanceof Composite) {
                this.toolkit.adapt((Composite)control);
            } else if (control instanceof Label) {
                this.toolkit.adapt(control, false, false);
            } else {
                this.toolkit.adapt(control, true, true);
            }
        }
    }
}

