/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.lang.reflect.Field;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyContentEvent;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.ui.PageBookPart;
import org.eclipse.sapphire.ui.def.ISapphireUiDef;
import org.eclipse.sapphire.ui.def.PageBookExtDef;

public final class SapphireEnumControlledPageBook
extends PageBookPart {
    private IModelElement element;
    private ValueProperty property;
    private Listener listener;

    protected void init() {
        String pathString = (String)((PageBookExtDef)this.definition).getControlProperty().getContent();
        String pathStringSubstituted = SapphireEnumControlledPageBook.substituteParams(pathString, this.params);
        ModelPath path = new ModelPath(pathStringSubstituted);
        this.element = this.getLocalModelElement();
        int i = 0;
        int n = path.length();
        while (i < n) {
            ModelPath.Segment segment = path.segment(i);
            if (segment instanceof ModelPath.ModelRootSegment) {
                this.element = (IModelElement)this.element.root();
            } else if (segment instanceof ModelPath.ParentElementSegment) {
                IModelParticle parent = this.element.parent();
                if (!(parent instanceof IModelElement)) {
                    parent = parent.parent();
                }
                this.element = (IModelElement)parent;
            } else if (segment instanceof ModelPath.PropertySegment) {
                this.property = (ValueProperty)this.resolve(this.element, ((ModelPath.PropertySegment)segment).getPropertyName());
                if (i + 1 != n) {
                    throw new RuntimeException(NLS.bind((String)Resources.invalidPathMsg, (Object[])new Object[]{pathStringSubstituted}));
                }
            } else {
                throw new RuntimeException(NLS.bind((String)Resources.invalidPathMsg, (Object[])new Object[]{pathStringSubstituted}));
            }
            ++i;
        }
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                SapphireEnumControlledPageBook.this.updateCurrentPage();
            }
        };
        this.element.attach(this.listener, (ModelProperty)this.property);
        super.init();
        this.setExposePageValidationState(true);
        this.updateCurrentPage();
    }

    protected Object parsePageKey(String panelKeyString) {
        String enumItemName;
        Class enumType = this.property.getTypeClass();
        int lastDot = panelKeyString.lastIndexOf(46);
        if (lastDot == -1) {
            enumItemName = panelKeyString;
        } else {
            String className = panelKeyString.substring(0, lastDot);
            enumItemName = panelKeyString.substring(lastDot + 1);
            ISapphireUiDef rootdef = (ISapphireUiDef)this.definition.nearest(ISapphireUiDef.class);
            Class<?> specifiedEnumType = rootdef.resolveClass(className);
            if (specifiedEnumType == null) {
                throw new RuntimeException(NLS.bind((String)Resources.invalidPageKeyClassNotResolvedMsg, (Object[])new Object[]{panelKeyString, className}));
            }
            if (specifiedEnumType != enumType) {
                throw new RuntimeException(NLS.bind((String)Resources.invalidPageKeyClassNotMatchedMsg, (Object[])new Object[]{panelKeyString, className}));
            }
        }
        Field field = null;
        Field[] fieldArray = enumType.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            if (f.isEnumConstant() && f.getName().equalsIgnoreCase(enumItemName)) {
                field = f;
                break;
            }
            ++n2;
        }
        if (field == null) {
            throw new RuntimeException(NLS.bind((String)Resources.invalidPageKeyEnumItemMsg, (Object[])new Object[]{panelKeyString, enumType.getSimpleName(), enumItemName}));
        }
        try {
            return field.get(null);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private void updateCurrentPage() {
        Value newEnumItemValue = this.element.read(this.property);
        Enum newEnumItem = (Enum)newEnumItemValue.getContent(true);
        this.changePage(this.element, newEnumItem);
    }

    public void dispose() {
        super.dispose();
        if (this.listener != null) {
            this.element.detach(this.listener, (ModelProperty)this.property);
        }
    }

    private static final class Resources
    extends NLS {
        public static String invalidPathMsg;
        public static String invalidPageKeyClassNotResolvedMsg;
        public static String invalidPageKeyClassNotMatchedMsg;
        public static String invalidPageKeyEnumItemMsg;

        static {
            Resources.initializeMessages((String)SapphireEnumControlledPageBook.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

