/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.ui.PartValidationEvent;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.TabGroupPagePart;
import org.eclipse.sapphire.ui.def.TabGroupDef;
import org.eclipse.sapphire.ui.def.TabGroupPageDef;
import org.eclipse.sapphire.ui.swt.renderer.GridLayoutUtil;
import org.eclipse.sapphire.util.ListFactory;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TabGroupPart
extends SapphirePart {
    private List<TabGroupPagePart> pages;

    @Override
    protected void init() {
        super.init();
        IModelElement element = this.getModelElement();
        ListFactory pagesListFactory = ListFactory.start();
        FilteredListener<PartValidationEvent> tabPartListener = new FilteredListener<PartValidationEvent>(){

            protected void handleTypedEvent(PartValidationEvent event) {
                TabGroupPart.this.refreshValidation();
            }
        };
        for (TabGroupPageDef pageDef : this.definition().getTabs()) {
            TabGroupPagePart pagePart = new TabGroupPagePart();
            pagePart.init(this, element, pageDef, this.params);
            pagePart.attach((Listener)tabPartListener);
            pagesListFactory.add((Object)pagePart);
        }
        this.pages = pagesListFactory.result();
    }

    @Override
    public TabGroupDef definition() {
        return (TabGroupDef)super.definition();
    }

    @Override
    public void render(SapphireRenderingContext context) {
        boolean scaleVertically = (Boolean)this.definition().getScaleVertically().getContent();
        final TabFolder tabGroup = new TabFolder(context.getComposite(), 128);
        tabGroup.setLayoutData((Object)GridLayoutUtil.gdhindent(GridLayoutUtil.gdhspan(scaleVertically ? GridLayoutUtil.gdfill() : GridLayoutUtil.gdhfill(), 2), 9));
        context.adapt((Control)tabGroup);
        for (final TabGroupPagePart page : this.pages) {
            Composite tabControl = new Composite((Composite)tabGroup, 0);
            tabControl.setLayout((Layout)GridLayoutUtil.glayout(2, 1, 10, 10, 10));
            final TabItem tab = new TabItem(tabGroup, 0);
            tab.setText(page.getLabel());
            tab.setControl((Control)tabControl);
            final HashMap<ImageDescriptor, Image> images = new HashMap<ImageDescriptor, Image>();
            this.updateTabImage(tab, page, images);
            final Listener tabPartListener = new Listener(){

                public void handle(Event event) {
                    if (event instanceof SapphirePart.LabelChangedEvent) {
                        tab.setText(page.getLabel());
                    } else if (event instanceof SapphirePart.ImageChangedEvent) {
                        TabGroupPart.this.updateTabImage(tab, page, images);
                    }
                }
            };
            page.attach(tabPartListener);
            tab.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    page.detach(tabPartListener);
                    for (Image image : images.values()) {
                        image.dispose();
                    }
                }
            });
            page.render(new SapphireRenderingContext(page, context, tabControl));
        }
        tabGroup.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int tabGroupPageIndex = tabGroup.getSelectionIndex();
                TabGroupPagePart tabGroupPagePart = (TabGroupPagePart)TabGroupPart.this.pages.get(tabGroupPageIndex);
                tabGroupPagePart.setFocus();
            }
        });
    }

    private void updateTabImage(TabItem tab, TabGroupPagePart tabPart, Map<ImageDescriptor, Image> images) {
        Image image = null;
        ImageDescriptor imageDescriptor = tabPart.getImage();
        if (imageDescriptor != null && (image = images.get(imageDescriptor)) == null) {
            image = imageDescriptor.createImage();
            images.put(imageDescriptor, image);
        }
        tab.setImage(image);
    }

    @Override
    protected Status computeValidation() {
        Status.CompositeStatusFactory factory = Status.factoryForComposite();
        for (TabGroupPagePart page : this.pages) {
            factory.merge(page.validation());
        }
        return factory.create();
    }

    @Override
    public void dispose() {
        super.dispose();
        for (SapphirePart sapphirePart : this.pages) {
            sapphirePart.dispose();
        }
    }
}

