/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.assist.internal;

import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ImpliedElementProperty;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.ui.SourceEditorService;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContext;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContribution;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContributor;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistSection;

public final class ShowInSourceActionAssistContributor
extends PropertyEditorAssistContributor {
    public ShowInSourceActionAssistContributor() {
        this.setId("System.ShowInSourceActionContributor");
        this.setPriority(320);
    }

    public void contribute(PropertyEditorAssistContext context) {
        final IModelElement element = context.getModelElement();
        final ModelProperty prop = context.getProperty();
        final SourceEditorService sourceEditorService = (SourceEditorService)element.adapt(SourceEditorService.class);
        if (sourceEditorService == null) {
            return;
        }
        boolean contribute = false;
        if (!prop.isDerived()) {
            if (prop instanceof ValueProperty) {
                if (element.read((ValueProperty)prop).getText(false) != null) {
                    contribute = true;
                }
            } else if (prop instanceof ListProperty) {
                if (element.read((ListProperty)prop).size() > 0) {
                    contribute = true;
                }
            } else if (prop instanceof ElementProperty && !(prop instanceof ImpliedElementProperty) && element.read((ElementProperty)prop).element() != null) {
                contribute = true;
            }
        }
        if (!contribute) {
            return;
        }
        PropertyEditorAssistContribution.Factory contribution = PropertyEditorAssistContribution.factory();
        contribution.text("<p><a href=\"action\" nowrap=\"true\">" + ShowInSourceActionAssistContributor.escapeForXml(Resources.action) + "</a></p>");
        contribution.link("action", new Runnable(){

            public void run() {
                sourceEditorService.show(element, prop);
            }
        });
        PropertyEditorAssistSection section = context.getSection("actions");
        section.addContribution(contribution.create());
    }

    private static final class Resources
    extends NLS {
        public static String action;

        static {
            Resources.initializeMessages((String)ShowInSourceActionAssistContributor.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

