/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.diagram.editor;

import java.util.List;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.PropertyAccessFunction;

public class FunctionUtil {
    public static ValueProperty getFunctionProperty(IModelElement modelElement, FunctionResult functionResult) {
        if (functionResult.function() instanceof PropertyAccessFunction) {
            if (functionResult.operand(0).value() instanceof String) {
                String propName = (String)functionResult.operand(0).value();
                ModelElementType type = modelElement.type();
                ModelProperty property = type.property(propName);
                if (FunctionUtil.isWritableValueProperty(property)) {
                    return (ValueProperty)property;
                }
            }
        } else {
            List subFuncs = functionResult.operands();
            for (FunctionResult subFunc : subFuncs) {
                ValueProperty property = FunctionUtil.getFunctionProperty(modelElement, subFunc);
                if (!FunctionUtil.isWritableValueProperty((ModelProperty)property)) continue;
                return property;
            }
        }
        return null;
    }

    private static boolean isWritableValueProperty(ModelProperty property) {
        return property != null && property instanceof ValueProperty && !property.isReadOnly();
    }
}

