/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.form.editors.masterdetails.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sapphire.DisposeEvent;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.EditFailedException;
import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ImageData;
import org.eclipse.sapphire.modeling.ImpliedElementProperty;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementHandle;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyEvent;
import org.eclipse.sapphire.services.PossibleTypesService;
import org.eclipse.sapphire.ui.PartVisibilityEvent;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphireActionHandlerFactory;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.ActionHandlerDef;
import org.eclipse.sapphire.ui.def.ActionHandlerFactoryDef;
import org.eclipse.sapphire.ui.form.editors.masterdetails.MasterDetailsContentNode;
import org.eclipse.sapphire.ui.form.editors.masterdetails.MasterDetailsContentOutline;
import org.eclipse.sapphire.ui.form.editors.masterdetails.MasterDetailsEditorPagePart;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OutlineNodeAddActionHandlerFactory
extends SapphireActionHandlerFactory {
    public static final String ID_BASE = "Sapphire.Add.";
    private Listener possibleTypesServiceListener;
    private Listener nodeFactoryListener;

    @Override
    public void init(SapphireAction action, ActionHandlerFactoryDef def) {
        super.init(action, def);
        this.possibleTypesServiceListener = new Listener(){

            public void handle(Event event) {
                OutlineNodeAddActionHandlerFactory.this.broadcast(new Event());
            }
        };
        this.nodeFactoryListener = new FilteredListener<PartVisibilityEvent>(){

            protected void handleTypedEvent(PartVisibilityEvent event) {
                OutlineNodeAddActionHandlerFactory.this.broadcast(new Event());
            }
        };
        final MasterDetailsContentNode node = (MasterDetailsContentNode)this.getPart();
        final IModelElement element = node.getLocalModelElement();
        node.executeAfterInitialization(new Runnable(){

            public void run() {
                for (MasterDetailsContentNode.NodeFactory factory : node.factories()) {
                    factory.attach(OutlineNodeAddActionHandlerFactory.this.nodeFactoryListener);
                    PossibleTypesService possibleTypesService = (PossibleTypesService)element.service(factory.property(), PossibleTypesService.class);
                    possibleTypesService.attach(OutlineNodeAddActionHandlerFactory.this.possibleTypesServiceListener);
                }
                OutlineNodeAddActionHandlerFactory.this.broadcast(new Event());
            }
        });
    }

    @Override
    public List<SapphireActionHandler> create() {
        MasterDetailsContentNode node = (MasterDetailsContentNode)this.getPart();
        IModelElement element = node.getLocalModelElement();
        ArrayList<SapphireActionHandler> handlers = new ArrayList<SapphireActionHandler>();
        for (MasterDetailsContentNode.NodeFactory factory : node.factories()) {
            AbstractActionHandler handler;
            ListProperty prop;
            ModelProperty property = factory.property();
            if (!factory.visible() || property.isReadOnly()) continue;
            PossibleTypesService possibleTypesService = (PossibleTypesService)element.service(property, PossibleTypesService.class);
            if (property instanceof ListProperty) {
                prop = (ListProperty)property;
                for (ModelElementType memberType : possibleTypesService.types()) {
                    handler = new ListPropertyActionHandler(prop, memberType);
                    handlers.add(handler);
                }
                continue;
            }
            if (property instanceof ElementProperty && !(property instanceof ImpliedElementProperty)) {
                prop = (ElementProperty)property;
                for (ModelElementType memberType : possibleTypesService.types()) {
                    handler = new ElementPropertyActionHandler((ElementProperty)prop, memberType);
                    handlers.add(handler);
                }
                continue;
            }
            throw new IllegalStateException();
        }
        return handlers;
    }

    @Override
    public void dispose() {
        super.dispose();
        MasterDetailsContentNode node = (MasterDetailsContentNode)this.getPart();
        IModelElement element = node.getLocalModelElement();
        for (MasterDetailsContentNode.NodeFactory factory : node.factories()) {
            factory.detach(this.nodeFactoryListener);
            PossibleTypesService possibleTypesService = (PossibleTypesService)element.service(factory.property(), PossibleTypesService.class);
            possibleTypesService.detach(this.possibleTypesServiceListener);
        }
    }

    private static abstract class AbstractActionHandler
    extends SapphireActionHandler {
        private final ModelProperty property;
        private final ModelElementType type;
        private MasterDetailsContentOutline contentTree;

        public AbstractActionHandler(ModelProperty property, ModelElementType type) {
            this.property = property;
            this.type = type;
        }

        public void init(SapphireAction action, ActionHandlerDef def) {
            super.init(action, def);
            this.setId(OutlineNodeAddActionHandlerFactory.ID_BASE + this.type.getSimpleName());
            this.setLabel(this.type.getLabel(true, CapitalizationType.NO_CAPS, false));
            ImageData typeSpecificAddImage = this.type.image();
            if (typeSpecificAddImage != null) {
                this.addImage(typeSpecificAddImage);
            }
            this.contentTree = ((MasterDetailsContentNode)this.getPart()).getContentTree();
            final Listener contentTreeListener = new Listener(){

                public void handle(Event event) {
                    if (event instanceof MasterDetailsContentOutline.FilterChangedEvent) {
                        AbstractActionHandler.this.refreshEnablementState();
                    }
                }
            };
            this.contentTree.attach(contentTreeListener);
            this.refreshEnablementState();
            this.attach(new Listener(){

                public void handle(Event event) {
                    if (event instanceof DisposeEvent) {
                        AbstractActionHandler.this.contentTree.detach(contentTreeListener);
                    }
                }
            });
        }

        protected final void refreshEnablementState() {
            this.setEnabled(this.computeEnablementState());
        }

        protected boolean computeEnablementState() {
            return this.contentTree != null && this.contentTree.getFilterText().length() == 0;
        }

        public ModelProperty property() {
            return this.property;
        }

        protected final Object run(SapphireRenderingContext context) {
            IModelElement newModelElement;
            MasterDetailsContentNode node;
            block4: {
                node = (MasterDetailsContentNode)this.getPart();
                IModelElement element = node.getLocalModelElement();
                newModelElement = null;
                try {
                    newModelElement = this.create(element, this.property, this.type);
                }
                catch (Exception e) {
                    EditFailedException editFailedException = EditFailedException.findAsCause((Throwable)e);
                    if (editFailedException != null) break block4;
                    SapphireUiFrameworkPlugin.log(e);
                }
            }
            if (newModelElement != null) {
                for (MasterDetailsContentNode n : node.nodes().visible()) {
                    if (n.getModelElement() != newModelElement) continue;
                    n.select();
                    this.getPart().nearest(MasterDetailsEditorPagePart.class).setFocusOnDetails();
                    break;
                }
            }
            return newModelElement;
        }

        protected abstract IModelElement create(IModelElement var1, ModelProperty var2, ModelElementType var3);
    }

    private static final class ElementPropertyActionHandler
    extends AbstractActionHandler {
        public ElementPropertyActionHandler(ElementProperty property, ModelElementType type) {
            super((ModelProperty)property, type);
        }

        public void init(SapphireAction action, ActionHandlerDef def) {
            super.init(action, def);
            FilteredListener<PropertyEvent> listener = new FilteredListener<PropertyEvent>(){

                protected void handleTypedEvent(PropertyEvent event) {
                    ElementPropertyActionHandler.this.refreshEnablementState();
                }
            };
            final IModelElement element = ((MasterDetailsContentNode)this.getPart()).getLocalModelElement();
            element.attach((Listener)listener, (ModelProperty)this.property());
            this.attach(new Listener((Listener)listener){
                private final /* synthetic */ Listener val$listener;
                {
                    this.val$listener = listener;
                }

                public void handle(Event event) {
                    if (event instanceof DisposeEvent) {
                        element.detach(this.val$listener, (ModelProperty)ElementPropertyActionHandler.this.property());
                    }
                }
            });
        }

        public ElementProperty property() {
            return (ElementProperty)super.property();
        }

        protected IModelElement create(IModelElement element, ModelProperty property, ModelElementType type) {
            return element.read((ElementProperty)property).element(true, type);
        }

        protected boolean computeEnablementState() {
            boolean state = super.computeEnablementState();
            if (state) {
                IModelElement element = ((MasterDetailsContentNode)this.getPart()).getLocalModelElement();
                ModelElementHandle handle = element.read(this.property());
                state = handle.element() == null;
            }
            return state;
        }
    }

    private static final class ListPropertyActionHandler
    extends AbstractActionHandler {
        public ListPropertyActionHandler(ListProperty property, ModelElementType type) {
            super((ModelProperty)property, type);
        }

        protected IModelElement create(IModelElement element, ModelProperty property, ModelElementType type) {
            return element.read((ListProperty)property).insert(type);
        }
    }
}

