/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.IExecutableModelElement;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ProgressMonitor;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.ui.DelayedTasksExecutor;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphireWizardPagePart;
import org.eclipse.sapphire.ui.SapphireWizardPart;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.def.WizardDef;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.sapphire.ui.renderers.swt.SwtRendererUtil;
import org.eclipse.sapphire.ui.swt.ProgressMonitorBridge;
import org.eclipse.sapphire.ui.swt.SapphireStatusDialog;
import org.eclipse.sapphire.ui.swt.SapphireWizardPage;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SapphireWizard<M extends IExecutableModelElement>
extends Wizard {
    private IExecutableModelElement element;
    private boolean elementInstantiatedLocally;
    private DefinitionLoader.Reference<WizardDef> definition;
    private SapphireWizardPart part;

    public SapphireWizard(ModelElementType type, DefinitionLoader.Reference<WizardDef> definition) {
        this.init(type, definition);
    }

    public SapphireWizard(M element, DefinitionLoader.Reference<WizardDef> definition) {
        this.init((IExecutableModelElement)element, definition);
    }

    protected SapphireWizard() {
    }

    protected void init(ModelElementType type, DefinitionLoader.Reference<WizardDef> definition) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        if (!IExecutableModelElement.class.isAssignableFrom(type.getModelElementClass())) {
            throw new IllegalArgumentException();
        }
        if (definition == null) {
            throw new IllegalArgumentException();
        }
        this.elementInstantiatedLocally = true;
        this.init((IExecutableModelElement)type.instantiate(), definition);
    }

    protected void init(IExecutableModelElement element, DefinitionLoader.Reference<WizardDef> definition) {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        if (definition == null) {
            throw new IllegalArgumentException();
        }
        this.element = element;
        this.definition = definition;
        this.part = new SapphireWizardPart();
        this.part.init(null, (IModelElement)this.element, this.definition.resolve(), Collections.<String, String>emptyMap());
        this.setWindowTitle(this.part.getLabel());
        this.part.attach((Listener)new FilteredListener<SapphirePart.ImageChangedEvent>(){

            protected void handleTypedEvent(SapphirePart.ImageChangedEvent event) {
                SapphireWizard.this.refreshImage();
            }
        });
        this.refreshImage();
        this.setNeedsProgressMonitor(true);
    }

    public final M element() {
        return (M)this.element;
    }

    public final WizardDef definition() {
        return this.definition == null ? null : this.definition.resolve();
    }

    public void addPages() {
        for (SapphireWizardPagePart pagePart : this.part.getPages()) {
            this.addPage((IWizardPage)new SapphireWizardPage(pagePart));
        }
    }

    public final boolean performFinish() {
        DelayedTasksExecutor.sweep();
        final Status[] result = new Status[1];
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                result[0] = SapphireWizard.this.performFinish(ProgressMonitorBridge.create(monitor));
            }
        };
        try {
            this.getContainer().run(true, true, runnable);
        }
        catch (InvocationTargetException e) {
            SapphireUiFrameworkPlugin.log(e.getTargetException());
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        Status st = result[0];
        if (st.ok()) {
            this.performPostFinish();
            return true;
        }
        SapphireStatusDialog.open(this.getShell(), st);
        return false;
    }

    protected Status performFinish(ProgressMonitor monitor) {
        return this.element.execute(monitor);
    }

    protected void performPostFinish() {
    }

    protected final void openFileEditors(IFile ... files) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            IWorkbenchPage page = window.getActivePage();
            IFile[] iFileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file = iFileArray[n2];
                if (file != null && file.isAccessible()) {
                    try {
                        IDE.openEditor((IWorkbenchPage)page, (IFile)file);
                    }
                    catch (PartInitException e) {
                        SapphireUiFrameworkPlugin.log(e);
                    }
                }
                ++n2;
            }
        }
    }

    protected final void openFileEditor(IFile file) {
        this.openFileEditor(file, null);
    }

    protected final void openFileEditor(IFile file, String editor) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            IWorkbenchPage page = window.getActivePage();
            try {
                if (editor == null) {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file);
                } else {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (String)editor);
                    IDE.setDefaultEditor((IFile)file, (String)editor);
                }
            }
            catch (PartInitException e) {
                SapphireUiFrameworkPlugin.log(e);
            }
        }
    }

    private final void refreshImage() {
        ImageDescriptor img = SwtRendererUtil.toImageDescriptor(this.part.getImage());
        if (img == null) {
            img = JFaceResources.getImageRegistry().getDescriptor("org.eclipse.jface.wizard.Wizard.pageImage");
        }
        this.setDefaultPageImageDescriptor(img);
    }

    public void dispose() {
        super.dispose();
        if (this.element != null) {
            if (this.elementInstantiatedLocally) {
                this.element.dispose();
            }
            this.element = null;
        }
        if (this.part != null) {
            this.part.dispose();
            this.part = null;
        }
        if (this.definition != null) {
            this.definition.dispose();
            this.definition = null;
        }
    }
}

