/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.renderer;

import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.SubToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.SapphireActionGroup;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.swt.renderer.SapphireActionPresentationManager;
import org.eclipse.sapphire.ui.swt.renderer.SapphireHotSpotsActionPresentation;
import org.eclipse.sapphire.ui.swt.renderer.SapphireToolBarActionPresentation;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;

public final class SapphireToolBarManagerActionPresentation
extends SapphireHotSpotsActionPresentation {
    private IToolBarManager toolBarManager;
    private ToolBarContribution toolBarContribution;
    private SapphireToolBarActionPresentation toolBarActionPresentation;

    public SapphireToolBarManagerActionPresentation(SapphireActionPresentationManager manager) {
        super(manager);
        this.toolBarActionPresentation = new SapphireToolBarActionPresentation(manager);
    }

    public SapphireToolBarManagerActionPresentation(ISapphirePart part, Shell shell, SapphireActionGroup actions) {
        this(new SapphireActionPresentationManager(new SapphireRenderingContext(part, shell), actions));
    }

    public IToolBarManager getToolBarManager() {
        return this.toolBarManager;
    }

    public void setToolBarManager(IToolBarManager toolBarManager) {
        this.toolBarManager = toolBarManager;
        this.toolBarContribution = new ToolBarContribution();
    }

    public void render() {
        SapphireToolBarManagerActionPresentation.setCursor(this.toolBarManager, null);
        this.toolBarManager.add((IContributionItem)this.toolBarContribution);
        this.toolBarManager.update(true);
    }

    public ToolBar getToolBar() {
        return this.toolBarActionPresentation.getToolBar();
    }

    private static void setCursor(IToolBarManager toolBarManager, Cursor cursor) {
        if (toolBarManager instanceof ToolBarManager) {
            ((ToolBarManager)toolBarManager).getControl().setCursor(null);
        } else if (toolBarManager instanceof SubToolBarManager) {
            SapphireToolBarManagerActionPresentation.setCursor((IToolBarManager)((SubToolBarManager)toolBarManager).getParent(), cursor);
        }
    }

    private final class ToolBarContribution
    extends ControlContribution {
        private ToolBar toolBar;

        protected ToolBarContribution() {
            super("sapphire");
        }

        public boolean isDynamic() {
            return true;
        }

        protected Control createControl(Composite parent) {
            this.toolBar = new ToolBar(parent, 0x820000);
            this.toolBar.setBackground(null);
            this.toolBar.setForeground(parent.getForeground());
            SapphireToolBarManagerActionPresentation.this.toolBarActionPresentation.setToolBar(this.toolBar);
            SapphireToolBarManagerActionPresentation.this.toolBarActionPresentation.render();
            return this.toolBar;
        }
    }
}

