/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.workspace.ui;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.sapphire.modeling.ImageData;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.def.ActionHandlerDef;
import org.eclipse.sapphire.ui.swt.renderer.actions.RelativePathBrowseActionHandler;
import org.eclipse.sapphire.util.ListFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WorkspaceRelativePathBrowseActionHandler
extends RelativePathBrowseActionHandler {
    public void init(SapphireAction action, ActionHandlerDef def) {
        super.init(action, def);
        this.setLabel(Resources.label);
        this.addImage(ImageData.createFromClassLoader(WorkspaceRelativePathBrowseActionHandler.class, (String)"Project.png"));
    }

    public List<Path> getBasePaths() {
        ListFactory paths = ListFactory.start();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isAccessible()) {
                paths.add((Object)new Path(project.getLocation().toPortableString()));
            }
            ++n2;
        }
        return paths.result();
    }

    public Path convertToRelative(Path path) {
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Path location;
            IProject project = iProjectArray[n2];
            if (project.isAccessible() && (location = new Path(project.getLocation().toPortableString())).isPrefixOf(path)) {
                return new Path(project.getName()).append(path.makeRelativeTo(location));
            }
            ++n2;
        }
        return null;
    }

    public Path convertToAbsolute(Path path) {
        if (path != null && path.segmentCount() > 0) {
            String projectName = path.segment(0);
            IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (project.isAccessible() && projectName.equals(project.getName())) {
                    return new Path(project.getLocation().toPortableString()).append(path.removeFirstSegments(1));
                }
                ++n2;
            }
        }
        return null;
    }

    private static final class Resources
    extends NLS {
        public static String label;

        static {
            Resources.initializeMessages((String)WorkspaceRelativePathBrowseActionHandler.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

